/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public final class Security {
    private static AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static Object runAs(Subject subject, PrivilegedAction privilegedAction) {
        AuthenticatedSubject authenticatedSubject = AuthenticatedSubject.getFromSubject((Subject)subject);
        return SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)privilegedAction);
    }

    public static Object runAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        AuthenticatedSubject authenticatedSubject = AuthenticatedSubject.getFromSubject((Subject)subject);
        return SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)privilegedExceptionAction);
    }

    public static Subject getCurrentSubject() {
        return SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelID).getSubject();
    }
}

