/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.security.AccessController;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.ManagementException;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.configuration.SecurityMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.RealmRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServerSecurityRuntimeMBean;
import weblogic.security.RealmRuntime;
import weblogic.security.acl.Security;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public final class SecurityRuntime
extends RuntimeMBeanDelegate
implements ServerSecurityRuntimeMBean {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private RealmRuntimeMBean defaultRealmRuntime = new RealmRuntime(SecurityServiceManager.getDefaultRealmName(), this);

    private static RuntimeAccess getRuntimeAccess() {
        return ManagementService.getRuntimeAccess(kernelId);
    }

    public SecurityRuntime(SecurityConfigurationMBean securityConfigurationMBean, SecurityMBean securityMBean) throws ManagementException {
        super(SecurityRuntime.getRuntimeAccess().getServerName(), (RuntimeMBean)SecurityRuntime.getRuntimeAccess().getServerRuntime(), true, (DescriptorBean)securityConfigurationMBean);
        securityMBean.setServerSecurityRuntime(this);
        SecurityRuntime.getRuntimeAccess().getServerRuntime().setServerSecurityRuntime(this);
    }

    public RealmRuntimeMBean getDefaultRealmRuntime() {
        return this.defaultRealmRuntime;
    }

    public boolean isJACCEnabled() {
        return SecurityServiceManager.isJACCEnabled();
    }

    public long getUserLockoutTotalCount() {
        return Security.getUserLockoutTotalCount();
    }

    public long getInvalidLoginAttemptsTotalCount() {
        return Security.getInvalidLoginAttemptsTotalCount();
    }

    public long getLoginAttemptsWhileLockedTotalCount() {
        return Security.getLoginAttemptsWhileLockedTotalCount();
    }

    public long getInvalidLoginUsersHighCount() {
        return Security.getInvalidLoginUsersHighCount();
    }

    public long getUnlockedUsersTotalCount() {
        return Security.getUnlockedUsersTotalCount();
    }

    public long getLockedUsersCurrentCount() {
        return Security.getLockedUsersCurrentCount();
    }

    public boolean isLockedOut(String string) {
        return Security.getPasswordGuessing().runtimeIsLocked(string);
    }

    public void clearLockout(String string) {
        Security.getPasswordGuessing().runtimeClearLockout(string);
    }

    public long getLastLoginFailure(String string) {
        return Security.getPasswordGuessing().getLastLoginFailure(string);
    }

    public int getLoginFailureCount(String string) {
        return Security.getPasswordGuessing().getLoginFailureCount(string);
    }
}

