/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import com.bea.common.security.jdkutils.X509CertificateFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import weblogic.common.T3User;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationError;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.configuration.SecurityMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.security.SecurityLogger;
import weblogic.security.SecurityRuntime;
import weblogic.security.SingleSignOnServicesRuntime;
import weblogic.security.acl.BasicRealm;
import weblogic.security.acl.CachingRealm;
import weblogic.security.acl.CertAuthentication;
import weblogic.security.acl.ListableRealm;
import weblogic.security.acl.ManageableRealm;
import weblogic.security.acl.Realm;
import weblogic.security.acl.Security;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.ClusterRealm;
import weblogic.security.acl.internal.FileRealm;
import weblogic.security.audit.Audit;
import weblogic.security.audit.AuditProvider;
import weblogic.security.internal.SecurityConfigurationValidator;
import weblogic.security.net.ConnectionFilter;
import weblogic.security.net.ConnectionFilterRulesListener;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.SecurityServiceRuntimeException;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.utils.CertPathTrustManagerUtils;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.NestedRuntimeException;

public class SecurityService
extends AbstractServerService
implements PropertyChangeListener {
    private BasicRealm oldSecRealm = null;
    private AuditProvider oldAudit = null;
    private static SecurityService singleton = null;
    private SecurityMBean oldMbean = null;
    private SecurityConfigurationMBean newMbean = null;
    private RuntimeMBean runtime;
    private SecurityServiceManager securityServiceManager = null;
    private static LoggerWrapper log = LoggerWrapper.getInstance("SecurityService");
    private static final String DEFAULT_REALM = "weblogic.security.acl.internal.FileRealm";
    private static final String WLREALMNAME = "weblogic";
    private static boolean enableConnectionFilter = false;
    private static boolean enableConnectionLogger = false;
    private static boolean enableCompatibilityFilters = false;
    private static Object filterObject;
    private static String filterClass;
    private static final AuthenticatedSubject kernelId;
    private SecurityConfigurationValidator securityConfigurationValidator = null;

    public SecurityService() {
        if (singleton != null) {
            throw new InternalError(SecurityLogger.getSecurityAlreadyConfigured());
        }
        singleton = this;
        this.securityConfigurationValidator = SecurityConfigurationValidator.getInstance();
    }

    public static SecurityService getSecurityService() {
        return singleton;
    }

    public void start() throws ServiceFailureException {
        try {
            X509CertificateFactory.register();
            this.initializeMBean();
            this.initializeConnectionFilter();
            SecurityServiceManager securityServiceManager = new SecurityServiceManager(kernelId);
            securityServiceManager.initialize(kernelId);
            this.securityServiceManager = securityServiceManager;
            this.initializeRuntimeMBeans();
            this.securityConfigurationValidator.start();
        }
        catch (SecurityServiceRuntimeException securityServiceRuntimeException) {
            throw new ServiceFailureException((Throwable)securityServiceRuntimeException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            SecurityLogger.logStackTrace((Throwable)exception);
            throw new ServiceFailureException((Throwable)exception);
        }
    }

    private T3User getAdminUser() {
        String string = ManagementService.getPropertyService(kernelId).getTimestamp1();
        String string2 = ManagementService.getPropertyService(kernelId).getTimestamp2();
        return new T3User(string, string2);
    }

    public void stop() throws ServiceFailureException {
        this.securityConfigurationValidator.stop();
        CertPathTrustManagerUtils.stop();
    }

    public void halt() throws ServiceFailureException {
        this.securityConfigurationValidator.halt();
        CertPathTrustManagerUtils.halt();
    }

    private void initializeMBean() {
        this.newMbean = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurityConfiguration();
        if (this.newMbean.getSalt() == null) {
            throw new ConfigurationError(SecurityLogger.getSaltNotSet());
        }
        this.newMbean.addPropertyChangeListener(this);
        this.oldMbean = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity();
    }

    public static final boolean getConnectionFilterEnabled() {
        return enableConnectionFilter;
    }

    public static final void setConnectionFilter(ConnectionFilter connectionFilter) {
        filterObject = connectionFilter;
    }

    public static final ConnectionFilter getConnectionFilter() {
        return (ConnectionFilter)filterObject;
    }

    public static final boolean getConnectionLoggerEnabled() {
        return enableConnectionLogger;
    }

    public static final boolean getCompatibilityConnectionFiltersEnabled() {
        return enableCompatibilityFilters;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equalsIgnoreCase("ConnectionFilterRules") && SecurityService.getConnectionFilterEnabled()) {
            this.setConnectionFilterRules();
        }
        if (string.equalsIgnoreCase("ConnectionLoggerEnabled")) {
            this.setConnectionLoggerEnabled();
        }
        if (string.equalsIgnoreCase("CompatibilityConnectionFiltersEnabled")) {
            this.setCompatibilityConnectionFiltersEnabled();
        }
    }

    private void setConnectionLoggerEnabled() {
        enableConnectionLogger = this.newMbean.getConnectionLoggerEnabled();
    }

    private void setCompatibilityConnectionFiltersEnabled() {
        enableCompatibilityFilters = this.newMbean.getCompatibilityConnectionFiltersEnabled();
    }

    private synchronized void setConnectionFilterRules() {
        block5: {
            String[] stringArray = this.newMbean.getConnectionFilterRules();
            try {
                Class<?> clazz = Class.forName(filterClass);
                if (!ConnectionFilterRulesListener.class.isAssignableFrom(clazz)) break block5;
                try {
                    String string = "setRules";
                    Class[] classArray = new Class[]{String[].class};
                    Method method = clazz.getMethod(string, classArray);
                    Object[] objectArray = new Object[]{stringArray};
                    method.invoke(filterObject, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable.toString().startsWith("java.text.ParseException")) {
                        SecurityLogger.logBootFilterCritical((String)throwable.getMessage());
                    }
                    throw invocationTargetException;
                }
            }
            catch (Throwable throwable) {
                SecurityLogger.logStackTrace((Throwable)throwable);
                throw new NestedRuntimeException(SecurityLogger.getProblemWithConnFilterRules(), throwable);
            }
        }
    }

    private void initializeConnectionFilter() {
        filterClass = this.newMbean.getConnectionFilter();
        if (filterClass != null) {
            try {
                filterObject = Class.forName(filterClass).newInstance();
                enableConnectionFilter = true;
                this.setConnectionFilterRules();
            }
            catch (Exception exception) {
                SecurityLogger.logStackTrace((Throwable)exception);
                throw new NestedRuntimeException(SecurityLogger.getProblemWithConnFilter(), (Throwable)exception);
            }
        }
        this.setConnectionLoggerEnabled();
        this.setCompatibilityConnectionFiltersEnabled();
    }

    public synchronized void initializeAuditing() {
        if (this.oldAudit != null) {
            return;
        }
        String string = this.oldMbean.getAuditProviderClassName();
        if (string != null) {
            try {
                AuditProvider auditProvider = (AuditProvider)Class.forName(string).newInstance();
                Audit.setProvider(auditProvider);
                this.oldAudit = auditProvider;
            }
            catch (Exception exception) {
                SecurityLogger.logStackTrace((Throwable)exception);
                String string2 = exception.getMessage();
                log.severe("*** Security audit provider not set correctly [" + exception.getClass().getName() + (string2 == null || string2.length() == 0 ? "" : ": " + string2) + "]");
                throw new SecurityException(SecurityLogger.getMustSetAuditProviderClassName());
            }
        }
    }

    public void initializeClusterRealm(String string) {
        ClusterRealm.THE_ONE = (ClusterRealm)Realm.getRealm("wl_realm", string, ClusterRealm.class.getName());
    }

    public synchronized void initializeRealm() {
        FileRealm fileRealm;
        if (this.oldSecRealm != null) {
            return;
        }
        T3User t3User = this.getAdminUser();
        ManageableRealm manageableRealm = fileRealm = (FileRealm)Realm.getRealm(WLREALMNAME, t3User, DEFAULT_REALM);
        if (this.oldMbean.getRealm().getCachingRealm() != null) {
            String string = this.oldMbean.getRealm().getCachingRealm().getBasicRealm().getRealmClassName();
            if (string == null || string.length() == 0) {
                String string2 = this.oldMbean.getRealm().getCachingRealm().getBasicRealm().getName();
                throw new SecurityException(SecurityLogger.getMustSetRealmClassName((String)string2));
            }
            BasicRealm basicRealm = Realm.getRealm("custom", t3User, string);
            CachingRealm cachingRealm = new CachingRealm((ListableRealm)basicRealm, fileRealm, t3User);
            cachingRealm.masqueradeAs(WLREALMNAME);
            Security.init(cachingRealm);
            manageableRealm = cachingRealm;
        } else {
            Security.init(fileRealm);
        }
        fileRealm.loadMembers();
        fileRealm.addRuntimeACLs();
        this.oldSecRealm = manageableRealm;
    }

    public void initializeCertAuthentication() {
        CertAuthentication.setup();
    }

    private void initializeRuntimeMBeans() {
        try {
            new SecurityRuntime(this.newMbean, this.oldMbean);
            new SingleSignOnServicesRuntime();
        }
        catch (ManagementException managementException) {
            SecurityLogger.logErrorCreatingSecurityRuntime((Throwable)managementException);
        }
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

