/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import com.bea.common.security.service.SAML2PublishException;
import com.bea.common.security.service.SAML2Service;
import java.security.AccessController;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.SingleSignOnServicesRuntimeMBean;
import weblogic.management.utils.AlreadyExistsException;
import weblogic.management.utils.CreateException;
import weblogic.management.utils.InvalidParameterException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;

public final class SingleSignOnServicesRuntime
extends RuntimeMBeanDelegate
implements SingleSignOnServicesRuntimeMBean {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    private static RuntimeAccess getRuntimeAccess() {
        return ManagementService.getRuntimeAccess(kernelId);
    }

    public SingleSignOnServicesRuntime() throws ManagementException {
        super(SingleSignOnServicesRuntime.getRuntimeAccess().getServerName(), (RuntimeMBean)SingleSignOnServicesRuntime.getRuntimeAccess().getServerRuntime(), true, (DescriptorBean)SingleSignOnServicesRuntime.getRuntimeAccess().getServer().getSingleSignOnServices());
        SingleSignOnServicesRuntime.getRuntimeAccess().getServerRuntime().setSingleSignOnServicesRuntime(this);
    }

    public void publish(String string) throws InvalidParameterException {
        try {
            this.publish(string, false);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw invalidParameterException;
        }
        catch (Exception exception) {
            throw new InvalidParameterException(exception.getMessage(), exception);
        }
    }

    public void publish(String string, boolean bl) throws InvalidParameterException, CreateException, AlreadyExistsException {
        try {
            SAML2Service sAML2Service = (SAML2Service)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)SingleSignOnServicesRuntime.getRuntimeAccess().getDomain().getSecurityConfiguration().getDefaultRealm().getName(), (SecurityService.ServiceType)SecurityService.ServiceType.SAML2_SSO);
            if (sAML2Service == null) {
                throw new CreateException("SAML2Service Unavailable");
            }
            sAML2Service.publish(string, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidParameterException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (SAML2PublishException sAML2PublishException) {
            if (sAML2PublishException instanceof SAML2PublishException.OverwriteProhibitedException) {
                throw new AlreadyExistsException(sAML2PublishException.getMessage(), sAML2PublishException);
            }
            if (sAML2PublishException instanceof SAML2PublishException.FileCreateException) {
                throw new InvalidParameterException(sAML2PublishException.getMessage(), sAML2PublishException);
            }
            throw new CreateException(sAML2PublishException.getMessage(), sAML2PublishException);
        }
    }
}

