/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import weblogic.security.auth.callback.URLCallback;

public class URLCallbackHandler
implements CallbackHandler {
    private String url;
    private String username;
    private byte[] password;

    public URLCallbackHandler(String string, String string2) {
        this(string, string2.getBytes());
    }

    public URLCallbackHandler(String string, byte[] byArray) {
        this.url = null;
        this.username = string;
        this.password = byArray;
    }

    public URLCallbackHandler(String string, String string2, String string3) {
        this(string, string2.getBytes(), string3);
    }

    public URLCallbackHandler(String string, byte[] byArray, String string2) {
        this.url = string2;
        this.username = string;
        this.password = byArray;
    }

    public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
        for (int i = 0; i < callbackArray.length; ++i) {
            Callback callback;
            if (callbackArray[i] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[i];
                ((NameCallback)callback).setName(this.username);
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[i];
                if (this.password == null) continue;
                ((PasswordCallback)callback).setPassword(new String(this.password).toCharArray());
                continue;
            }
            if (callbackArray[i] instanceof URLCallback) {
                callback = (URLCallback)callbackArray[i];
                if (this.url != null) {
                    ((URLCallback)callback).setURL(this.url);
                    continue;
                }
                ((URLCallback)callback).setURL(((URLCallback)callback).getdefaultURL());
                continue;
            }
            throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized Callback");
        }
    }
}

