/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import weblogic.security.Salt;
import weblogic.security.SecurityMessagesTextFormatter;
import weblogic.security.UsernameAndPassword;
import weblogic.security.internal.ServerAuthenticate;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.security.internal.encryption.JSafeEncryptionServiceFactory;

public class UserConfigFileManager
implements Map {
    static final String DEFAULT_KEY_FILE_NAME = "-WebLogicKey.properties";
    static final String DEFAULT_CONFIG_FILE_NAME = "-WebLogicConfig.properties";
    static final String DEFAULT_FILE_HOME_PROP = "user.home";
    static final String DEFAULT_FILE_USER_PROP = "user.name";
    static final String DEFAULT_FILE_USER = "user";
    static final String DEFAULT_FILE_HOME = ".";
    static final String DEFAULT_USERNAME_PROP = ".username";
    static final String DEFAULT_PASSWORD_PROP = ".password";
    static final String CONFIG_FILE_HEADER = "WebLogic User Configuration File";
    static final int VERSION = 2;
    private String configFileName = null;
    private FileInputStream configIn = null;
    private Properties configProperties = null;
    private String propName = null;
    private String keyFileName = null;
    private boolean debugUserConfig = false;
    private static ClearOrEncryptedService encrypter = null;
    static final String myvalue = "0xfe593a5c23b88c112b3c674e33ea4c7901e26a7c";

    public UserConfigFileManager() {
        this.configFileName = null;
        this.keyFileName = null;
    }

    public UserConfigFileManager(String string, String string2) {
        this.configFileName = string;
        this.keyFileName = string2;
    }

    public void setDebug(boolean bl) {
        this.debugUserConfig = bl;
    }

    public boolean getDebug() {
        return this.debugUserConfig;
    }

    public static UsernameAndPassword getUsernameAndPassword(String string) {
        UserConfigFileManager userConfigFileManager = new UserConfigFileManager();
        userConfigFileManager.debug("DBG: UserConfigFileManager.getUsernameAndPassword(-" + string + "-)");
        userConfigFileManager.setPropName(string);
        try {
            userConfigFileManager.initEncryptionRead(false);
        }
        catch (KeyException keyException) {
            return null;
        }
        return userConfigFileManager.retrieveUandPValues();
    }

    public static void setUsernameAndPassword(UsernameAndPassword usernameAndPassword, String string) {
        UserConfigFileManager userConfigFileManager = new UserConfigFileManager();
        userConfigFileManager.debug("DBG: UserConfigFileManager.setUsernameAndPassword(UsernameAndPassword, -" + string + "-)");
        userConfigFileManager.setPropName(string);
        try {
            userConfigFileManager.initEncryption(true);
        }
        catch (KeyException keyException) {
            return;
        }
        usernameAndPassword.setEncryption(encrypter);
        userConfigFileManager.putUandPValues(usernameAndPassword);
    }

    public static UsernameAndPassword getUsernameAndPassword(String string, String string2, String string3) {
        UserConfigFileManager userConfigFileManager = new UserConfigFileManager(string, string2);
        userConfigFileManager.debug("DBG: UserConfigFileManager.getUsernameAndPassword(" + string + "," + string2 + "," + string3 + ")");
        try {
            userConfigFileManager.initEncryptionRead(false);
        }
        catch (KeyException keyException) {
            return null;
        }
        userConfigFileManager.setPropName(string3);
        return userConfigFileManager.retrieveUandPValues();
    }

    public static void setUsernameAndPassword(UsernameAndPassword usernameAndPassword, String string, String string2, String string3) {
        UserConfigFileManager userConfigFileManager = new UserConfigFileManager(string, string2);
        userConfigFileManager.debug("DBG: UserConfigFileManager.setUsernameAndPassword(UsernameAndPassword," + string + "," + string2 + "," + string3 + ")");
        try {
            userConfigFileManager.initEncryption(true);
        }
        catch (KeyException keyException) {
            return;
        }
        usernameAndPassword.setEncryption(encrypter);
        userConfigFileManager.setPropName(string3);
        userConfigFileManager.putUandPValues(usernameAndPassword);
    }

    public static String getDefaultConfigFileName() {
        UserConfigFileManager userConfigFileManager = new UserConfigFileManager();
        userConfigFileManager.debug("DBG: UserConfigFileManager.getDefaultConfigFileName()");
        userConfigFileManager.resolveConfigFileName();
        return userConfigFileManager.configFileName;
    }

    public static String getDefaultKeyFileName() {
        UserConfigFileManager userConfigFileManager = new UserConfigFileManager();
        userConfigFileManager.debug("DBG: UserConfigFileManager.getDefaultKeyFileName()");
        userConfigFileManager.resolveKeyFileName();
        return userConfigFileManager.keyFileName;
    }

    public void load() throws FileNotFoundException, IOException {
        this.debug("DBG: UserConfigFileManager.load()");
        this.configProperties = new Properties();
        this.configIn = new FileInputStream(this.configFileName);
        this.configProperties.load(this.configIn);
        this.configIn.close();
    }

    public void refresh() throws IOException {
        this.debug("DBG: UserConfigFileManager.refresh()");
        throw new UnsupportedOperationException();
    }

    public void store() throws FileNotFoundException, IOException {
        this.debug("DBG: UserConfigFileManager.store()");
        FileOutputStream fileOutputStream = new FileOutputStream(this.configFileName);
        try {
            this.configProperties.store(fileOutputStream, "WebLogic User Configuration File; " + String.valueOf(2));
            fileOutputStream.close();
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Could not convert property to correct type while storing configuration");
        }
    }

    public void clear() {
        this.debug("DBG: UserConfigFileManager.clear()");
        this.configProperties.clear();
    }

    public boolean containsKey(Object object) {
        this.debug("DBG: UserConfigFileManager.containsKey(Object)");
        return this.configProperties.containsKey(object);
    }

    public boolean containsValue(Object object) {
        this.debug("DBG: UserConfigFileManager.containsValue(Object)");
        return this.configProperties.containsValue(object);
    }

    public Set entrySet() {
        this.debug("DBG: UserConfigFileManager.entrySet()");
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        this.debug("DBG: UserConfigFileManager.equals(Object)");
        throw new UnsupportedOperationException();
    }

    public Object get(Object object) {
        this.debug("DBG: UserConfigFileManager.get(Object)");
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        this.debug("DBG: UserConfigFileManager.hashCode()");
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        this.debug("DBG: UserConfigFileManager.isEmpty()");
        return this.configProperties.isEmpty();
    }

    public Set keySet() {
        this.debug("DBG: UserConfigFileManager.keySet()");
        throw new UnsupportedOperationException();
    }

    public Object put(Object object, Object object2) {
        this.debug("DBG: UserConfigFileManager.put(Object, Object)");
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        this.debug("DBG: UserConfigFileManager.putAll(Map)");
        throw new UnsupportedOperationException();
    }

    public Object remove(Object object) {
        this.debug("DBG: UserConfigFileManager.remove(Object)");
        throw new UnsupportedOperationException();
    }

    public int size() {
        this.debug("DBG: UserConfigFileManager.size()");
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        this.debug("DBG: UserConfigFileManager.values()");
        throw new UnsupportedOperationException();
    }

    private void resolveConfigFileName() {
        this.debug("DBG: UserConfigFileManager.resolveConfigFile()");
        if (this.configFileName == null) {
            String string;
            String string2 = System.getProperty(DEFAULT_FILE_HOME_PROP);
            if (string2 == null) {
                string2 = DEFAULT_FILE_HOME;
            }
            if ((string = System.getProperty(DEFAULT_FILE_USER_PROP)) == null) {
                string = DEFAULT_FILE_USER;
            }
            this.configFileName = new String(string2 + "/" + string + DEFAULT_CONFIG_FILE_NAME);
            this.debug("DBG: default config file name: " + this.configFileName);
        } else {
            this.debug("DBG: config file name: " + this.configFileName);
        }
    }

    private void resolveKeyFileName() {
        this.debug("DBG: UserConfigFileManager.resolveKeyFileName()");
        if (this.keyFileName == null) {
            String string;
            String string2 = System.getProperty(DEFAULT_FILE_HOME_PROP);
            if (string2 == null) {
                string2 = DEFAULT_FILE_HOME;
            }
            if ((string = System.getProperty(DEFAULT_FILE_USER_PROP)) == null) {
                string = DEFAULT_FILE_USER;
            }
            this.keyFileName = new String(string2 + "/" + string + DEFAULT_KEY_FILE_NAME);
            this.debug("DBG: default key file name: " + this.keyFileName);
        } else {
            this.debug("DBG: key file name: " + this.keyFileName);
        }
    }

    private void setPropName(String string) {
        this.debug("DBG: UserConfigFileManager.setPropName(-" + (string == null ? "null" : string) + "-)");
        this.propName = new String(string);
    }

    private String getPropName() {
        this.debug("DBG: UserConfigFilemanager.getPropName(); returning: " + this.propName);
        return this.propName;
    }

    private void putUandPValues(UsernameAndPassword usernameAndPassword) {
        this.debug("DBG: UserConfigFileManager.putUandPValues()");
        this.resolveConfigFileName();
        if (encrypter == null) {
            this.debug("DBG: encrypter is null; should already be initialized");
            return;
        }
        try {
            this.load();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.debug("DBG: FileNotFoundException loading config file, may not exist; NOT AN ERROR");
        }
        catch (IOException iOException) {
            this.debug("DBG: IOException loading config file, may not exist; NOT AN ERROR");
        }
        try {
            if (this.ensureEncrypted()) {
                this.store();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Unable to create or write the user configuration file. Check that the filename is correctly specified.");
            return;
        }
        catch (IOException iOException) {
            System.err.println("Unable to write the user configuration file.  Check that the directory is writable.");
            return;
        }
        this.setUandP(usernameAndPassword);
        try {
            this.store();
        }
        catch (IOException iOException) {
            System.err.println("Unable to create or write the user configuration file. Check that the filename is correctly specified and writable.");
        }
    }

    private UsernameAndPassword retrieveUandPValues() {
        this.debug("DBG: UserConfigFileManager.retrieveUandPValues()");
        this.resolveConfigFileName();
        if (encrypter == null) {
            this.debug("DBG: encrypter is null; should already be initialized");
            return null;
        }
        try {
            this.load();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("User configuration file was not found.  Check location of the file.");
            return null;
        }
        catch (IOException iOException) {
            System.err.println("IO error loading user configuration file.  Check location and protection of file.");
            return null;
        }
        try {
            if (this.ensureEncrypted()) {
                this.store();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("User configuration file was not found. Check location of the file.");
            return null;
        }
        catch (IOException iOException) {
            System.err.println("IO error storing user configuration.  Check location and protection of user's configuration file.");
            return null;
        }
        return this.getUandP();
    }

    private UsernameAndPassword getUandP() {
        String string;
        this.debug("DBG: UserConfigFileManager.getUandP()");
        UsernameAndPassword usernameAndPassword = new UsernameAndPassword();
        this.debug("DBG: UserConfigFileManager.getUandP(); setting encrypter on UsernameAndPassword");
        usernameAndPassword.setEncryption(encrypter);
        if (this.containsKey(this.getPropName() + DEFAULT_USERNAME_PROP)) {
            string = this.configProperties.getProperty(this.getPropName() + DEFAULT_USERNAME_PROP);
            usernameAndPassword.setUsername(encrypter.decrypt(string));
        }
        if (this.containsKey(this.getPropName() + DEFAULT_PASSWORD_PROP)) {
            string = this.configProperties.getProperty(this.getPropName() + DEFAULT_PASSWORD_PROP);
            usernameAndPassword.setPassword(encrypter.decrypt(string).toCharArray());
        }
        return usernameAndPassword;
    }

    private static final void clear(byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
    }

    private void setUandP(UsernameAndPassword usernameAndPassword) {
        if (usernameAndPassword.getUsername() != null) {
            this.configProperties.setProperty(this.getPropName() + DEFAULT_USERNAME_PROP, encrypter.encrypt(usernameAndPassword.getUsername()));
        }
        this.configProperties.setProperty(this.getPropName() + DEFAULT_PASSWORD_PROP, encrypter.encrypt(new String(usernameAndPassword.getPassword())));
    }

    private boolean verifyKeyCreate() {
        String string = System.getProperty("weblogic.management.confirmKeyfileCreation", "false");
        SecurityMessagesTextFormatter securityMessagesTextFormatter = new SecurityMessagesTextFormatter();
        if (string == null || string != null && !string.equalsIgnoreCase("true")) {
            try {
                String string2 = securityMessagesTextFormatter.getUserKeyConfigCreateNegative();
                String string3 = securityMessagesTextFormatter.getUserKeyConfigCreateAffirmative();
                String string4 = ServerAuthenticate.promptValue(securityMessagesTextFormatter.getUserKeyConfigCreatePrompt(string3, string2), true);
                if (string4 != null && string4.equalsIgnoreCase(string3)) {
                    return true;
                }
                if (string4 != null && string4.equalsIgnoreCase(string2)) {
                    return false;
                }
                string4 = ServerAuthenticate.promptValue(securityMessagesTextFormatter.getUserKeyConfigCreateConfig(string3, string2), true);
                if (string4 != null && string4.equalsIgnoreCase(string3)) {
                    return true;
                }
                if (string4 != null && string4.equalsIgnoreCase(string2)) {
                    return false;
                }
                System.out.println(securityMessagesTextFormatter.getUserKeyConfigCreateFailure());
                return false;
            }
            catch (Exception exception) {
                System.err.println("Error: Failed To Get Response from Standard Input");
            }
        } else if (string.equalsIgnoreCase("true")) {
            String string5 = securityMessagesTextFormatter.getUserKeyConfigCreateNoPrompt();
            System.out.println(string5);
            return true;
        }
        return false;
    }

    private boolean ensureEncrypted() {
        this.debug("DBG: UserConfigFileManager.ensureEncrypted()");
        boolean bl = false;
        if (this.configProperties.isEmpty()) {
            return bl;
        }
        Enumeration<?> enumeration = this.configProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.configProperties.getProperty(string);
            this.debug("DBG: UserConfigFileManager.ensureEncrypted(); checking: " + string);
            if (encrypter.isEncrypted(string2)) continue;
            bl = true;
            this.debug("DBG: UserConfigFileManager.ensureEncrypted(); encrypting: " + string2);
            this.configProperties.setProperty(string, encrypter.encrypt(string2));
        }
        return bl;
    }

    private void initEncryptionRead(boolean bl) throws KeyException {
        this.debug("DBG: UserConfigFileManager.initEncryptionRead(boolean " + bl + ")");
        this.resolveKeyFileName();
        File file = new File(this.keyFileName);
        if (file.exists()) {
            Object object;
            if (bl) {
                object = new SecurityMessagesTextFormatter();
                System.out.println(object.getUsingExistingKeyFile());
            }
            try {
                object = new FileInputStream(file);
                int n = ((FileInputStream)object).read();
                byte[] byArray = new byte[n];
                ((FileInputStream)object).read(byArray);
                int n2 = ((FileInputStream)object).read();
                if (n2 > 2) {
                    System.err.println("Version mismatch between key and supported version; will try to continue");
                }
                n = ((FileInputStream)object).read();
                byte[] byArray2 = new byte[n];
                ((FileInputStream)object).read(byArray2);
                byte[] byArray3 = null;
                if (n2 >= 2) {
                    n = ((FileInputStream)object).read();
                    byArray3 = new byte[n];
                    ((FileInputStream)object).read(byArray3);
                }
                ((FileInputStream)object).close();
                JSafeEncryptionServiceFactory jSafeEncryptionServiceFactory = new JSafeEncryptionServiceFactory();
                EncryptionService encryptionService = jSafeEncryptionServiceFactory.getEncryptionService(byArray, myvalue, byArray2, byArray3);
                encrypter = new ClearOrEncryptedService(encryptionService);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Error: Secret key file was not found. Check the location of the key file.");
                return;
            }
            catch (IOException iOException) {
                System.err.println("Error: Not able to read secret key file. Check the location and access priviledges of key file.");
                return;
            }
        } else {
            throw new KeyException();
        }
    }

    private void initEncryption(boolean bl) throws KeyException {
        this.debug("DBG: UserConfigFileManager.initEncryption(boolean " + bl + ")");
        boolean bl2 = false;
        try {
            this.initEncryptionRead(bl);
        }
        catch (KeyException keyException) {
            bl2 = true;
        }
        if (!bl2) {
            return;
        }
        JSafeEncryptionServiceFactory jSafeEncryptionServiceFactory = new JSafeEncryptionServiceFactory();
        this.resolveKeyFileName();
        try {
            File file;
            if (this.verifyKeyCreate()) {
                this.debug("DBG: key creation verified");
                file = new File(this.keyFileName);
                if (file.exists()) {
                    file.delete();
                }
            } else {
                throw new KeyException("Secured key storage aborted");
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = Salt.getRandomBytes(4);
            byte[] byArray2 = jSafeEncryptionServiceFactory.createEncryptedSecretKey(byArray, myvalue);
            byte[] byArray3 = jSafeEncryptionServiceFactory.createAESEncryptedSecretKey(byArray, myvalue);
            fileOutputStream.write(byArray.length);
            fileOutputStream.write(byArray);
            fileOutputStream.write(2);
            fileOutputStream.write(byArray2.length);
            fileOutputStream.write(byArray2);
            fileOutputStream.write(byArray3.length);
            fileOutputStream.write(byArray3);
            fileOutputStream.flush();
            fileOutputStream.close();
            EncryptionService encryptionService = jSafeEncryptionServiceFactory.getEncryptionService(byArray, myvalue, byArray2, byArray3);
            encrypter = new ClearOrEncryptedService(encryptionService);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error: Not able to write secret key file.  Check the specified location for the file.");
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error: Not able to write secret key file.  Check the location and priviledges of the specified file location.");
            return;
        }
    }

    void debug(String string) {
        if (this.getDebug()) {
            System.out.println(string);
        }
    }
}

