/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.io.Serializable;
import java.util.Arrays;
import weblogic.security.internal.encryption.ClearOrEncryptedService;

public class UsernameAndPassword
implements Serializable {
    private String username = null;
    private byte[] password = null;
    private ClearOrEncryptedService es = null;

    public UsernameAndPassword() {
    }

    public UsernameAndPassword(String string, char[] cArray) {
        this.setUsername(string);
        this.setPassword(cArray);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public char[] getPassword() {
        if (this.password == null) {
            return null;
        }
        byte[] byArray = this.es == null ? this.password : this.es.decryptBytes(this.password);
        char[] cArray = UsernameAndPassword.getUTF16Chars(byArray);
        if (byArray != this.password) {
            Arrays.fill(byArray, (byte)0);
        }
        return cArray;
    }

    public void setPassword(char[] cArray) {
        byte[] byArray = null;
        if (cArray != null) {
            byte[] byArray2;
            byArray = UsernameAndPassword.getUTF16Bytes(cArray);
            if (this.es != null && (byArray2 = byArray) != (byArray = this.es.encryptBytes(byArray2))) {
                Arrays.fill(byArray2, (byte)0);
            }
        }
        if (this.password != null) {
            Arrays.fill(this.password, (byte)0);
        }
        this.password = byArray;
    }

    public boolean isPasswordSet() {
        return this.password != null;
    }

    public boolean isUsernameSet() {
        return this.username != null;
    }

    public void setEncryption(ClearOrEncryptedService clearOrEncryptedService) {
        if (this.password != null) {
            byte[] byArray;
            byte[] byArray2 = this.es != null ? this.es.decryptBytes(this.password) : this.password;
            byte[] byArray3 = byArray = clearOrEncryptedService != null ? clearOrEncryptedService.encryptBytes(byArray2) : byArray2;
            if (byArray2 != byArray) {
                Arrays.fill(byArray2, (byte)0);
            }
            if (this.password != byArray) {
                Arrays.fill(this.password, (byte)0);
            }
            this.password = byArray;
        }
        this.es = clearOrEncryptedService;
    }

    public void dispose() {
        this.setPassword(null);
        this.setUsername(null);
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private static final char[] getUTF16Chars(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length % 2 == 1) {
            throw new IllegalArgumentException("Odd byte array length: " + byArray.length);
        }
        char[] cArray = new char[byArray.length / 2];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)((0xFF & byArray[n++]) << 8 | 0xFF & byArray[n++]);
        }
        return cArray;
    }

    private static final byte[] getUTF16Bytes(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            byArray[n++] = (byte)(cArray[i] >>> 8 & 0xFF);
            byArray[n++] = (byte)(cArray[i] & 0xFF);
        }
        return byArray;
    }
}

