/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.Group;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weblogic.security.acl.BasicRealm;
import weblogic.security.acl.CachingRealm;
import weblogic.security.acl.CertAuthentication;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.FlatGroup;
import weblogic.security.acl.ListableRealm;
import weblogic.security.acl.SSLUserInfo;
import weblogic.security.acl.User;
import weblogic.security.acl.UserInfo;
import weblogic.security.audit.Audit;

public abstract class AbstractListableRealm
implements ListableRealm,
FlatGroup.Source {
    private String name;
    private String auditName;
    private Object delegator;
    private CachingRealm alligator;

    protected AbstractListableRealm(String string) {
        this.auditName = string != null ? string : "Custom Realm";
    }

    public void init(String string, Object object) throws NotOwnerException {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public User getUser(String string) {
        throw new UnsupportedOperationException("getUser not supported");
    }

    public User getUser(UserInfo userInfo) {
        return this.authenticate(userInfo);
    }

    public User authenticate(UserInfo userInfo) {
        User user = this.authInternal(userInfo);
        Audit.authenticateUser(this.auditName, userInfo, user);
        return user;
    }

    protected User authInternal(UserInfo userInfo) {
        User user = null;
        if (userInfo instanceof DefaultUserInfoImpl) {
            DefaultUserInfoImpl defaultUserInfoImpl = (DefaultUserInfoImpl)userInfo;
            String string = defaultUserInfoImpl.getName();
            if (defaultUserInfoImpl.hasCertificates()) {
                user = this.authCertificates(string, defaultUserInfoImpl.getCertificates());
            }
            if (user == null && defaultUserInfoImpl.hasPassword()) {
                user = this.authUserPassword(string, defaultUserInfoImpl.getPassword());
            }
            if (user == null && defaultUserInfoImpl instanceof SSLUserInfo) {
                SSLUserInfo sSLUserInfo = (SSLUserInfo)defaultUserInfoImpl;
                user = this.authSSLCertificates(string, sSLUserInfo.getSSLCertificates());
            }
        }
        return user;
    }

    protected User authCertificates(String string, Vector vector) {
        return CertAuthentication.authenticate(string, vector, false);
    }

    protected User authSSLCertificates(String string, Vector vector) {
        return CertAuthentication.authenticate(string, vector, true);
    }

    protected User authUserPassword(String string, String string2) {
        return null;
    }

    public Principal getAclOwner(Object object) {
        throw new UnsupportedOperationException("getAclOwner not supported");
    }

    public Hashtable getGroupMembers(String string) {
        Group group;
        Hashtable hashtable = null;
        if (this.alligator != null && (group = this.alligator.lookupGroup(string)) != null && group instanceof FlatGroup) {
            hashtable = ((FlatGroup)group).getMembersHashtable();
        }
        if (hashtable == null) {
            hashtable = this.getGroupMembersInternal(string);
        }
        return hashtable;
    }

    protected Hashtable getGroupMembersInternal(String string) {
        throw new UnsupportedOperationException("getGroupMembersInternal not supported");
    }

    public Group getGroup(String string) {
        throw new UnsupportedOperationException("getGroup not supported");
    }

    public Acl getAcl(String string) {
        throw new UnsupportedOperationException("getAcl not supported");
    }

    public Acl getAcl(String string, char c) {
        Acl acl = this.getAcl(string);
        int n = string.lastIndexOf(c);
        while (acl == null && n >= 0) {
            string = string.substring(0, n);
            acl = this.getAcl(string);
            n = string.lastIndexOf(c, n - 1);
        }
        return acl;
    }

    public Permission getPermission(String string) {
        throw new UnsupportedOperationException("getPermission not supported");
    }

    public void load(String string, Object object) throws ClassNotFoundException, IOException, NotOwnerException {
    }

    public void save(String string) throws IOException {
    }

    public Enumeration getUsers() {
        throw new UnsupportedOperationException("getUsers not supported");
    }

    public Enumeration getGroups() {
        throw new UnsupportedOperationException("getGroups not supported");
    }

    public Enumeration getAcls() {
        throw new UnsupportedOperationException("getAcls not supported");
    }

    public Enumeration getPermissions() {
        throw new UnsupportedOperationException("getPermissions not supported");
    }

    public void setDelegator(Object object) {
        if (this.delegator != null) {
            throw new SecurityException("attempt to change delegator");
        }
        if (!(object instanceof BasicRealm)) {
            throw new SecurityException("attempt to set a non-realm as delegator");
        }
        this.delegator = object;
        if (object instanceof CachingRealm) {
            this.alligator = (CachingRealm)object;
        }
    }

    public Object getDelegator() {
        return this.delegator;
    }
}

