/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

public final class AclEntryImpl
implements AclEntry {
    private Principal user;
    private Vector permissionSet = new Vector();
    private boolean negative = false;

    public AclEntryImpl(Principal principal) {
        this.user = principal;
    }

    public AclEntryImpl(Principal principal, Permission permission) {
        this(principal);
        this.addPermission(permission);
    }

    public AclEntryImpl(Principal principal, Permission[] permissionArray) {
        this(principal);
        for (int i = 0; i < permissionArray.length; ++i) {
            this.addPermission(permissionArray[i]);
        }
    }

    public boolean setPrincipal(Principal principal) {
        boolean bl = this.user != null;
        this.user = principal;
        return bl;
    }

    public void setNegativePermissions() {
        this.negative = true;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public boolean addPermission(Permission permission) {
        if (this.permissionSet.contains(permission)) {
            return false;
        }
        this.permissionSet.addElement(permission);
        return true;
    }

    public boolean removePermission(Permission permission) {
        return this.permissionSet.removeElement(permission);
    }

    public boolean checkPermission(Permission permission) {
        return this.permissionSet.contains(permission);
    }

    public Enumeration permissions() {
        return this.permissionSet.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.negative ? "-" : "+").append(this.user instanceof Group ? "Group." : "User.").append(this.user).append("=");
        String string = "";
        Enumeration enumeration = this.permissions();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(string).append(enumeration.nextElement());
            string = ", ";
        }
        return new String(stringBuffer);
    }

    public synchronized Object clone() {
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this.user);
        aclEntryImpl.permissionSet = (Vector)this.permissionSet.clone();
        aclEntryImpl.negative = this.negative;
        return aclEntryImpl;
    }

    public Principal getPrincipal() {
        return this.user;
    }
}

