/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;
import weblogic.security.acl.PermissionSet;
import weblogic.utils.UnsyncHashtable;

class AclGroup
implements Serializable {
    AclGroup next;
    private UnsyncHashtable individualConstraints = new UnsyncHashtable();
    private UnsyncHashtable groupConstraints = new UnsyncHashtable();
    Vector permissions = new Vector();

    AclGroup() {
    }

    final int getPermissionIndexFromHere(Object object) {
        int n = this.permissions.indexOf(object);
        if (n >= 0) {
            return n;
        }
        if (this.permissions.size() == 32) {
            return 32;
        }
        int n2 = this.permissions.size();
        if (n2 == 32) {
            return 32;
        }
        this.permissions.addElement(object);
        return n2;
    }

    int getPermissionIndex(Object object) {
        int n = this.getPermissionIndexFromHere(object);
        if (n < 32) {
            return n;
        }
        if (this.next == null && this.next == null) {
            this.next = new AclGroup();
        }
        return 32 + this.next.getPermissionIndex(object);
    }

    final PermissionSet checkPermissionSet(Principal principal) {
        UnsyncHashtable unsyncHashtable = principal instanceof Group ? this.groupConstraints : this.individualConstraints;
        return (PermissionSet)unsyncHashtable.get((Object)principal);
    }

    final PermissionSet getPermissionSet(Principal principal, int n) {
        if (n >= 32) {
            return this.next.getPermissionSet(principal, n - 32);
        }
        UnsyncHashtable unsyncHashtable = principal instanceof Group ? this.groupConstraints : this.individualConstraints;
        PermissionSet permissionSet = (PermissionSet)unsyncHashtable.get((Object)principal);
        if (permissionSet != null) {
            return permissionSet;
        }
        permissionSet = (PermissionSet)unsyncHashtable.get((Object)principal);
        if (permissionSet != null) {
            return permissionSet;
        }
        permissionSet = new PermissionSet();
        unsyncHashtable.put((Object)principal, (Object)permissionSet);
        return permissionSet;
    }

    boolean hasPositiveEntry(Principal principal) {
        PermissionSet permissionSet;
        return this.next != null && this.next.hasPositiveEntry(principal) || (permissionSet = this.checkPermissionSet(principal)) != null && permissionSet.granted != 0;
    }

    boolean hasNegativeEntry(Principal principal) {
        PermissionSet permissionSet;
        return this.next != null && this.next.hasNegativeEntry(principal) || (permissionSet = this.checkPermissionSet(principal)) != null && permissionSet.notDenied != -1;
    }

    Vector getPermissions(Principal principal, Vector vector) {
        PermissionSet permissionSet;
        if (this.next != null) {
            vector = this.next.getPermissions(principal, vector);
        }
        if ((permissionSet = (PermissionSet)this.individualConstraints.get((Object)principal)) == null) {
            permissionSet = new PermissionSet();
        }
        PermissionSet permissionSet2 = new PermissionSet();
        Enumeration enumeration = this.groupConstraints.keys();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            if (!((Object)principal).equals(group) && !group.isMember(principal)) continue;
            permissionSet2.add((PermissionSet)this.groupConstraints.get((Object)group));
        }
        int n = permissionSet.granted & permissionSet.notDenied | (permissionSet.granted | permissionSet.notDenied) & permissionSet2.granted & permissionSet2.notDenied;
        return this.addPermissions(n, vector);
    }

    private Vector addPermissions(int n, Vector vector) {
        for (int i = 0; n != 0 && i < this.permissions.size(); ++i) {
            if ((n & 1 << i) == 0) continue;
            n ^= 1 << i;
            vector.addElement(this.permissions.elementAt(i));
        }
        return vector;
    }

    int getPermission(Principal principal, Permission permission) {
        int n = this.permissions.indexOf(permission);
        if (n < 0) {
            if (this.next == null) {
                return 0;
            }
            return this.next.getPermission(principal, permission);
        }
        int n2 = 1 << n;
        PermissionSet permissionSet = (PermissionSet)this.individualConstraints.get((Object)principal);
        if (permissionSet != null) {
            if ((permissionSet.granted & permissionSet.notDenied & n2) != 0) {
                return 1;
            }
            if ((~permissionSet.granted & ~permissionSet.notDenied & n2) != 0) {
                return -1;
            }
        }
        int n3 = 0;
        Group group = null;
        Enumeration enumeration = this.groupConstraints.keys();
        while (enumeration.hasMoreElements()) {
            Group group2 = (Group)enumeration.nextElement();
            if (group2.getName().equalsIgnoreCase("Everyone")) {
                group = group2;
                continue;
            }
            if (!group2.equals(principal) && !group2.isMember(principal)) continue;
            permissionSet = (PermissionSet)this.groupConstraints.get((Object)group2);
            if ((~permissionSet.notDenied & n2) != 0) {
                return -1;
            }
            n3 |= permissionSet.granted;
        }
        if ((n3 & n2) == 1) {
            return 1;
        }
        if (group != null) {
            permissionSet = (PermissionSet)this.groupConstraints.get((Object)group);
            if ((~permissionSet.notDenied & n2) != 0) {
                return -1;
            }
            n3 |= permissionSet.granted;
        }
        return (n3 & n2) != 0 ? 1 : 0;
    }

    private StringBuffer printTable(UnsyncHashtable unsyncHashtable, StringBuffer stringBuffer) {
        Enumeration enumeration = unsyncHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            stringBuffer.append("\n");
            stringBuffer.append(e);
            stringBuffer.append(": ");
            PermissionSet permissionSet = (PermissionSet)unsyncHashtable.get(e);
            for (int i = 0; i < 32; ++i) {
                if ((1 << i & permissionSet.granted) != 0) {
                    stringBuffer.append("+").append(this.permissions.elementAt(i));
                }
                if ((1 << i & permissionSet.notDenied) != 0) continue;
                stringBuffer.append("-").append(this.permissions.elementAt(i));
            }
        }
        return stringBuffer;
    }

    String toString(StringBuffer stringBuffer) {
        if (this.next != null) {
            stringBuffer = new StringBuffer(this.next.toString(stringBuffer));
        }
        this.printTable(this.individualConstraints, stringBuffer);
        this.printTable(this.groupConstraints, stringBuffer);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    UnsyncHashtable getPrincipals(UnsyncHashtable unsyncHashtable) {
        if (this.next != null) {
            unsyncHashtable = this.next.getPrincipals(unsyncHashtable);
        }
        Enumeration enumeration = this.individualConstraints.keys();
        while (enumeration.hasMoreElements()) {
            unsyncHashtable.put(enumeration.nextElement(), (Object)"");
        }
        enumeration = this.groupConstraints.keys();
        while (enumeration.hasMoreElements()) {
            unsyncHashtable.put(enumeration.nextElement(), (Object)"");
        }
        return unsyncHashtable;
    }

    void fillEntries(Principal principal, AclEntry aclEntry, AclEntry aclEntry2) {
        PermissionSet permissionSet;
        if (this.next != null) {
            this.next.fillEntries(principal, aclEntry, aclEntry2);
        }
        if ((permissionSet = this.checkPermissionSet(principal)) == null) {
            return;
        }
        Enumeration enumeration = this.addPermissions(permissionSet.granted, new Vector()).elements();
        while (enumeration.hasMoreElements()) {
            aclEntry.addPermission((Permission)enumeration.nextElement());
        }
        enumeration = this.addPermissions(~permissionSet.notDenied, new Vector()).elements();
        while (enumeration.hasMoreElements()) {
            aclEntry2.addPermission((Permission)enumeration.nextElement());
        }
    }
}

