/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;
import weblogic.security.acl.AclEntryImpl;
import weblogic.security.acl.AclGroup;
import weblogic.security.acl.OwnerImpl;
import weblogic.utils.UnsyncHashtable;

public class AclImpl
extends OwnerImpl
implements Acl,
Serializable {
    private AclGroup info;
    private String name;

    public AclImpl(Principal principal, String string) {
        super(principal);
        this.name = string;
    }

    public void setName(Principal principal, String string) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public synchronized boolean addEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        if (this.info == null) {
            this.info = new AclGroup();
        }
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        Principal principal2 = aclEntry.getPrincipal();
        if (aclEntry.isNegative()) {
            if (this.info.hasNegativeEntry(principal2)) {
                return false;
            }
            Enumeration enumeration = aclEntry.permissions();
            while (enumeration.hasMoreElements()) {
                int n = this.info.getPermissionIndex(enumeration.nextElement());
                this.info.getPermissionSet((Principal)principal2, (int)n).notDenied &= ~(1 << (n & 0x1F));
            }
        } else {
            if (this.info.hasPositiveEntry(principal2)) {
                return false;
            }
            Enumeration enumeration = aclEntry.permissions();
            while (enumeration.hasMoreElements()) {
                int n = this.info.getPermissionIndex(enumeration.nextElement());
                this.info.getPermissionSet((Principal)principal2, (int)n).granted |= 1 << (n & 0x1F);
            }
        }
        return true;
    }

    public synchronized boolean removeEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        int n;
        Enumeration enumeration;
        if (this.info == null) {
            this.info = new AclGroup();
        }
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        Principal principal2 = aclEntry.getPrincipal();
        if (aclEntry.isNegative()) {
            enumeration = aclEntry.permissions();
            while (enumeration.hasMoreElements()) {
                n = this.info.getPermissionIndex(enumeration.nextElement());
                if ((this.info.getPermissionSet((Principal)principal2, (int)n).notDenied & 1 << (n & 0x1F)) == 0) continue;
                return false;
            }
        } else {
            enumeration = aclEntry.permissions();
            while (enumeration.hasMoreElements()) {
                n = this.info.getPermissionIndex(enumeration.nextElement());
                if ((this.info.getPermissionSet((Principal)principal2, (int)n).granted & 1 << (n & 0x1F)) != 0) continue;
                return false;
            }
        }
        enumeration = aclEntry.permissions();
        while (enumeration.hasMoreElements()) {
            n = this.info.getPermissionIndex(enumeration.nextElement());
            if (aclEntry.isNegative()) {
                this.info.getPermissionSet((Principal)principal2, (int)n).notDenied |= 1 << (n & 0x1F);
                continue;
            }
            this.info.getPermissionSet((Principal)principal2, (int)n).granted &= ~(1 << (n & 0x1F));
        }
        return true;
    }

    public synchronized Enumeration getPermissions(Principal principal) {
        Vector vector = new Vector();
        if (this.info != null) {
            return this.info.getPermissions(principal, vector).elements();
        }
        return vector.elements();
    }

    public synchronized Enumeration entries() {
        if (this.info == null) {
            this.info = new AclGroup();
        }
        Vector<AclEntryImpl> vector = new Vector<AclEntryImpl>();
        Enumeration enumeration = this.info.getPrincipals(new UnsyncHashtable()).keys();
        while (enumeration.hasMoreElements()) {
            Principal principal = (Principal)enumeration.nextElement();
            AclEntryImpl aclEntryImpl = new AclEntryImpl(principal);
            AclEntryImpl aclEntryImpl2 = new AclEntryImpl(principal);
            aclEntryImpl2.setNegativePermissions();
            this.info.fillEntries(principal, aclEntryImpl, aclEntryImpl2);
            if (aclEntryImpl.permissions().hasMoreElements()) {
                vector.addElement(aclEntryImpl);
            }
            if (!aclEntryImpl2.permissions().hasMoreElements()) continue;
            vector.addElement(aclEntryImpl2);
        }
        return vector.elements();
    }

    public synchronized boolean checkPermission(Principal principal, Permission permission) {
        return principal != null && permission != null && this.info != null && this.info.getPermission(principal, permission) > 0;
    }

    protected synchronized int getPermission(Principal principal, Permission permission) {
        if (this.info != null) {
            return this.info.getPermission(principal, permission);
        }
        return 0;
    }

    public synchronized String toString() {
        if (this.info == null) {
            this.info = new AclGroup();
        }
        StringBuffer stringBuffer = new StringBuffer("ACL ");
        stringBuffer.append(this.name);
        return this.info.toString(stringBuffer);
    }
}

