/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import weblogic.logging.LogOutputStream;
import weblogic.management.configuration.CachingRealmMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.AclEntryImpl;
import weblogic.security.acl.BasicRealm;
import weblogic.security.acl.ClosableEnumeration;
import weblogic.security.acl.DebuggableRealm;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.ListableRealm;
import weblogic.security.acl.ManageableRealm;
import weblogic.security.acl.PermissionImpl;
import weblogic.security.acl.Realm;
import weblogic.security.acl.RefreshableRealm;
import weblogic.security.acl.TTLCache;
import weblogic.security.acl.User;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.NestedRuntimeException;
import weblogic.utils.enumerations.EnumerationUtils;

public final class CachingRealm
implements ManageableRealm,
DebuggableRealm,
RefreshableRealm {
    private static final long serialVersionUID = 4045950267181139320L;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String realmName = "caching";
    protected boolean caseSensitive = true;
    protected TTLCache aclPosCache;
    protected TTLCache aclNegCache;
    protected final Object aclSync = new Object();
    protected TTLCache groupPosCache;
    protected TTLCache groupNegCache;
    protected final Object groupSync = new Object();
    protected TTLCache permPosCache;
    protected TTLCache permNegCache;
    protected final Object permSync = new Object();
    protected TTLCache userPosCache;
    protected TTLCache userNegCache;
    protected TTLCache authPosCache;
    protected TTLCache authNegCache;
    protected final Object userSync = new Object();
    protected LogOutputStream log;
    private ListableRealm delegate;
    private ManageableRealm manageable;
    private ManageableRealm backup;

    public CachingRealm(ListableRealm listableRealm) {
        this(listableRealm, null, null);
    }

    public CachingRealm(ListableRealm listableRealm, ManageableRealm manageableRealm, Object object) {
        this(ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().getRealm().getCachingRealm(), listableRealm, manageableRealm, object);
    }

    private CachingRealm(CachingRealmMBean cachingRealmMBean, ListableRealm listableRealm, ManageableRealm manageableRealm, Object object) {
        this(listableRealm, manageableRealm, cachingRealmMBean.getCacheCaseSensitive(), cachingRealmMBean.getACLCacheEnable(), cachingRealmMBean.getACLCacheSize(), cachingRealmMBean.getACLCacheTTLPositive(), cachingRealmMBean.getACLCacheTTLNegative(), cachingRealmMBean.getAuthenticationCacheEnable(), cachingRealmMBean.getAuthenticationCacheSize(), cachingRealmMBean.getAuthenticationCacheTTLPositive(), cachingRealmMBean.getAuthenticationCacheTTLNegative(), cachingRealmMBean.getGroupCacheEnable(), cachingRealmMBean.getGroupCacheSize(), cachingRealmMBean.getGroupCacheTTLPositive(), cachingRealmMBean.getGroupCacheTTLNegative(), cachingRealmMBean.getPermissionCacheEnable(), cachingRealmMBean.getPermissionCacheSize(), cachingRealmMBean.getPermissionCacheTTLPositive(), cachingRealmMBean.getPermissionCacheTTLNegative(), cachingRealmMBean.getUserCacheEnable(), cachingRealmMBean.getUserCacheSize(), cachingRealmMBean.getUserCacheTTLPositive(), cachingRealmMBean.getUserCacheTTLNegative(), ManagementService.getRuntimeAccess(kernelId).getServer().getServerDebug().getDebugSecurityRealm(), object);
    }

    private CachingRealm(ListableRealm listableRealm, ManageableRealm manageableRealm, boolean bl, boolean bl2, int n, int n2, int n3, boolean bl3, int n4, int n5, int n6, boolean bl4, int n7, int n8, int n9, boolean bl5, int n10, int n11, int n12, boolean bl6, int n13, int n14, int n15, boolean bl7, Object object) {
        this.delegate = listableRealm;
        this.backup = manageableRealm;
        this.setDebug(bl7);
        if (!bl7 && Boolean.getBoolean("weblogic.security.cachingrealm.verbose")) {
            this.log = new LogOutputStream("CachingRealm");
        }
        if (listableRealm instanceof ManageableRealm) {
            this.manageable = (ManageableRealm)listableRealm;
        }
        this.caseSensitive = bl;
        DisabledCache disabledCache = new DisabledCache();
        if (bl2) {
            if (this.log != null) {
                this.log.debug("acl size = " + n + ", pos ttl =" + n2 + ", neg ttl = " + n3);
            }
            this.aclPosCache = new TTLCache(n, (long)n2 * 1000L);
            this.aclNegCache = new TTLCache(n, (long)n3 * 1000L);
        } else {
            if (this.log != null) {
                this.log.debug("acl cache disabled");
            }
            this.aclPosCache = disabledCache;
            this.aclNegCache = disabledCache;
        }
        if (bl3) {
            if (this.log != null) {
                this.log.debug("auth size = " + n4 + ", pos ttl = " + n5 + ", neg ttl = " + n6);
            }
            this.authPosCache = new TTLCache(n4, (long)n5 * 1000L);
            this.authNegCache = new TTLCache(n4, (long)n6 * 1000L);
        } else {
            if (this.log != null) {
                this.log.debug("auth cache disabled");
            }
            this.authPosCache = disabledCache;
            this.authNegCache = disabledCache;
        }
        if (bl4) {
            if (this.log != null) {
                this.log.debug("group size = " + n7 + ", pos ttl = " + n8 + ", neg ttl = " + n9);
            }
            this.groupPosCache = new TTLCache(n7, (long)n8 * 1000L);
            this.groupNegCache = new TTLCache(n7, (long)n9 * 1000L);
        } else {
            if (this.log != null) {
                this.log.debug("group cache disabled");
            }
            this.groupPosCache = disabledCache;
            this.groupNegCache = disabledCache;
        }
        if (bl5) {
            if (this.log != null) {
                this.log.debug("perm size = " + n10 + ", pos ttl = " + n11 + ", neg ttl = " + n12);
            }
            this.permPosCache = new TTLCache(n10, (long)n11 * 1000L);
            this.permNegCache = new TTLCache(n10, (long)n12 * 1000L);
        } else {
            if (this.log != null) {
                this.log.debug("perm cache disabled");
            }
            this.permPosCache = disabledCache;
            this.permNegCache = disabledCache;
        }
        if (bl6) {
            if (this.log != null) {
                this.log.debug("user size = " + n13 + ", pos ttl = " + n14 + ", neg ttl = " + n15);
            }
            this.userPosCache = new TTLCache(n13, (long)n14 * 1000L);
            this.userNegCache = new TTLCache(n13, (long)n15 * 1000L);
        } else {
            if (this.log != null) {
                this.log.debug("user cache disabled");
            }
            this.userPosCache = disabledCache;
            this.userNegCache = disabledCache;
        }
    }

    private void addPermission(Acl acl, Permission permission, Principal principal, String string) {
        Principal principal2 = this.getPrincipal(string);
        if (!this.caseSensitive) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        if (principal2 == null) {
            SecurityLogger.logNonexistentPrincipalWarning((String)acl.getName(), (String)string);
            String string2 = "ACL \"" + acl.getName() + "\" contains non-existent principal \"" + string + "\" - ignoring principal";
            System.err.println("******** Error: " + string2);
            return;
        }
        Enumeration enumeration = acl.entries();
        try {
            while (enumeration.hasMoreElements()) {
                AclEntry aclEntry = (AclEntry)enumeration.nextElement();
                Principal principal3 = aclEntry.getPrincipal();
                String string3 = principal3.getName();
                if (!this.caseSensitive) {
                    string3 = string3.toLowerCase(Locale.ENGLISH);
                }
                if (!string3.equals(string)) continue;
                acl.removeEntry(principal, aclEntry);
                aclEntry.addPermission(permission);
                acl.addEntry(principal, aclEntry);
                return;
            }
            acl.addEntry(principal, (AclEntry)new AclEntryImpl(principal2, permission));
        }
        catch (NotOwnerException notOwnerException) {
            throw new NestedRuntimeException("realm setup failed", (Throwable)notOwnerException);
        }
    }

    public BasicRealm masqueradeAs(String string) {
        BasicRealm basicRealm = Realm.realms.put(string, this);
        this.realmName = string;
        return basicRealm;
    }

    public void init(String string, Object object) throws NotOwnerException {
        if (this.log != null) {
            this.log.debug("init(" + string + ", ***)");
        }
        this.delegate.init(string, object);
        if (this.backup != null) {
            this.backup.init(string, object);
        }
    }

    public String getName() {
        return this.realmName;
    }

    public User getUser(String string) {
        if (this.log != null) {
            this.log.debug("getUser(\"" + string + "\")");
        }
        UserEntry userEntry = null;
        userEntry = this.getUserEntry(string);
        if (userEntry != null) {
            return (User)userEntry.getValue();
        }
        return null;
    }

    public Principal lookupPrincipal(String string) {
        Group group;
        if (this.log != null) {
            this.log.debug("lookupPrincipal(\"" + string + "\")");
        }
        if ((group = this.lookupGroup(string)) == null) {
            group = this.lookupUser(string);
        }
        return group;
    }

    public Principal getPrincipal(String string) {
        Group group;
        if (this.log != null) {
            this.log.debug("getPrincipal(\"" + string + "\")");
        }
        if ((group = this.getGroup(string)) == null) {
            group = this.getUser(string);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User lookupUser(String string) {
        if (this.log != null) {
            this.log.debug("lookupUser(\"" + string + "\")");
        }
        String string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
        User user = null;
        Object object = this.userSync;
        synchronized (object) {
            Entry entry = (Entry)this.userPosCache.get(string2);
            if (entry != null) {
                if (this.log != null) {
                    this.log.debug("user: pos HIT " + string);
                }
                user = (User)entry.getValue();
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserEntry getUserEntry(String string) {
        Object object;
        UserEntry userEntry;
        String string2;
        block23: {
            string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
            userEntry = null;
            object = this.userSync;
            synchronized (object) {
                userEntry = (UserEntry)this.userPosCache.get(string2);
                if (userEntry != null) {
                    if (this.log != null) {
                        this.log.debug("user: pos HIT " + string);
                    }
                    return userEntry;
                }
                if (this.userNegCache.containsKey(string2)) {
                    if (this.log != null) {
                        this.log.debug("user: neg HIT " + string);
                    }
                    return null;
                }
            }
            object = null;
            try {
                object = this.delegate.getUser(string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup != null) break block23;
                throw unsupportedOperationException;
            }
        }
        if (object != null) {
            if (this.log != null) {
                this.log.debug("user: delegate HAS " + string);
            }
            userEntry = new UserEntry(object, this.delegate);
            Object object2 = this.userSync;
            synchronized (object2) {
                this.userPosCache.put(string2, userEntry);
                this.userNegCache.remove(string2);
            }
        }
        if (this.backup != null && (object = this.backup.getUser(string)) != null) {
            if (this.log != null) {
                this.log.debug("user: backup HAS " + string);
            }
            userEntry = new UserEntry(object, this.backup);
            Object object3 = this.userSync;
            synchronized (object3) {
                this.userPosCache.put(string2, userEntry);
                this.userNegCache.remove(string2);
            }
        }
        if (this.log != null) {
            this.log.debug("user: UNPERSON " + string);
        }
        Object object4 = this.userSync;
        synchronized (object4) {
            this.userNegCache.put(string2);
            this.userPosCache.remove(string2);
        }
        return userEntry;
    }

    public User getUser(UserInfo userInfo) {
        return this.authenticate(userInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User authenticate(UserInfo userInfo) {
        Object object;
        UserInfo userInfo2;
        UserEntry userEntry;
        String string;
        block36: {
            string = userInfo.getName();
            userEntry = null;
            userInfo2 = null;
            String string2 = null;
            if (string != null) {
                if (this.caseSensitive) {
                    string2 = string.toLowerCase(Locale.ENGLISH);
                    userInfo2 = new CaseInsensitiveUserInfo(userInfo);
                } else {
                    userInfo2 = userInfo;
                }
                userEntry = this.getUserEntry(string);
            } else {
                userInfo2 = userInfo;
            }
            if (this.log != null) {
                this.log.debug("authenticate(\"" + string + "\")");
            }
            Entry entry = null;
            object = this.userSync;
            synchronized (object) {
                entry = (Entry)this.authPosCache.get(userInfo2);
                if (entry != null) {
                    if (this.log != null) {
                        this.log.debug("auth: pos HIT " + string);
                    }
                    User user = (User)entry.getValue();
                    if (userEntry == null) {
                        userEntry = this.getUserEntry(user.getName());
                    }
                    if (userEntry != null) {
                        userEntry.setInfo(userInfo);
                    }
                    return user;
                }
                if (this.authNegCache.containsKey(userInfo2)) {
                    if (this.log != null) {
                        this.log.debug("auth: neg HIT " + userInfo.getName());
                    }
                    return null;
                }
            }
            object = null;
            try {
                object = this.delegate.getUser(userInfo);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup != null) break block36;
                throw unsupportedOperationException;
            }
        }
        if (object != null) {
            if (this.log != null) {
                this.log.debug("auth: delegate PASSES " + string);
            }
            Object object2 = this.userSync;
            synchronized (object2) {
                this.authPosCache.put(userInfo2, new Entry(object, this.delegate));
                this.authNegCache.remove(userInfo2);
            }
            if (userEntry == null) {
                userEntry = this.getUserEntry(object.getName());
            }
            if (userEntry != null) {
                userEntry.setInfo(userInfo);
            }
        } else if (this.backup != null && (object = this.backup.getUser(userInfo)) != null) {
            if (this.log != null) {
                this.log.debug("auth: backup PASSES " + string);
            }
            Object object3 = this.userSync;
            synchronized (object3) {
                this.authPosCache.put(userInfo2, new Entry(object, this.backup));
                this.authNegCache.remove(userInfo2);
            }
            if (userEntry == null) {
                userEntry = this.getUserEntry(object.getName());
            }
            if (userEntry != null) {
                userEntry.setInfo(userInfo);
            }
        } else {
            if (this.log != null) {
                this.log.debug("auth: FAIL " + string);
            }
            Object object4 = this.userSync;
            synchronized (object4) {
                this.authNegCache.put(userInfo2);
                this.authPosCache.remove(userInfo2);
            }
        }
        return object;
    }

    public Principal getAclOwner(Object object) {
        Principal principal;
        block4: {
            if (this.log != null) {
                this.log.debug("getAclOwner(\"" + object + "\")");
            }
            principal = null;
            try {
                principal = this.delegate.getAclOwner(object);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup != null) break block4;
                throw unsupportedOperationException;
            }
        }
        if (principal == null && this.backup != null) {
            principal = this.backup.getAclOwner(object);
        }
        return principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group lookupGroup(String string) {
        if (this.log != null) {
            this.log.debug("lookupGroup(\"" + string + "\")");
        }
        String string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
        Group group = null;
        Object object = this.groupSync;
        synchronized (object) {
            Entry entry = (Entry)this.groupPosCache.get(string2);
            if (entry != null) {
                if (this.log != null) {
                    this.log.debug("group: pos HIT " + string);
                }
                group = (Group)entry.getValue();
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(String string) {
        Object object;
        Entry entry;
        String string2;
        block24: {
            if (this.log != null) {
                this.log.debug("getGroup(\"" + string + "\")");
            }
            string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
            entry = null;
            object = this.groupSync;
            synchronized (object) {
                entry = (Entry)this.groupPosCache.get(string2);
                if (entry != null) {
                    if (this.log != null) {
                        this.log.debug("group: pos HIT " + string);
                    }
                    return (Group)entry.getValue();
                }
                if (this.groupNegCache.containsKey(string2)) {
                    if (this.log != null) {
                        this.log.debug("group: neg HIT " + string);
                    }
                    return null;
                }
            }
            object = null;
            try {
                object = this.delegate.getGroup(string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup != null) break block24;
                throw unsupportedOperationException;
            }
        }
        if (object != null) {
            if (this.log != null) {
                this.log.debug("group: delegate HAS " + string);
            }
            entry = new Entry(object, this.delegate);
            Object object2 = this.groupSync;
            synchronized (object2) {
                this.groupPosCache.put(string2, entry);
                this.groupNegCache.remove(string2);
            }
        }
        if (this.backup != null && (object = this.backup.getGroup(string)) != null) {
            if (this.log != null) {
                this.log.debug("group: backup HAS " + string);
            }
            entry = new Entry(object, this.backup);
            Object object3 = this.groupSync;
            synchronized (object3) {
                this.groupPosCache.put(string2, entry);
                this.groupNegCache.remove(string2);
            }
        }
        if (this.log != null) {
            this.log.debug("group: UNGROUP " + string);
        }
        Object object4 = this.groupSync;
        synchronized (object4) {
            this.groupNegCache.put(string2);
            this.groupPosCache.remove(string2);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Acl lookupAcl(String string) {
        if (this.log != null) {
            this.log.debug("lookupAcl(\"" + string + "\")");
        }
        String string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
        Acl acl = null;
        Object object = this.aclSync;
        synchronized (object) {
            Entry entry = (Entry)this.aclPosCache.get(string2);
            if (entry != null) {
                if (this.log != null) {
                    this.log.debug("acl: pos HIT " + string);
                }
                acl = (Acl)entry.getValue();
            }
        }
        return acl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Acl getAcl(String string) {
        Object object;
        Entry entry;
        String string2;
        block24: {
            if (this.log != null) {
                this.log.debug("getAcl(\"" + string + "\")");
            }
            string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
            entry = null;
            object = this.aclSync;
            synchronized (object) {
                entry = (Entry)this.aclPosCache.get(string2);
                if (entry != null) {
                    if (this.log != null) {
                        this.log.debug("acl: pos HIT " + string);
                    }
                    return (Acl)entry.getValue();
                }
                if (this.aclNegCache.containsKey(string2)) {
                    if (this.log != null) {
                        this.log.debug("acl: neg HIT " + string);
                    }
                    return null;
                }
            }
            object = null;
            try {
                object = this.delegate.getAcl(string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup != null) break block24;
                throw unsupportedOperationException;
            }
        }
        if (object != null) {
            if (this.log != null) {
                this.log.debug("acl: delegate HAS " + string);
            }
            entry = new Entry(object, this.delegate);
            Object object2 = this.aclSync;
            synchronized (object2) {
                this.aclPosCache.put(string2, entry);
                this.aclNegCache.remove(string2);
            }
        }
        if (this.backup != null && (object = this.backup.getAcl(string)) != null) {
            if (this.log != null) {
                this.log.debug("acl: backup HAS " + string);
            }
            entry = new Entry(object, this.backup);
            Object object3 = this.aclSync;
            synchronized (object3) {
                this.aclPosCache.put(string2, entry);
                this.aclNegCache.remove(string2);
            }
        }
        if (this.log != null) {
            this.log.debug("acl: UNACL " + string);
        }
        Object object4 = this.aclSync;
        synchronized (object4) {
            this.aclNegCache.put(string2);
            this.aclPosCache.remove(string2);
        }
        return object;
    }

    public Acl lookupAcl(String string, char c) {
        if (this.log != null) {
            this.log.debug("lookupAcl(\"" + string + "\", '" + c + "')");
        }
        Acl acl = this.lookupAcl(string);
        int n = string.lastIndexOf(c);
        while (acl == null && n >= 0) {
            string = string.substring(0, n);
            acl = this.lookupAcl(string);
            n = string.lastIndexOf(c, n - 1);
        }
        return acl;
    }

    public Acl getAcl(String string, char c) {
        if (this.log != null) {
            this.log.debug("getAcl(\"" + string + "\", '" + c + "')");
        }
        Acl acl = this.getAcl(string);
        int n = string.lastIndexOf(c);
        while (acl == null && n >= 0) {
            string = string.substring(0, n);
            acl = this.getAcl(string);
            n = string.lastIndexOf(c, n - 1);
        }
        return acl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission lookupPermission(String string) {
        if (this.log != null) {
            this.log.debug("lookupPermission(\"" + string + "\")");
        }
        String string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
        Permission permission = null;
        Object object = this.permSync;
        synchronized (object) {
            Entry entry = (Entry)this.permPosCache.get(string2);
            if (entry != null) {
                if (this.log != null) {
                    this.log.debug("perm: pos HIT " + string);
                }
                permission = (Permission)entry.getValue();
            }
        }
        return permission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission getPermission(String string) {
        Object object;
        Entry entry;
        Permission permission;
        String string2;
        block24: {
            if (this.log != null) {
                this.log.debug("getPermission(\"" + string + "\")");
            }
            string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
            permission = null;
            entry = null;
            object = this.permSync;
            synchronized (object) {
                entry = (Entry)this.permPosCache.get(string2);
                if (entry != null) {
                    if (this.log != null) {
                        this.log.debug("perm: pos HIT " + string);
                    }
                    return (Permission)entry.getValue();
                }
                if (this.permNegCache.containsKey(string2)) {
                    if (this.log != null) {
                        this.log.debug("perm: pos HIT " + string);
                    }
                    return null;
                }
            }
            try {
                permission = this.delegate.getPermission(string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup != null) break block24;
                throw unsupportedOperationException;
            }
        }
        if (permission != null) {
            if (this.log != null) {
                this.log.debug("perm: delegate HAS " + string);
            }
            entry = new Entry(permission, this.delegate);
            object = this.permSync;
            synchronized (object) {
                this.permPosCache.put(string2, entry);
                this.permNegCache.remove(string2);
            }
        }
        if (this.backup != null && (permission = this.backup.getPermission(string)) != null) {
            if (this.log != null) {
                this.log.debug("perm: backup HAS " + string);
            }
            entry = new Entry(permission, this.backup);
            object = this.permSync;
            synchronized (object) {
                this.permPosCache.put(string2, entry);
                this.permNegCache.remove(string2);
            }
        }
        if (this.log != null) {
            this.log.debug("perm: UNPERM " + string);
        }
        object = this.permSync;
        synchronized (object) {
            this.permNegCache.put(string2);
            this.permPosCache.remove(string2);
        }
        return permission;
    }

    public void load(String string, Object object) throws ClassNotFoundException, IOException, NotOwnerException {
        if (this.log != null) {
            this.log.debug("load(\"" + string + "\", " + object + ")");
        }
        this.delegate.load(string, object);
        if (this.backup != null) {
            this.backup.load(string, object);
        }
    }

    public void save(String string) throws IOException {
        if (this.log != null) {
            this.log.debug("save(\"" + string + "\")");
        }
        this.delegate.save(string);
        if (this.backup != null) {
            this.backup.save(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User newUser(String string, Object object, Object object2) throws SecurityException {
        if (this.log != null) {
            this.log.debug("newUser(\"" + string + "\", " + object + ", " + object2 + ")");
        }
        User user = null;
        if (this.manageable != null) {
            try {
                user = this.manageable.newUser(string, object, object2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup == null) {
                    throw unsupportedOperationException;
                }
                user = this.backup.newUser(string, object, object2);
            }
        } else if (this.backup != null) {
            user = this.backup.newUser(string, object, object2);
        } else {
            throw new UnsupportedOperationException("newUser not supported by delegate");
        }
        if (user != null) {
            String string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
            Object object3 = this.userSync;
            synchronized (object3) {
                this.userNegCache.remove(string2);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group newGroup(String string) throws SecurityException {
        if (this.log != null) {
            this.log.debug("newGroup(\"" + string + "\")");
        }
        Group group = null;
        if (this.manageable != null) {
            try {
                group = this.manageable.newGroup(string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup == null) {
                    throw unsupportedOperationException;
                }
                group = this.backup.newGroup(string);
            }
        } else if (this.backup != null) {
            group = this.backup.newGroup(string);
        } else {
            throw new UnsupportedOperationException("newGroup not supported by delegate");
        }
        if (group != null) {
            String string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
            Object object = this.groupSync;
            synchronized (object) {
                this.groupNegCache.remove(string2);
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Acl newAcl(Principal principal, String string) throws SecurityException {
        if (this.log != null) {
            this.log.debug("newAcl(\"" + principal.getName() + "\", \"" + string + "\")");
        }
        Acl acl = null;
        if (this.manageable != null) {
            try {
                acl = this.manageable.newAcl(principal, string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup == null) {
                    throw unsupportedOperationException;
                }
                acl = this.backup.newAcl(principal, string);
            }
        } else if (this.backup != null) {
            acl = this.backup.newAcl(principal, string);
        } else {
            throw new UnsupportedOperationException("newAcl not supported by delegate");
        }
        if (acl != null) {
            String string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
            Object object = this.aclSync;
            synchronized (object) {
                this.aclNegCache.remove(string2);
            }
        }
        return acl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission newPermission(String string) throws SecurityException {
        if (this.log != null) {
            this.log.debug("newAcl(\"" + string + "\")");
        }
        Permission permission = null;
        if (this.manageable != null) {
            try {
                permission = this.manageable.newPermission(string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup == null) {
                    throw unsupportedOperationException;
                }
                permission = this.backup.newPermission(string);
            }
        } else if (this.backup != null) {
            permission = this.backup.newPermission(string);
        } else {
            throw new UnsupportedOperationException("newPermission not supported by delegate");
        }
        if (permission != null) {
            String string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
            Object object = this.permSync;
            synchronized (object) {
                this.permNegCache.remove(string2);
            }
        }
        return permission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(User user) throws SecurityException {
        if (this.log != null) {
            this.log.debug("deleteUser(\"" + user.getName() + "\")");
        }
        String string = user.getName();
        if (this.manageable != null) {
            try {
                this.manageable.deleteUser(user);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup == null) {
                    throw unsupportedOperationException;
                }
                this.backup.deleteUser(user);
            }
        } else if (this.backup != null) {
            this.backup.deleteUser(user);
        } else {
            throw new UnsupportedOperationException("deleteUser not supported by delegate");
        }
        String string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
        Object object = this.userSync;
        synchronized (object) {
            UserEntry userEntry = (UserEntry)this.userPosCache.get(string2);
            if (userEntry != null) {
                this.userPosCache.remove(string2);
                if (userEntry.getInfo() != null) {
                    this.authPosCache.remove(userEntry.getInfo());
                    userEntry.setInfo(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroup(Group group) throws SecurityException {
        if (this.log != null) {
            this.log.debug("deleteGroup(\"" + group.getName() + "\")");
        }
        String string = group.getName();
        if (this.manageable != null) {
            try {
                this.manageable.deleteGroup(group);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup == null) {
                    throw unsupportedOperationException;
                }
                this.backup.deleteGroup(group);
            }
        } else if (this.backup != null) {
            this.backup.deleteGroup(group);
        } else {
            throw new UnsupportedOperationException("deleteGroup not supported by delegate");
        }
        String string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
        Object object = this.groupSync;
        synchronized (object) {
            this.groupPosCache.remove(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePermission(Permission permission) throws SecurityException {
        String string;
        String string2 = string = permission instanceof PermissionImpl ? ((PermissionImpl)permission).getName() : permission.toString();
        if (this.log != null) {
            this.log.debug("deletePermission(\"" + string + "\")");
        }
        if (this.manageable != null) {
            try {
                this.manageable.deletePermission(permission);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup == null) {
                    throw unsupportedOperationException;
                }
                this.backup.deletePermission(permission);
            }
        } else if (this.backup != null) {
            this.backup.deletePermission(permission);
        } else {
            throw new UnsupportedOperationException("deletePermission not supported by delegate");
        }
        String string3 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
        Object object = this.permSync;
        synchronized (object) {
            this.permPosCache.remove(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAcl(Principal principal, Acl acl) throws SecurityException {
        if (this.log != null) {
            this.log.debug("deleteAcl(\"" + principal.getName() + "\", \"" + acl.getName() + "\")");
        }
        String string = acl.getName();
        if (this.manageable != null) {
            try {
                this.manageable.deleteAcl(principal, acl);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup == null) {
                    throw unsupportedOperationException;
                }
                this.backup.deleteAcl(principal, acl);
            }
        } else if (this.backup != null) {
            this.backup.deleteAcl(principal, acl);
        } else {
            throw new UnsupportedOperationException("deleteAcl not supported by delegate");
        }
        String string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
        Object object = this.aclSync;
        synchronized (object) {
            this.aclPosCache.remove(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermission(Acl acl, Principal principal, Permission permission, boolean bl) {
        if (this.log != null) {
            this.log.debug("deleteAcl(\"" + acl.getName() + "\", \"" + principal.getName() + "\", " + permission + ", " + bl + ")");
        }
        String string = acl.getName();
        if (this.manageable != null) {
            try {
                this.manageable.setPermission(acl, principal, permission, bl);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup == null) {
                    throw unsupportedOperationException;
                }
                this.backup.setPermission(acl, principal, permission, bl);
            }
        } else if (this.backup != null) {
            this.backup.setPermission(acl, principal, permission, bl);
        } else {
            throw new UnsupportedOperationException("setPermission not supported by delegate");
        }
        String string2 = this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
        Object object = this.aclSync;
        synchronized (object) {
            if (bl) {
                this.aclNegCache.remove(string2);
            } else {
                this.aclPosCache.remove(string2);
            }
        }
    }

    private Enumeration getEnumeration(Enumeration enumeration, Enumeration enumeration2) {
        if (enumeration != null) {
            if (enumeration2 != null) {
                return new ArrayEnumeration(new Enumeration[]{enumeration, enumeration2});
            }
            return enumeration;
        }
        if (enumeration2 != null) {
            return enumeration2;
        }
        return null;
    }

    public Enumeration getUsers() {
        Enumeration enumeration;
        block3: {
            if (this.log != null) {
                this.log.debug("getUsers()");
            }
            enumeration = null;
            try {
                enumeration = this.delegate.getUsers();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup != null) break block3;
                throw unsupportedOperationException;
            }
        }
        Enumeration enumeration2 = this.backup != null ? this.backup.getUsers() : null;
        return this.getEnumeration(enumeration, enumeration2);
    }

    public Enumeration getGroups() {
        Enumeration enumeration;
        block3: {
            if (this.log != null) {
                this.log.debug("getGroups()");
            }
            enumeration = null;
            try {
                enumeration = this.delegate.getGroups();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup != null) break block3;
                throw unsupportedOperationException;
            }
        }
        Enumeration enumeration2 = this.backup != null ? this.backup.getGroups() : null;
        return this.getEnumeration(enumeration, enumeration2);
    }

    public Enumeration getAcls() {
        Enumeration enumeration;
        block3: {
            if (this.log != null) {
                this.log.debug("getAcls()");
            }
            enumeration = null;
            try {
                enumeration = this.delegate.getAcls();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup != null) break block3;
                throw unsupportedOperationException;
            }
        }
        Enumeration enumeration2 = this.backup != null ? this.backup.getAcls() : null;
        return this.getEnumeration(enumeration, enumeration2);
    }

    public Enumeration getPermissions() {
        Enumeration enumeration;
        block3: {
            if (this.log != null) {
                this.log.debug("getPermissions()");
            }
            enumeration = null;
            try {
                enumeration = this.delegate.getPermissions();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.backup != null) break block3;
                throw unsupportedOperationException;
            }
        }
        Enumeration enumeration2 = this.backup != null ? this.backup.getPermissions() : null;
        return this.getEnumeration(enumeration, enumeration2);
    }

    public void refresh() {
        this.clearCaches();
        if (this.delegate instanceof RefreshableRealm) {
            ((RefreshableRealm)((Object)this.delegate)).refresh();
        }
        if (this.backup != null && this.backup instanceof RefreshableRealm) {
            ((RefreshableRealm)((Object)this.backup)).refresh();
        }
    }

    public void clearCaches() {
        if (this.log != null) {
            this.log.debug("clearCaches()");
        }
        this.clearUserCaches();
        this.clearGroupCaches();
        this.clearAclCaches();
        this.clearPermCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUserCaches() {
        if (this.log != null) {
            this.log.debug("clearUserCaches()");
        }
        Object object = this.userSync;
        synchronized (object) {
            this.userPosCache.clear();
            this.userNegCache.clear();
            this.authPosCache.clear();
            this.authNegCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGroupToCache(Group group) {
        if (group != null) {
            if (this.log != null) {
                this.log.debug("adding group " + group.getName() + " to group cache");
            }
            String string = this.caseSensitive ? group.getName() : group.getName().toLowerCase(Locale.ENGLISH);
            Entry entry = new Entry(group, this.delegate);
            Object object = this.groupSync;
            synchronized (object) {
                this.groupPosCache.put(string, entry);
                this.groupNegCache.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGroupCaches() {
        if (this.log != null) {
            this.log.debug("clearGroupCaches()");
        }
        Object object = this.groupSync;
        synchronized (object) {
            this.groupPosCache.clear();
            this.groupNegCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAclCaches() {
        if (this.log != null) {
            this.log.debug("clearAclCaches()");
        }
        Object object = this.aclSync;
        synchronized (object) {
            this.aclPosCache.clear();
            this.aclNegCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPermCaches() {
        if (this.log != null) {
            this.log.debug("clearPermCaches()");
        }
        Object object = this.permSync;
        synchronized (object) {
            this.permPosCache.clear();
            this.permNegCache.clear();
        }
    }

    public void setDebug(boolean bl) {
        if (this.delegate instanceof DebuggableRealm) {
            ((DebuggableRealm)((Object)this.delegate)).setDebug(bl);
        }
        if (this.backup != null && this.backup instanceof DebuggableRealm) {
            ((DebuggableRealm)((Object)this.backup)).setDebug(bl);
        }
        if (bl && this.log == null) {
            this.log = new LogOutputStream("CachingRealm");
        }
        if (!bl) {
            this.log = null;
        }
    }

    public LogOutputStream getDebugLog() {
        return this.log;
    }

    public Class getDelegateClass() {
        return this.delegate.getClass();
    }

    public Object getCacheValue(Object object) {
        Object var2_2 = null;
        return var2_2;
    }

    private class ArrayEnumeration
    implements ClosableEnumeration {
        private Enumeration[] enumerations = null;
        private int current = 0;

        ArrayEnumeration(Enumeration[] enumerationArray) {
            this.enumerations = enumerationArray;
        }

        private Enumeration current() {
            if (this.current >= this.enumerations.length) {
                return null;
            }
            return this.enumerations[this.current];
        }

        private void close(Enumeration enumeration) {
            block3: {
                if (enumeration instanceof ClosableEnumeration) {
                    try {
                        ((ClosableEnumeration)enumeration).close();
                    }
                    catch (Throwable throwable) {
                        if (CachingRealm.this.log == null) break block3;
                        SecurityLogger.logClosingEnumerationWarning((String)throwable.toString());
                    }
                }
            }
        }

        private void increment() {
            if (this.current() == null) {
                return;
            }
            this.close(this.current());
            ++this.current;
        }

        public boolean hasMoreElements() {
            if (this.current() == null) {
                return false;
            }
            if (this.current().hasMoreElements()) {
                return true;
            }
            this.increment();
            if (this.current() == null) {
                return false;
            }
            return this.current().hasMoreElements();
        }

        public Object nextElement() {
            if (this.current() == null) {
                throw new NoSuchElementException();
            }
            try {
                return this.current().nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.increment();
                if (this.current() == null) {
                    throw new NoSuchElementException();
                }
                return this.current().nextElement();
            }
        }

        public void close() {
            while (this.current() != null) {
                this.increment();
            }
        }
    }

    protected static class CaseInsensitiveUserInfo
    implements UserInfo {
        private static final long serialVersionUID = -4798082305580933563L;
        private UserInfo info;
        private DefaultUserInfoImpl defInfo;
        private String name;
        private String realmName;
        private int hashCode;

        CaseInsensitiveUserInfo(UserInfo userInfo) {
            this.name = userInfo.getName().toLowerCase(Locale.ENGLISH);
            this.realmName = userInfo.getRealmName();
            this.info = userInfo;
            if (userInfo instanceof DefaultUserInfoImpl) {
                this.defInfo = (DefaultUserInfoImpl)userInfo;
            }
            this.hashCode = (this.name == null ? 0 : this.name.hashCode()) ^ (this.realmName == null ? 0 : this.realmName.hashCode());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof CaseInsensitiveUserInfo) {
                UserInfo userInfo = ((CaseInsensitiveUserInfo)object).getInfo();
                if (this.defInfo != null && userInfo instanceof DefaultUserInfoImpl) {
                    DefaultUserInfoImpl defaultUserInfoImpl = (DefaultUserInfoImpl)userInfo;
                    return this.name.equals(defaultUserInfoImpl.getName().toLowerCase(Locale.ENGLISH)) && this.defInfo.equalsInAllButName(defaultUserInfoImpl);
                }
                System.err.println("***");
                System.err.println("*** Encountered an unknown kind of UserInfo object.");
                System.err.println("*** UserInfo type is: " + userInfo.getClass().getName());
                System.err.println("*** Server cannot check in a case-insensitive way.");
                System.err.println("***");
                return this.info.equals(userInfo);
            }
            if (object instanceof UserInfo) {
                return this.info.equals(object);
            }
            return false;
        }

        UserInfo getInfo() {
            return this.info;
        }

        public String getName() {
            return this.name;
        }

        public String getRealmName() {
            return this.realmName;
        }
    }

    private static class UnitTest {
        private UnitTest() {
        }

        public static void main(String[] stringArray) throws Exception {
            if (stringArray.length != 4) {
                System.err.println("usage: test class user passwd group");
            }
            ListableRealm listableRealm = (ListableRealm)Class.forName(stringArray[0]).newInstance();
            int n = 17;
            int n2 = 10;
            int n3 = 5;
            CachingRealm cachingRealm = new CachingRealm(listableRealm, null, true, true, n, n2, n3, true, n, n2, n3, true, n, n2, n3, true, n, n2, n3, true, n, n2, n3, true, null);
            User user = cachingRealm.getUser(stringArray[1]);
            System.out.println("user " + stringArray[1] + ": " + (user != null ? "exists" : "unperson"));
            User user2 = cachingRealm.authenticate(new DefaultUserInfoImpl(stringArray[1], stringArray[2]));
            System.out.println("auth " + stringArray[1] + ": " + (user2 != null ? "succeeded" : "failed"));
            Group group = cachingRealm.getGroup(stringArray[3]);
            System.out.println("group " + stringArray[3] + ": " + (group != null ? EnumerationUtils.toString((Enumeration)group.members()) : "ungroup"));
            System.out.println("users: " + EnumerationUtils.toString((Enumeration)cachingRealm.getUsers()));
            System.out.println("groups: " + EnumerationUtils.toString((Enumeration)cachingRealm.getGroups()));
            System.out.println("acls: " + EnumerationUtils.toString((Enumeration)cachingRealm.getAcls()));
        }
    }

    private static class DisabledCache
    extends TTLCache {
        DisabledCache() {
            super(0, 1L);
        }

        public Object put(Object object, Object object2) {
            return null;
        }

        public Object put(Object object) {
            return null;
        }

        public Object get(Object object) {
            return null;
        }

        public Object remove(Object object) {
            return null;
        }

        public void clear() {
        }

        public void cleanup() {
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean containsKey(Object object) {
            return false;
        }
    }

    protected static class UserEntry
    extends Entry {
        private UserInfo info;

        UserEntry(Object object, ListableRealm listableRealm) {
            super(object, listableRealm);
        }

        void setInfo(UserInfo userInfo) {
            this.info = userInfo;
        }

        UserInfo getInfo() {
            return this.info;
        }
    }

    protected static class Entry {
        private Object value;
        private ListableRealm source;

        Entry(Object object, ListableRealm listableRealm) {
            this.value = object;
            this.source = listableRealm;
        }

        Object getValue() {
            return this.value;
        }

        ListableRealm getSource() {
            return this.source;
        }
    }
}

