/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.security.cert.Certificate;
import java.util.Vector;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.KernelMBean;
import weblogic.security.acl.CertAuthenticator;
import weblogic.security.acl.User;
import weblogic.utils.NestedRuntimeException;

public class CertAuthentication {
    private static CertAuthenticator certer = null;
    private static final Object sync = new Object();
    private static KernelMBean config = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setup() {
        if (certer == null) {
            Object object = sync;
            synchronized (object) {
                if (certer == null) {
                    String string = Kernel.getConfig().getSSL().getCertAuthenticator();
                    if (string != null) {
                        try {
                            certer = (CertAuthenticator)Class.forName(string).newInstance();
                        }
                        catch (Exception exception) {
                            throw new NestedRuntimeException("could not create certificate authenticator", (Throwable)exception);
                        }
                    } else {
                        certer = new CertDenier();
                    }
                }
            }
        }
    }

    public static User authenticate(String string, Vector vector, boolean bl) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new Certificate[vector.size()];
        vector.copyInto(objectArray);
        return CertAuthentication.authenticate(string, (Certificate[])objectArray, bl);
    }

    public static User authenticate(String string, Certificate[] certificateArray, boolean bl) {
        if (certificateArray == null || certificateArray.length == 0 || certer == null) {
            return null;
        }
        return certer.authenticate(string, certificateArray, bl);
    }

    private static class CertDenier
    implements CertAuthenticator {
        private CertDenier() {
        }

        public User authenticate(String string, Certificate[] certificateArray, boolean bl) {
            return null;
        }
    }
}

