/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import weblogic.security.acl.BasicRealm;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.Realm;
import weblogic.security.acl.User;
import weblogic.security.acl.UserInfo;

public class DefaultUserImpl
extends User
implements Serializable {
    private DefaultUserImplUserInfo userInfo = null;
    private BasicRealm realm = null;

    public DefaultUserImpl() {
        super((String)null);
    }

    public DefaultUserImpl(String string, Object object, BasicRealm basicRealm) {
        super(string);
        this.userInfo = new DefaultUserImplUserInfo(string, object, basicRealm.getName());
        this.realm = basicRealm;
    }

    public BasicRealm getRealm() {
        return this.realm;
    }

    public Object getCredential(Object object) {
        if (this.realm.getAclOwner(object) == null || !(this.userInfo instanceof DefaultUserInfoImpl)) {
            return null;
        }
        DefaultUserImplUserInfo defaultUserImplUserInfo = this.userInfo;
        if (defaultUserImplUserInfo.hasCertificates()) {
            return defaultUserImplUserInfo.getCertificates();
        }
        return defaultUserImplUserInfo.getPassword();
    }

    protected void setCredential(Object object) {
        this.userInfo.changeCredential(object);
    }

    public boolean hasMatchingInfo(UserInfo userInfo) {
        if (!(userInfo instanceof DefaultUserInfoImpl) || !(this.userInfo instanceof DefaultUserInfoImpl)) {
            return false;
        }
        DefaultUserInfoImpl defaultUserInfoImpl = (DefaultUserInfoImpl)userInfo;
        DefaultUserImplUserInfo defaultUserImplUserInfo = this.userInfo;
        if (this.realm.getName() != null && this.realm.getName().equals(userInfo.getRealmName())) {
            return defaultUserImplUserInfo.getPassword() != null && defaultUserImplUserInfo.getName() != null && defaultUserImplUserInfo.getName().equals(defaultUserInfoImpl.getName()) && defaultUserImplUserInfo.getPassword().equals(defaultUserInfoImpl.getPassword());
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.userInfo);
        objectOutputStream.writeObject(this.realm.getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.userInfo = (DefaultUserImplUserInfo)objectInputStream.readObject();
        this.realm = Realm.getRealm((String)objectInputStream.readObject());
    }

    private class DefaultUserImplUserInfo
    extends DefaultUserInfoImpl {
        private static final long serialVersionUID = 7058785679087969048L;

        DefaultUserImplUserInfo(String string, Object object, String string2) {
            super(string, object, string2);
        }

        void changeCredential(Object object) {
            this.setCredential(object);
        }
    }
}

