/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import weblogic.security.acl.UserInfo;

public class DefaultUserInfoImpl
implements UserInfo,
Serializable {
    private static final long serialVersionUID = -419061834872911373L;
    protected String realmName = null;
    protected String id = null;
    protected transient String password = null;
    protected Vector certificates = new Vector(0);
    private byte[] obfuscatedPassword = null;
    private static final String CHAR_ENCODING = "UTF-8";

    public DefaultUserInfoImpl() {
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getName() {
        return this.id;
    }

    public void setName(String string) {
        this.id = string;
    }

    public String toString() {
        return "{" + this.getRealmName() + "," + this.getName() + "}";
    }

    public DefaultUserInfoImpl(String string, Object object) {
        this(string, object, "weblogic");
    }

    public DefaultUserInfoImpl(String string, Object object, String string2) {
        this.id = string;
        this.realmName = string2;
        this.setCredential(object);
        if (this.id == null && this.certificates != null && this.certificates.size() > 0) {
            this.id = ((X509Certificate)this.certificates.elementAt(0)).getSubjectDN().getName();
        }
    }

    protected void setCredential(Object object) {
        if (object instanceof String) {
            this.password = (String)object;
            this.obfuscatedPassword = DefaultUserInfoImpl.obfuscate(this.password);
        } else if (object instanceof X509Certificate) {
            this.certificates.addElement(object);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                this.setCredential(objectArray[i]);
            }
        }
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean hasCertificates() {
        return this.certificates.size() > 0;
    }

    public Vector getCertificates() {
        return this.certificates;
    }

    private static byte[] obfuscate(String string) {
        try {
            byte[] byArray = string.getBytes(CHAR_ENCODING);
            byte[] byArray2 = DefaultUserInfoImpl.flipBytes(byArray);
            return byArray2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("The impossible happened: 1");
            return null;
        }
    }

    private static String unobfuscate(byte[] byArray) {
        try {
            byte[] byArray2 = DefaultUserInfoImpl.flipBytes(byArray);
            String string = new String(byArray2, CHAR_ENCODING);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("The impossible happened: 2");
            return null;
        }
    }

    private static byte[] flipBytes(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            byArray2[n] = byArray[n];
            int n2 = n++;
            byArray2[n2] = (byte)(byArray2[n2] ^ 0xFF);
        }
        return byArray2;
    }

    public int hashCode() {
        return (this.realmName == null ? 0 : this.realmName.hashCode()) ^ (this.id == null ? 0 : this.id.hashCode()) ^ (this.password == null ? 0 : this.password.hashCode()) ^ (this.certificates == null ? 0 : this.certificates.hashCode());
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DefaultUserInfoImpl) {
            DefaultUserInfoImpl defaultUserInfoImpl = (DefaultUserInfoImpl)object;
            return (this.id == null ? defaultUserInfoImpl.id == null : this.id.equals(defaultUserInfoImpl.id)) && this.equalsInAllButName(defaultUserInfoImpl);
        }
        return false;
    }

    public boolean equalsInAllButName(DefaultUserInfoImpl defaultUserInfoImpl) {
        String string = defaultUserInfoImpl.getRealmName();
        String string2 = defaultUserInfoImpl.getPassword();
        Vector vector = defaultUserInfoImpl.getCertificates();
        return (this.realmName == null ? string == null : this.realmName.equals(string)) && (this.password == null ? string2 == null : this.password.equals(string2)) && this.equalsCertificatesOnly(defaultUserInfoImpl);
    }

    private boolean equalsCertificatesOnly(DefaultUserInfoImpl defaultUserInfoImpl) {
        Vector vector = defaultUserInfoImpl.getCertificates();
        int n = this.certificates.size();
        int n2 = vector.size();
        if (n == 0 && n2 == 0) {
            return true;
        }
        if (n != n2) {
            return false;
        }
        Vector vector2 = (Vector)this.certificates.clone();
        Vector vector3 = (Vector)vector.clone();
        return vector2.equals(vector3);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.password = this.obfuscatedPassword != null ? DefaultUserInfoImpl.unobfuscate(this.obfuscatedPassword) : null;
    }
}

