/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.security.AccessController;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import weblogic.management.configuration.CachingRealmMBean;
import weblogic.management.configuration.RealmMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.BasicRealm;
import weblogic.security.acl.CachingRealm;
import weblogic.security.acl.DefaultGroupImpl;
import weblogic.security.acl.Security;
import weblogic.security.acl.User;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public abstract class FlatGroup
extends DefaultGroupImpl {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final int LIFETIME_DEFAULT_SEC = 300;
    private static long LIFETIME_MS = -1L;
    private static boolean allowEnumeration = true;
    private long lastUpdate = -1L;
    private Source source;
    protected Hashtable members;
    private Hashtable users;
    private Hashtable groups;
    private Class userClass;
    private Class myClass;
    private boolean caseSensitive;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long getLifeTimeMillis() {
        if (LIFETIME_MS != -1L) return LIFETIME_MS;
        Class<FlatGroup> clazz = FlatGroup.class;
        synchronized (FlatGroup.class) {
            if (LIFETIME_MS != -1L) return LIFETIME_MS;
            int n = 300;
            RealmMBean realmMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().getRealm();
            if (realmMBean != null) {
                allowEnumeration = realmMBean.isEnumerationAllowed();
                CachingRealmMBean cachingRealmMBean = realmMBean.getCachingRealm();
                n = cachingRealmMBean != null ? cachingRealmMBean.getGroupMembershipCacheTTL() : 300;
            }
            LIFETIME_MS = n * 1000;
            // ** MonitorExit[var0] (shouldn't be in output)
            return LIFETIME_MS;
        }
    }

    protected FlatGroup(String string, Source source) {
        super(string);
        this.source = source;
        this.userClass = this.getUserClass();
        this.myClass = this.getClass();
        if (ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().getRealm().getCachingRealm() != null) {
            this.caseSensitive = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().getRealm().getCachingRealm().getCacheCaseSensitive();
        }
    }

    protected FlatGroup(String string, Source source, Hashtable hashtable) {
        this(string, source);
        this.fillCache(hashtable);
    }

    protected final void ensureFreshness() {
        long l = System.currentTimeMillis();
        if (this.members == null || l > this.lastUpdate + FlatGroup.getLifeTimeMillis()) {
            this.fillCache(this.source.getGroupMembers(this.getName()));
        }
    }

    private void fillCache(Hashtable hashtable) {
        if (hashtable == null) {
            throw new RuntimeException("unexpected error - group \"" + this.getName() + "\" does not exist");
        }
        this.members = hashtable;
        this.groups = new Hashtable();
        this.users = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v instanceof Group) {
                this.groups.put(string, v);
                BasicRealm basicRealm = Security.getRealm();
                if (!(basicRealm instanceof CachingRealm)) continue;
                CachingRealm cachingRealm = (CachingRealm)basicRealm;
                cachingRealm.addGroupToCache((Group)v);
                continue;
            }
            if (this.caseSensitive) {
                this.users.put(string, v);
                continue;
            }
            this.users.put(string.toLowerCase(Locale.ENGLISH), v);
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMember(Principal principal) {
        FlatGroup flatGroup = this;
        synchronized (flatGroup) {
            this.ensureFreshness();
            if (this.userClass.isAssignableFrom(principal.getClass())) {
                if (this.caseSensitive && this.users.containsKey(principal.getName())) {
                    return true;
                }
                if (!this.caseSensitive && this.users.containsKey(principal.getName().toLowerCase(Locale.ENGLISH))) {
                    return true;
                }
            }
            Enumeration enumeration = this.groups.elements();
            while (enumeration.hasMoreElements()) {
                Group group = (Group)enumeration.nextElement();
                if (!group.equals(principal) && !group.isMember(principal)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration members() {
        if (allowEnumeration) {
            FlatGroup flatGroup = this;
            synchronized (flatGroup) {
                this.ensureFreshness();
                if (this.members != null) {
                    return this.members.elements();
                }
                return null;
            }
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        return object != null && this.myClass.isAssignableFrom(object.getClass()) && this.getName().equals(((Group)object).getName());
    }

    protected abstract Class getUserClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addMemberInternal(Principal principal) {
        FlatGroup flatGroup = this;
        synchronized (flatGroup) {
            String string = principal.getName();
            this.members.put(string, principal);
            if (principal instanceof User) {
                this.users.put(string, principal);
            } else {
                this.groups.put(string, principal);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeMemberInternal(Principal principal) {
        FlatGroup flatGroup = this;
        synchronized (flatGroup) {
            String string = principal.getName();
            this.members.remove(string);
            if (principal instanceof User) {
                this.users.remove(string);
            } else {
                this.groups.remove(string);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void setCacheTTL(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("bad TTL");
        }
        Class<FlatGroup> clazz = FlatGroup.class;
        synchronized (FlatGroup.class) {
            LIFETIME_MS = l;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    public static final long getCacheTTLMillis() {
        return FlatGroup.getLifeTimeMillis();
    }

    public Hashtable getMembersHashtable() {
        long l = System.currentTimeMillis();
        if (l > this.lastUpdate + FlatGroup.getLifeTimeMillis()) {
            return null;
        }
        return this.members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        FlatGroup flatGroup = this;
        synchronized (flatGroup) {
            this.members = null;
        }
    }

    public static interface Source {
        public Hashtable getGroupMembers(String var1);
    }
}

