/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weblogic.security.acl.User;
import weblogic.utils.enumerations.SequencingEnumerator;

public class GroupImpl
extends User
implements Group {
    private Hashtable individuals = new Hashtable();
    private Vector subgroups = new Vector();

    public GroupImpl(String string) {
        super(string);
    }

    public boolean addMember(Principal principal) {
        if (this.getName().equals(((Object)principal).toString())) {
            throw new IllegalArgumentException("Group " + this.getName() + " can't be added to itself");
        }
        if (this.isMember(principal)) {
            return false;
        }
        if (principal instanceof Group) {
            this.subgroups.addElement(principal);
        } else {
            this.individuals.put(principal, principal);
        }
        return true;
    }

    public boolean removeMember(Principal principal) {
        if (principal instanceof Group) {
            return this.subgroups.removeElement(principal);
        }
        return this.individuals.remove(principal) != null;
    }

    public Enumeration members() {
        Enumeration[] enumerationArray = new Enumeration[]{this.individuals.keys(), this.subgroups.elements()};
        return new SequencingEnumerator(enumerationArray);
    }

    public boolean isMember(Principal principal) {
        if (this.individuals.get(principal) != null) {
            return true;
        }
        Enumeration enumeration = this.subgroups.elements();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            if (!group.equals(principal) && !group.isMember(principal)) continue;
            return true;
        }
        return false;
    }
}

