/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.security.acl.LastOwnerException;
import java.security.acl.NotOwnerException;
import java.security.acl.Owner;
import java.util.Enumeration;
import weblogic.security.acl.GroupImpl;

public class OwnerImpl
implements Owner,
Serializable {
    private Group ownerGroup = new GroupImpl("AclOwners");

    public OwnerImpl(Principal principal) {
        this.ownerGroup.addMember(principal);
    }

    public synchronized boolean addOwner(Principal principal, Principal principal2) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        return this.ownerGroup.addMember(principal2);
    }

    public synchronized boolean deleteOwner(Principal principal, Principal principal2) throws NotOwnerException, LastOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        Enumeration enumeration = this.ownerGroup.members();
        enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            return this.ownerGroup.removeMember(principal2);
        }
        throw new LastOwnerException();
    }

    public synchronized boolean isOwner(Principal principal) {
        return this.ownerGroup.isMember(principal);
    }
}

