/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weblogic.cluster.ClusterService;
import weblogic.cluster.ClusterServices;
import weblogic.cluster.MulticastSession;
import weblogic.management.configuration.PasswordPolicyMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.InvalidLogin;
import weblogic.security.acl.LoginFailureRecord;
import weblogic.security.acl.Security;
import weblogic.security.acl.SecurityMessage;
import weblogic.security.acl.SecurityMulticastRecord;
import weblogic.security.acl.UnlockUserRecord;
import weblogic.security.acl.User;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.shared.LoggerWrapper;
import weblogic.utils.AssertionError;

public final class PasswordGuessing {
    private static LoggerWrapper log = LoggerWrapper.getInstance("SecurityPasswordPolicy");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static Hashtable master_invalid_login = new Hashtable();
    private static Vector unused_cache = new Vector();
    private int unused_cache_size;
    private long timestamp_of_current_check;
    private boolean lockout_enabled = false;
    private int lockout_threshold;
    private long lockout_duration;
    private int lockout_duration_min;
    private long lockout_reset_duration;
    private int lockout_gc_threshold;
    private static int sequence_number;
    private static int failure_sequence_number;
    private static int unlock_sequence_number;
    private static String this_server_name;
    private ClusterServices clusterServices = null;
    private MulticastSession multicastSession = null;

    public PasswordGuessing() {
        this.init();
    }

    void init() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        if (serverMBean != null) {
            this_server_name = serverMBean.getName();
        }
        PasswordPolicyMBean passwordPolicyMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().getPasswordPolicy();
        this.lockout_enabled = passwordPolicyMBean.isLockoutEnabled();
        this.lockout_threshold = passwordPolicyMBean.getLockoutThreshold();
        this.lockout_duration_min = passwordPolicyMBean.getLockoutDuration();
        this.lockout_duration = (long)this.lockout_duration_min * 60L * 1000L;
        this.lockout_reset_duration = (long)passwordPolicyMBean.getLockoutResetDuration() * 60L * 1000L;
        this.lockout_gc_threshold = passwordPolicyMBean.getLockoutGCThreshold();
        this.unused_cache_size = passwordPolicyMBean.getLockoutCacheSize();
        if (log.isDebugEnabled()) {
            log.debug("PasswordPolicy settings LockoutEnabled=" + this.lockout_enabled + " LockoutThreshold=" + this.lockout_threshold + " LockoutDuration=" + this.lockout_duration_min + " LockoutResetDuration=" + this.lockout_reset_duration / 60L / 1000L + " LockoutGCThreshold=" + this.lockout_gc_threshold + " LockoutCacheSize=" + this.unused_cache_size);
        }
        this.createMulticastSession();
    }

    public boolean isLocked(String string) {
        if (!this.lockout_enabled || master_invalid_login.size() == 0) {
            return false;
        }
        this.setTimestampOfCurrentCheck();
        if (master_invalid_login.containsKey(string)) {
            InvalidLogin invalidLogin = (InvalidLogin)master_invalid_login.get(string);
            long l = invalidLogin.getLockedTimestamp();
            if (l == 0L) {
                if (log.isDebugEnabled()) {
                    log.debug("User " + string + " is not yet locked");
                }
                return false;
            }
            Security.incrementLoginAttemptsWhileLockedTotalCount();
            Security.incrementInvalidLoginAttemptsTotalCount();
            long l2 = l + this.lockout_duration;
            if (this.getTimestampOfCurrentCheck() < l2) {
                if (log.isDebugEnabled()) {
                    log.debug("User " + string + " is still locked");
                }
                return true;
            }
            this.clearInvalidLoginRecord(invalidLogin);
            Security.incrementUnlockedUsersTotalCount();
            Security.decrementLockedUsersCurrentCount();
            SecurityLogger.logLockoutExpiredInfo((String)string);
            return false;
        }
        return false;
    }

    void logFailure(String string) {
        LoginFailureRecord loginFailureRecord;
        if ((loginFailureRecord = this.logFailure(this_server_name, ++failure_sequence_number, this.getTimestampOfCurrentCheck(), string)) != null) {
            SecurityMessage securityMessage = new SecurityMessage(++sequence_number, loginFailureRecord);
            if (log.isDebugEnabled()) {
                log.debug("About to multicast login failure for user " + string + " " + securityMessage.toString());
            }
            try {
                if (this.createMulticastSession()) {
                    this.multicastSession.send(securityMessage);
                    if (log.isDebugEnabled()) {
                        log.debug("Sent multicast for login failure");
                    }
                }
            }
            catch (IOException iOException) {
                SecurityLogger.logSendingLoginFailure((String)iOException.toString());
            }
        }
    }

    LoginFailureRecord logFailure(String string, int n, long l, String string2) {
        LoginFailureRecord loginFailureRecord = null;
        if (!this.lockout_enabled) {
            return loginFailureRecord;
        }
        if (log.isDebugEnabled()) {
            log.debug("Login failure for user " + string2);
        }
        if (string.equals(this_server_name)) {
            Security.incrementInvalidLoginAttemptsTotalCount();
        }
        InvalidLogin invalidLogin = null;
        if (!master_invalid_login.containsKey(string2)) {
            if (unused_cache.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Retrieving unused invalid login from the cache");
                }
                invalidLogin = (InvalidLogin)unused_cache.elementAt(0);
                unused_cache.removeElementAt(0);
                invalidLogin.setName(string2);
            } else {
                invalidLogin = new InvalidLogin(string2);
            }
            master_invalid_login.put(invalidLogin.getName(), invalidLogin);
        } else {
            invalidLogin = (InvalidLogin)master_invalid_login.get(string2);
        }
        if ((long)master_invalid_login.size() > Security.getInvalidLoginUsersHighCount()) {
            Security.setInvalidLoginUsersHighCount(master_invalid_login.size());
        }
        loginFailureRecord = new LoginFailureRecord(string, n, l, string2);
        invalidLogin.addFailure(loginFailureRecord);
        this.cleanOutStaleFailureRecords(invalidLogin);
        if (log.isDebugEnabled()) {
            log.debug("User " + string2 + " has " + invalidLogin.getFailureCount() + " failures");
        }
        if (invalidLogin.getFailureCount() >= this.lockout_threshold) {
            SecurityLogger.logLockingUser((String)string2, (int)invalidLogin.getFailureCount(), (int)this.lockout_duration_min);
            Security.incrementUserLockoutTotalCount();
            Security.incrementLockedUsersCurrentCount();
            invalidLogin.setLockedTimestamp(l);
        }
        this.garbageCollectInvalidLoginRecords();
        return loginFailureRecord;
    }

    void logSuccess(String string) {
        if (this.unlockLocal(string)) {
            UnlockUserRecord unlockUserRecord = new UnlockUserRecord(this_server_name, ++unlock_sequence_number, this.getTimestampOfCurrentCheck(), string);
            SecurityMessage securityMessage = new SecurityMessage(++sequence_number, unlockUserRecord);
            if (log.isDebugEnabled()) {
                log.debug("About to multicast unlock user: " + string + " " + securityMessage.toString());
            }
            try {
                if (this.createMulticastSession()) {
                    this.multicastSession.send(securityMessage);
                    if (log.isDebugEnabled()) {
                        log.debug("Sent multicast for unlock user");
                    }
                }
            }
            catch (IOException iOException) {
                if (string == null) {
                    SecurityLogger.logBroadcastUnlockUserFailure((String)"null", (String)iOException.toString());
                }
                SecurityLogger.logBroadcastUnlockUserFailure((String)string, (String)iOException.toString());
            }
        }
    }

    private boolean unlockLocal(String string) {
        if (!this.lockout_enabled || master_invalid_login.size() == 0) {
            return false;
        }
        if (string == null) {
            throw new AssertionError("Received a null user name");
        }
        if (!master_invalid_login.containsKey(string)) {
            return false;
        }
        InvalidLogin invalidLogin = (InvalidLogin)master_invalid_login.get(string);
        if (invalidLogin == null) {
            throw new AssertionError("Hashtable has the key but can't get the entry");
        }
        long l = invalidLogin.getLockedTimestamp();
        if (log.isDebugEnabled()) {
            log.debug("Unlocked user or successful login" + string + " cleaning out old invalid login record");
        }
        InvalidLogin invalidLogin2 = (InvalidLogin)master_invalid_login.remove(string);
        invalidLogin2.erase();
        if (unused_cache.size() < this.unused_cache_size) {
            if (log.isDebugEnabled()) {
                log.debug("Putting unused invalid login record in cache");
            }
            unused_cache.addElement(invalidLogin2);
        } else {
            invalidLogin2 = null;
        }
        if (l != 0L) {
            Security.incrementUnlockedUsersTotalCount();
            Security.decrementLockedUsersCurrentCount();
        }
        return true;
    }

    private void cleanOutStaleFailureRecords(InvalidLogin invalidLogin) {
        if (invalidLogin == null) {
            return;
        }
        Vector vector = invalidLogin.getFailures();
        if (vector == null) {
            throw new AssertionError("Inconsistent InvalidLogin record");
        }
        if (vector.size() == 0) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            LoginFailureRecord loginFailureRecord = (LoginFailureRecord)vector.elementAt(i);
            if (this.getTimestampOfCurrentCheck() - loginFailureRecord.timestamp <= this.lockout_reset_duration) break;
            if (log.isDebugEnabled()) {
                log.debug("Discarding stale login failure record");
            }
            vector.removeElementAt(i);
            loginFailureRecord = null;
        }
    }

    private void garbageCollectInvalidLoginRecords() {
        long l = System.currentTimeMillis();
        InvalidLogin invalidLogin = null;
        LoginFailureRecord loginFailureRecord = null;
        int n = master_invalid_login.size();
        if (n == 0 || n < this.lockout_gc_threshold) {
            if (log.isDebugEnabled()) {
                log.debug("InvalidLogin Record GC not needed");
            }
            return;
        }
        Enumeration enumeration = master_invalid_login.elements();
        while (enumeration.hasMoreElements()) {
            invalidLogin = (InvalidLogin)enumeration.nextElement();
            if (invalidLogin == null) {
                throw new AssertionError("Enumerator returned a null element for a key");
            }
            long l2 = invalidLogin.getLockedTimestamp();
            if (l2 != 0L || (loginFailureRecord = (LoginFailureRecord)invalidLogin.getLatestFailure()) == null || loginFailureRecord.eventTime() >= l - this.lockout_reset_duration) continue;
            if (log.isDebugEnabled()) {
                log.debug("Garbage collecting InvalidLogin record for user: " + invalidLogin.getName());
            }
            this.clearInvalidLoginRecord(invalidLogin);
        }
        if (log.isDebugEnabled()) {
            log.debug("InvalidLogin Record GC done: " + (n - master_invalid_login.size()) + " records garbage collected");
        }
    }

    private void clearInvalidLoginRecord(InvalidLogin invalidLogin) {
        String string = null;
        string = invalidLogin.getName();
        InvalidLogin invalidLogin2 = (InvalidLogin)master_invalid_login.remove(string);
        invalidLogin2.erase();
        if (unused_cache.size() < this.unused_cache_size) {
            if (log.isDebugEnabled()) {
                log.debug("Putting unused invalid login record in cache");
            }
            unused_cache.addElement(invalidLogin2);
        } else {
            invalidLogin2 = null;
        }
    }

    private long getTimestampOfCurrentCheck() {
        if (this.timestamp_of_current_check == 0L) {
            this.setTimestampOfCurrentCheck();
        }
        return this.timestamp_of_current_check;
    }

    private void setTimestampOfCurrentCheck() {
        this.timestamp_of_current_check = System.currentTimeMillis();
    }

    public void processSecurityMessage(int n, SecurityMulticastRecord securityMulticastRecord) {
        if (!(securityMulticastRecord instanceof LoginFailureRecord) && !(securityMulticastRecord instanceof UnlockUserRecord)) {
            return;
        }
        if (securityMulticastRecord.eventOrigin().equals(this_server_name)) {
            return;
        }
        if (securityMulticastRecord instanceof LoginFailureRecord) {
            LoginFailureRecord loginFailureRecord = (LoginFailureRecord)securityMulticastRecord;
            if (log.isDebugEnabled()) {
                log.debug("Received a LoginFailureRecord: " + loginFailureRecord.toString());
            }
            this.logFailure(loginFailureRecord.eventOrigin(), loginFailureRecord.eventSequenceNumber(), loginFailureRecord.eventTime(), loginFailureRecord.userName());
        } else if (securityMulticastRecord instanceof UnlockUserRecord) {
            UnlockUserRecord unlockUserRecord = (UnlockUserRecord)securityMulticastRecord;
            if (log.isDebugEnabled()) {
                log.debug("Received an UnlockUserRecord: " + unlockUserRecord.toString());
            }
            if (this.unlockLocal(unlockUserRecord.userName()) && log.isDebugEnabled()) {
                log.debug("Locked user has now been unlocked locally");
            }
        }
    }

    public void runtimeClearLockout(String string) {
        if (string == null) {
            throw new AssertionError("Received a null user name");
        }
        if (string.equals("")) {
            if (log.isDebugEnabled()) {
                log.debug("clearLockout was passed an empty user name");
            }
            return;
        }
        if (!this.lockout_enabled) {
            return;
        }
        String string2 = "weblogic.passwordpolicy";
        User user = Security.getCurrentUser();
        if (!Security.hasPermission((Principal)user, string2, Security.getRealm().getPermission("unlockuser"), '.')) {
            Security.checkPermission((Principal)user, string2, Security.getRealm().getPermission("unlockuser"), '.');
        }
        this.logSuccess(string);
        SecurityLogger.logExplicitUserUnlockInfo((String)string);
    }

    public long getLastLoginFailure(String string) {
        if (!this.lockout_enabled) {
            return 0L;
        }
        if (string == null) {
            throw new AssertionError("Received a null user name");
        }
        if (string.equals("")) {
            if (log.isDebugEnabled()) {
                log.debug("getLastLoginFailure was passed a null or empty user name");
            }
            return 0L;
        }
        InvalidLogin invalidLogin = null;
        if (!master_invalid_login.containsKey(string)) {
            return 0L;
        }
        invalidLogin = (InvalidLogin)master_invalid_login.get(string);
        if (invalidLogin == null) {
            throw new AssertionError("Inconsistent hashtable - key exists but not value");
        }
        Vector vector = invalidLogin.getFailures();
        if (vector == null) {
            throw new AssertionError("Inconsistent InvalidLogin record");
        }
        if (vector.size() == 0) {
            return 0L;
        }
        LoginFailureRecord loginFailureRecord = (LoginFailureRecord)vector.lastElement();
        if (loginFailureRecord != null) {
            return loginFailureRecord.timestamp;
        }
        return 0L;
    }

    public int getLoginFailureCount(String string) {
        if (!this.lockout_enabled) {
            return 0;
        }
        if (string == null) {
            throw new AssertionError("Received a null user name");
        }
        if (string.equals("")) {
            if (log.isDebugEnabled()) {
                log.debug("getLoginFailureCount was passed a null or empty user name");
            }
            return 0;
        }
        InvalidLogin invalidLogin = null;
        if (!master_invalid_login.containsKey(string)) {
            return 0;
        }
        invalidLogin = (InvalidLogin)master_invalid_login.get(string);
        if (invalidLogin == null) {
            throw new AssertionError("Inconsistent hashtable - key exists but not value");
        }
        Vector vector = invalidLogin.getFailures();
        if (vector == null) {
            return 0;
        }
        return vector.size();
    }

    private boolean createMulticastSession() {
        if (this.multicastSession != null) {
            return true;
        }
        this.clusterServices = ClusterService.getServices();
        if (this.clusterServices != null) {
            this.multicastSession = this.clusterServices.createMulticastSession(null, -1);
            if (this.multicastSession != null) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("Can't create multicastSession even though ClusterServices are available");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Can't create multicastSession because ClusterServices are unavailable");
        }
        return false;
    }

    public boolean runtimeIsLocked(String string) {
        InvalidLogin invalidLogin;
        long l;
        if (!this.lockout_enabled || master_invalid_login.size() == 0) {
            return false;
        }
        this.setTimestampOfCurrentCheck();
        return master_invalid_login.containsKey(string) && (l = (invalidLogin = (InvalidLogin)master_invalid_login.get(string)).getLockedTimestamp()) != 0L;
    }
}

