/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.Permission;
import java.util.Hashtable;
import java.util.Properties;
import weblogic.common.internal.LogOutputStream;
import weblogic.security.acl.BasicRealm;
import weblogic.security.acl.PasswordGuessing;
import weblogic.security.acl.Security;
import weblogic.security.acl.User;
import weblogic.security.acl.UserInfo;
import weblogic.security.audit.Audit;
import weblogic.security.principal.RealmAdapterUser;

public final class Realm {
    static String defaultImplName = "weblogic.security.acl.internal.FileRealm";
    static Hashtable realms = new Hashtable();
    static int lockoutSeqNumber = 0;
    private static LogOutputStream log;

    public static BasicRealm getRealm(String string) {
        return Realm.getRealm(string, null, defaultImplName, null);
    }

    public static BasicRealm getRealm(String string, Object object) {
        return Realm.getRealm(string, object, defaultImplName, null);
    }

    public static BasicRealm getRealm(String string, Object object, String string2) {
        return Realm.getRealm(string, object, string2, null);
    }

    public static BasicRealm getRealm(String string, Object object, String string2, Properties properties) {
        try {
            BasicRealm basicRealm = (BasicRealm)realms.get(string);
            if (basicRealm != null) {
                return basicRealm;
            }
            if (string2 == null) {
                string2 = defaultImplName;
            }
            basicRealm = (BasicRealm)Class.forName(string2).newInstance();
            basicRealm.init(string, object);
            basicRealm.load(string, object);
            realms.put(string, basicRealm);
            return basicRealm;
        }
        catch (Exception exception) {
            throw new IllegalAccessError(exception.toString());
        }
    }

    public static boolean checkPermission(Principal principal, String string, String string2, String string3) {
        return Realm.checkPermission("Central Security", principal, string, string2, string3, '.');
    }

    public static boolean checkPermission(String string, Principal principal, String string2, String string3, String string4) {
        return Realm.checkPermission(string, principal, string2, string3, string4, '.');
    }

    public static boolean checkPermission(Principal principal, String string, String string2, String string3, char c) {
        return Realm.checkPermission("Central Security", principal, string, string2, string3, c);
    }

    public static boolean checkPermission(String string, Principal principal, String string2, String string3, String string4, char c) {
        BasicRealm basicRealm = Realm.getRealm(string2);
        Permission permission = basicRealm.getPermission(string4);
        Acl acl = basicRealm.getAcl(string3, c);
        User user = null;
        if (principal instanceof RealmAdapterUser) {
            user = Security.getRealm().getUser(principal.getName());
        }
        boolean bl = principal != null && permission != null && acl != null && acl.checkPermission((Principal)(user != null ? user : principal), permission);
        Audit.checkPermission(string, acl, (Principal)(user != null ? user : principal), permission, bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogOutputStream getLog() {
        if (log != null) return log;
        Class<Realm> clazz = Realm.class;
        synchronized (Realm.class) {
            if (log != null) return log;
            log = new LogOutputStream("Realm");
            // ** MonitorExit[var0] (shouldn't be in output)
            return log;
        }
    }

    public static User authenticate(UserInfo userInfo) throws SecurityException {
        PasswordGuessing passwordGuessing = Security.getPasswordGuessing();
        String string = userInfo.getRealmName();
        BasicRealm basicRealm = Realm.getRealm(string);
        if (basicRealm == null) {
            throw new SecurityException("Realm " + string + " is unknown here");
        }
        String string2 = userInfo.getName();
        if (string2 != null && passwordGuessing != null && passwordGuessing.isLocked(string2)) {
            throw new SecurityException("Authentication for user " + string2 + " denied in realm " + string);
        }
        User user = basicRealm.getUser(userInfo);
        if (user == null) {
            if (string2 != null && passwordGuessing != null) {
                passwordGuessing.logFailure(string2);
            }
            throw new SecurityException("Authentication for user " + string2 + " denied in realm " + string);
        }
        if (passwordGuessing != null) {
            passwordGuessing.logSuccess(user.getName());
        }
        return user;
    }

    public static String getAuthenticatedName(UserInfo userInfo) throws SecurityException {
        return Realm.authenticate(userInfo).getName();
    }
}

