/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.util.Vector;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.t3.srvr.T3Srvr;

public final class SSLUserInfo
extends DefaultUserInfoImpl {
    private static final long serialVersionUID = 4109721614403507950L;
    private transient Vector sslCerts;

    public SSLUserInfo(DefaultUserInfoImpl defaultUserInfoImpl) {
        super(defaultUserInfoImpl.getName(), null);
        if (T3Srvr.getT3Srvr() == null) {
            throw new SecurityException("cannot find T3 server object");
        }
        if (defaultUserInfoImpl.hasPassword()) {
            this.setCredential(defaultUserInfoImpl.getPassword());
        }
        if (defaultUserInfoImpl.hasCertificates()) {
            this.setCredential(defaultUserInfoImpl.getCertificates());
        }
    }

    public void setSSLCertificates(Vector vector) {
        this.sslCerts = vector;
    }

    public Vector getSSLCertificates() {
        return this.sslCerts;
    }

    public Vector getCertificates() {
        return this.sslCerts;
    }

    public boolean hasCertificates() {
        return this.sslCerts.size() > 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SSLUserInfo)) {
            return false;
        }
        SSLUserInfo sSLUserInfo = (SSLUserInfo)object;
        if (this.hasCertificates() && !sSLUserInfo.hasCertificates()) {
            return false;
        }
        if (!this.sslCerts.equals(sSLUserInfo.getSSLCertificates())) {
            return false;
        }
        String string = sSLUserInfo.getRealmName();
        String string2 = sSLUserInfo.getPassword();
        return (this.getRealmName() == null ? string == null : this.getRealmName().equals(string)) && (this.getPassword() == null ? string2 == null : this.getPassword().equals(string2));
    }
}

