/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.security.AccessController;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.Group;
import java.security.acl.Permission;
import java.util.Set;
import weblogic.management.configuration.SecurityMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.spi.HostID;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.BasicRealm;
import weblogic.security.acl.CachingRealm;
import weblogic.security.acl.PasswordGuessing;
import weblogic.security.acl.PrivilegedAction;
import weblogic.security.acl.PrivilegedExceptionAction;
import weblogic.security.acl.RealmProxy;
import weblogic.security.acl.SecurityMessage;
import weblogic.security.acl.User;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.audit.Audit;
import weblogic.security.principal.RealmAdapterUser;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public final class Security {
    private static BasicRealm wlRealm;
    private static RealmProxy wlRealmProxy;
    private static final boolean verbose = false;
    static final String AUDIT_NAME = "Central Security";
    private static PasswordGuessing passwordguessing;
    private static AuthenticatedSubject kernelID;
    private static long cum_user_lockout_count;
    private static long cum_invalid_login_count;
    private static long cum_locked_attempts_count;
    private static long high_invalid_login_users;
    private static long cum_user_unlock_count;
    private static long current_lock_count;

    public static BasicRealm getRealm() {
        return wlRealm;
    }

    public static boolean hasPermission(Principal principal, String string, String string2, char c) {
        return Security.hasPermission(AUDIT_NAME, principal, string, string2, c);
    }

    public static boolean hasPermission(String string, Principal principal, String string2, String string3, char c) {
        return Security.hasPermission(string, principal, string2, wlRealm.getPermission(string3), c);
    }

    public static boolean hasPermission(Principal principal, String string, Permission permission, char c) {
        return Security.hasPermission(AUDIT_NAME, principal, string, permission, c);
    }

    public static boolean hasPermission(String string, Principal principal, String string2, Permission permission, char c) {
        User user = null;
        if (principal instanceof RealmAdapterUser) {
            user = Security.getRealm().getUser(principal.getName());
        }
        Acl acl = wlRealm.getAcl(string2, c);
        boolean bl = principal != null && permission != null && acl != null && acl.checkPermission((Principal)(user != null ? user : principal), permission);
        Audit.checkPermission(string, acl, (Principal)(user != null ? user : principal), permission, bl);
        return bl;
    }

    public static boolean hasPermission(Principal principal, String string, Permission permission, char c, Acl acl) {
        return Security.hasPermission(AUDIT_NAME, principal, string, permission, c, acl);
    }

    public static boolean hasPermission(String string, Principal principal, String string2, Permission permission, char c, Acl acl) {
        Acl acl2;
        boolean bl = false;
        User user = null;
        if (principal instanceof RealmAdapterUser) {
            user = Security.getRealm().getUser(principal.getName());
        }
        if ((acl2 = wlRealm.getAcl(string2, c)) == null) {
            if (acl == null) {
                bl = true;
            }
            acl2 = acl;
        }
        if (!bl) {
            bl = principal != null && permission != null && acl2.checkPermission((Principal)(user != null ? user : principal), permission);
        }
        Audit.checkPermission(string, acl2, (Principal)(user != null ? user : principal), permission, bl);
        return bl;
    }

    public static boolean hasPermission(String string, Permission permission, char c) {
        return Security.hasPermission((Principal)Security.getCurrentUser(), string, permission, c);
    }

    public static boolean hasPermission(String string, Permission permission, char c, Acl acl) {
        return Security.hasPermission((Principal)Security.getCurrentUser(), string, permission, c, acl);
    }

    public static String getThreadCurrentUserName() {
        User user = Security.getCurrentUser();
        return user != null ? user.getName() : null;
    }

    public static User getCurrentUser() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelID);
        if (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            return wlRealm.getUser(ManagementService.getRuntimeAccess(kernelID).getDomain().getSecurity().getSystemUser());
        }
        RealmAdapterUser realmAdapterUser = null;
        Set set = authenticatedSubject.getPrincipals(RealmAdapterUser.class);
        Object[] objectArray = set.toArray();
        if (objectArray != null && objectArray.length > 0) {
            realmAdapterUser = (RealmAdapterUser)((Object)objectArray[0]);
        }
        User user = null;
        if (wlRealm != null) {
            if (realmAdapterUser == null) {
                return wlRealm.getUser("guest");
            }
            user = wlRealm.getUser(realmAdapterUser.getName());
            if (user == null) {
                user = new User(realmAdapterUser.getName());
            }
        }
        return user;
    }

    public static void checkPermission(Principal principal, String string, Permission permission, char c, Acl acl) throws SecurityException {
        Security.checkPermission(AUDIT_NAME, principal, string, permission, c, acl);
    }

    public static void checkPermission(String string, Principal principal, String string2, Permission permission, char c, Acl acl) throws SecurityException {
        if (Security.hasPermission(string, principal, string2, permission, c, acl)) {
            return;
        }
        Security.logAndThrow("User \"" + principal + "\" does not have Permission \"" + permission + "\" based on ACL \"" + string2 + "\".");
    }

    public static void checkPermission(Principal principal, String string, Permission permission, char c) throws SecurityException {
        Security.checkPermission(AUDIT_NAME, principal, string, permission, c);
    }

    public static void checkPermission(String string, Principal principal, String string2, Permission permission, char c) throws SecurityException {
        SecurityMBean securityMBean = ManagementService.getRuntimeAccess(kernelID).getDomain().getSecurity();
        if (securityMBean.getLogAllChecksEnabled()) {
            Acl acl = wlRealm.getAcl(string2, c);
            String string3 = acl == null ? " on (unknown) ACL \"" + string2 + "\"" : "on ACL \"" + acl.toString() + "\"";
            SecurityLogger.logCheckUserPermissionInfo((String)((Object)principal).toString(), (String)permission.toString(), (String)string3);
        }
        if (Security.hasPermission(string, principal, string2, permission, c)) {
            return;
        }
        Security.logAndThrow("User \"" + principal + "\" does not have Permission \"" + permission + "\" based on ACL \"" + string2 + "\".");
    }

    public static void checkPermission(String string, Permission permission, char c) throws SecurityException {
        Security.checkPermission(AUDIT_NAME, string, permission, c);
    }

    public static void checkPermission(String string, String string2, Permission permission, char c) throws SecurityException {
        Security.checkPermission(string, (Principal)Security.getCurrentUser(), string2, permission, c);
    }

    public static UserInfo getUserInfo(String string, Object object) {
        return wlRealmProxy.createUserInfo(string, object);
    }

    public static User getUser(String string, Object object) {
        return wlRealm.getUser(Security.getUserInfo(string, object));
    }

    public static void logAndThrow(String string) throws SecurityException {
        SecurityException securityException = new SecurityException(string);
        SecurityLogger.logAccessFailedInfo((String)Thread.currentThread().toString(), (String)securityException.toString());
        throw securityException;
    }

    public static void init(BasicRealm basicRealm) {
        wlRealm = basicRealm;
        wlRealmProxy = RealmProxy.getRealmProxy(wlRealm.getName());
        weblogic.security.acl.internal.Security.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doAsPrivileged(UserInfo userInfo, PrivilegedAction privilegedAction) {
        if (privilegedAction == null) {
            throw new NullPointerException("null action provided");
        }
        AuthenticatedUser authenticatedUser = weblogic.security.acl.internal.Security.authenticate(userInfo);
        if (authenticatedUser == null) {
            throw new SecurityException("Unable to authenticate " + userInfo);
        }
        SecurityServiceManager.pushSubject((AuthenticatedSubject)kernelID, (AuthenticatedSubject)SecurityServiceManager.getASFromAU((AuthenticatedUser)authenticatedUser));
        Object object = null;
        try {
            object = privilegedAction.run();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            SecurityServiceManager.popSubject((AuthenticatedSubject)kernelID);
            throw throwable;
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)kernelID);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doAsPrivileged(UserInfo userInfo, PrivilegedExceptionAction privilegedExceptionAction) throws Exception {
        if (privilegedExceptionAction == null) {
            throw new NullPointerException("null action provided");
        }
        AuthenticatedUser authenticatedUser = weblogic.security.acl.internal.Security.authenticate(userInfo);
        if (authenticatedUser == null) {
            throw new SecurityException("Unable to authenticate " + userInfo);
        }
        SecurityServiceManager.pushSubject((AuthenticatedSubject)kernelID, (AuthenticatedSubject)SecurityServiceManager.getASFromAU((AuthenticatedUser)authenticatedUser));
        Object object = null;
        try {
            object = privilegedExceptionAction.run();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            SecurityServiceManager.popSubject((AuthenticatedSubject)kernelID);
            throw throwable;
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)kernelID);
        return object;
    }

    public static Principal getPrincipal(String string) {
        if (wlRealm instanceof CachingRealm) {
            return ((CachingRealm)wlRealm).getPrincipal(string);
        }
        Group group = wlRealm.getGroup(string);
        if (group == null) {
            group = wlRealm.getUser(string);
        }
        return group;
    }

    public static long getUserLockoutTotalCount() {
        return cum_user_lockout_count;
    }

    static void incrementUserLockoutTotalCount() {
        ++cum_user_lockout_count;
    }

    public static long getInvalidLoginAttemptsTotalCount() {
        return cum_invalid_login_count;
    }

    static void incrementInvalidLoginAttemptsTotalCount() {
        ++cum_invalid_login_count;
    }

    public static long getLoginAttemptsWhileLockedTotalCount() {
        return cum_locked_attempts_count;
    }

    static void incrementLoginAttemptsWhileLockedTotalCount() {
        ++cum_locked_attempts_count;
    }

    public static long getInvalidLoginUsersHighCount() {
        return high_invalid_login_users;
    }

    static void setInvalidLoginUsersHighCount(long l) {
        high_invalid_login_users = l;
    }

    public static long getUnlockedUsersTotalCount() {
        return cum_user_unlock_count;
    }

    static void incrementUnlockedUsersTotalCount() {
        ++cum_user_unlock_count;
    }

    public static long getLockedUsersCurrentCount() {
        return current_lock_count;
    }

    static void incrementLockedUsersCurrentCount() {
        ++current_lock_count;
    }

    static void decrementLockedUsersCurrentCount() {
        --current_lock_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordGuessing getPasswordGuessing() {
        Class<PasswordGuessing> clazz = PasswordGuessing.class;
        synchronized (PasswordGuessing.class) {
            if (passwordguessing == null) {
                passwordguessing = (PasswordGuessing)SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)kernelID, (java.security.PrivilegedAction)new java.security.PrivilegedAction(){

                    public Object run() {
                        return new PasswordGuessing();
                    }
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return passwordguessing;
        }
    }

    public static void receiveSecurityMessage(HostID hostID, SecurityMessage securityMessage) {
        passwordguessing.processSecurityMessage(securityMessage.nextSeqNo(), securityMessage.record());
    }

    static {
        kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

