/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.cluster.GroupMessage;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.Security;
import weblogic.security.acl.SecurityMulticastRecord;

public final class SecurityMessage
implements GroupMessage,
Externalizable {
    private static final long serialVersionUID = -5638732491394667306L;
    private int nextSeqNo;
    private SecurityMulticastRecord record;

    public int nextSeqNo() {
        return this.nextSeqNo;
    }

    public SecurityMulticastRecord record() {
        return this.record;
    }

    public SecurityMessage(int n, SecurityMulticastRecord securityMulticastRecord) {
        this.nextSeqNo = n;
        this.record = securityMulticastRecord;
    }

    public String toString() {
        return "SecurityMessage record:" + this.record + " nextSeqNo:" + this.nextSeqNo;
    }

    public void execute(HostID hostID) {
        Security.receiveSecurityMessage(hostID, this);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.nextSeqNo);
        WLObjectOutput wLObjectOutput = (WLObjectOutput)objectOutput;
        wLObjectOutput.writeObjectWL((Object)this.record);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.nextSeqNo = objectInput.readInt();
        WLObjectInput wLObjectInput = (WLObjectInput)objectInput;
        this.record = (SecurityMulticastRecord)wLObjectInput.readObjectWL();
    }

    public SecurityMessage() {
    }
}

