/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import weblogic.logging.LogOutputStream;

public class TTLCache {
    private LogOutputStream log;
    private Vector[] table;
    private int buckets;
    private int capacity;
    private int size;
    private long ttl;
    private int insertions;
    private int lookups;
    private int staleEvictions;
    private int lruEvictions;
    private int hits;
    private int misses;
    private static final int CLEANUP_PERIOD = 5000;
    private int opsSinceCleanup;

    public TTLCache(int n, long l) {
        this(n, n * 6, l);
    }

    public TTLCache(int n, int n2, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("ttl <= 0");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("capacity < buckets");
        }
        this.table = new Vector[n];
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = new Vector();
        }
        this.buckets = n;
        this.capacity = n2;
        this.size = 0;
        this.ttl = l;
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException("null value");
        }
        this.maybeCleanup();
        int n = this.hash(object);
        Vector vector = this.table[n];
        long l = System.currentTimeMillis();
        long l2 = Long.MAX_VALUE;
        int n2 = -1;
        Entry entry = new Entry(object, object2, l);
        ++this.insertions;
        Enumeration enumeration = vector.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            Entry entry2 = (Entry)enumeration.nextElement();
            if (entry2 == null) {
                vector.setElementAt(entry, n3);
                ++this.size;
                return null;
            }
            if (entry2.ttl < l) {
                vector.setElementAt(entry, n3);
                ++this.staleEvictions;
                return null;
            }
            if (entry2.key.equals(object)) {
                vector.setElementAt(entry, n3);
                return entry2.value;
            }
            if (entry2.lastUse < l2) {
                l2 = entry2.lastUse;
                n2 = n3;
            }
            ++n3;
        }
        if (this.size < this.capacity) {
            vector.addElement(entry);
            ++this.size;
            return null;
        }
        Entry entry3 = null;
        if (n2 != -1) {
            entry3 = (Entry)vector.elementAt(n2);
            vector.setElementAt(entry, n2);
        } else {
            vector.addElement(entry);
            for (int i = 1; i < this.buckets; ++i) {
                vector = this.table[(n + i) % this.buckets];
                l2 = Long.MAX_VALUE;
                n2 = -1;
                enumeration = vector.elements();
                int n4 = 0;
                while (enumeration.hasMoreElements()) {
                    Entry entry4 = (Entry)enumeration.nextElement();
                    if (entry4 != null && entry4.lastUse < l2) {
                        l2 = entry4.lastUse;
                        n2 = n4;
                    }
                    ++n4;
                }
                if (n2 == -1) continue;
                entry3 = (Entry)vector.elementAt(n2);
                vector.setElementAt(null, n2);
                ++this.lruEvictions;
                if (entry3 == null) continue;
                return entry3.value;
            }
        }
        ++this.lruEvictions;
        return null;
    }

    public Object put(Object object) {
        return this.put(object, object);
    }

    public Object get(Object object) {
        if (object == null) {
            return null;
        }
        this.maybeCleanup();
        Entry entry = this.findEntry(object);
        return entry != null ? entry.value : null;
    }

    private int hash(Object object) {
        int n = object.hashCode();
        return (n > 0 ? n : -n) % this.buckets;
    }

    public Object remove(Object object) {
        Vector vector = this.table[this.hash(object)];
        Enumeration enumeration = vector.elements();
        long l = Long.MIN_VALUE;
        Entry entry = null;
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Entry entry2 = (Entry)enumeration.nextElement();
            if (entry2 != null && object.equals(entry2.key)) {
                if (entry == null) {
                    if (l == Long.MIN_VALUE) {
                        l = System.currentTimeMillis();
                    }
                    if (entry2.ttl >= l) {
                        entry = entry2;
                    }
                }
                vector.setElementAt(null, n);
            }
            ++n;
        }
        this.maybeCleanup();
        return entry;
    }

    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = new Vector();
        }
        this.size = 0;
        this.opsSinceCleanup = 0;
        this.insertions = 0;
        this.lookups = 0;
        this.staleEvictions = 0;
        this.lruEvictions = 0;
        this.hits = 0;
        this.misses = 0;
    }

    private void maybeCleanup() {
        ++this.opsSinceCleanup;
        if (this.opsSinceCleanup >= 5000) {
            this.cleanup();
        }
    }

    public void cleanup() {
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.buckets; ++i) {
            Vector vector = this.table[i];
            int n = vector.size();
            if (n <= 0) continue;
            for (int j = 0; j < n; ++j) {
                Entry entry = (Entry)vector.elementAt(j);
                if (entry != null) {
                    if (entry.ttl >= l) continue;
                    ++this.staleEvictions;
                }
                vector.removeElementAt(j);
                --this.size;
                --j;
                --n;
            }
        }
        this.opsSinceCleanup = 0;
    }

    private Entry findEntry(Object object) {
        if (object == null) {
            return null;
        }
        Vector vector = this.table[this.hash(object)];
        long l = Long.MIN_VALUE;
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            if (entry != null && object.equals(entry.key)) {
                if (l == Long.MIN_VALUE) {
                    l = System.currentTimeMillis();
                }
                if (entry.ttl >= l) {
                    entry.lastUse = l;
                    ++this.hits;
                    return entry;
                }
                vector.setElementAt(null, n);
                ++this.staleEvictions;
                --this.size;
            }
            ++n;
        }
        ++this.misses;
        return null;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(Object object) {
        this.maybeCleanup();
        return this.findEntry(object) != null;
    }

    public void setDebugLog(LogOutputStream logOutputStream) {
        this.log = logOutputStream;
    }

    public LogOutputStream getDebugLog() {
        return this.log;
    }

    public int getLookups() {
        return this.lookups;
    }

    public double getHitRate() {
        return (double)this.hits / (double)this.lookups;
    }

    public int getInsertions() {
        return this.insertions;
    }

    public double getStaleEvictionRate() {
        return (double)this.staleEvictions / (double)this.insertions;
    }

    public double getLRUEvictionRate() {
        return (double)this.lruEvictions / (double)this.insertions;
    }

    private static final class UnitTest {
        private UnitTest() {
        }

        public static void main(String[] stringArray) {
            TTLCache tTLCache = new TTLCache(3, 25000L);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            try {
                while (true) {
                    long l = System.currentTimeMillis();
                    String string = bufferedReader.readLine();
                    if (string != null) {
                        String string2;
                        if (string.equals("get")) {
                            string2 = bufferedReader.readLine();
                            System.out.println(tTLCache.get(string2));
                            continue;
                        }
                        if (string.equals("put")) {
                            string2 = bufferedReader.readLine();
                            String string3 = bufferedReader.readLine();
                            tTLCache.put(string2, string3);
                            continue;
                        }
                        System.err.println("??? bad command: " + string);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        }
    }

    class Entry {
        Object key;
        Object value;
        long ttl;
        long lastUse;

        Entry(Object object, Object object2, long l) {
            this.key = object;
            this.value = object2;
            this.ttl = l + TTLCache.this.ttl;
            this.lastUse = l;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public long getTTL() {
            return this.ttl;
        }

        public boolean equals(Object object) {
            if (object instanceof Entry && object != null) {
                Entry entry = (Entry)object;
                return this.ttl == entry.ttl && this.key.equals(entry.key) && this.value.equals(entry.value);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

