/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.AclEntryImpl;
import weblogic.security.acl.AclImpl;
import weblogic.security.acl.CertAuthentication;
import weblogic.security.acl.DefaultUserImpl;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.GroupImpl;
import weblogic.security.acl.ManageableRealm;
import weblogic.security.acl.PermissionImpl;
import weblogic.security.acl.SSLUserInfo;
import weblogic.security.acl.User;
import weblogic.security.acl.UserInfo;
import weblogic.security.audit.Audit;

public final class DefaultRealmImpl
implements ManageableRealm {
    private static final long serialVersionUID = -2094130678440103135L;
    private static final String ACL_OWNER_NAME = "system";
    String name;
    protected Hashtable users = new Hashtable();
    private DefaultUserImpl aclOwner;
    protected Hashtable groups = new Hashtable();
    protected Hashtable acls = new Hashtable();
    protected Hashtable permissions = new Hashtable();

    public void init(String string, Object object) throws NotOwnerException {
        if (this.aclOwner != null && this.aclOwner != this.getAclOwner(object)) {
            throw new NotOwnerException();
        }
        this.name = string;
        this.aclOwner = new DefaultUserImpl(ACL_OWNER_NAME, object, this);
    }

    public String getName() {
        return this.name;
    }

    public User getUser(String string) {
        return (User)this.users.get(string);
    }

    public User getUser(UserInfo userInfo) {
        return this.authInternal(userInfo);
    }

    private User authInternal(UserInfo userInfo) {
        User user = null;
        if (userInfo instanceof DefaultUserInfoImpl) {
            DefaultUserInfoImpl defaultUserInfoImpl = (DefaultUserInfoImpl)userInfo;
            String string = defaultUserInfoImpl.getName();
            if (defaultUserInfoImpl.hasCertificates()) {
                user = this.authCertificates(string, defaultUserInfoImpl.getCertificates());
            }
            if (user == null && defaultUserInfoImpl.hasPassword()) {
                user = this.authUserPassword(defaultUserInfoImpl);
            }
            if (user == null && defaultUserInfoImpl instanceof SSLUserInfo) {
                SSLUserInfo sSLUserInfo = (SSLUserInfo)defaultUserInfoImpl;
                user = this.authSSLCertificates(string, sSLUserInfo.getSSLCertificates());
            }
        } else {
            user = this.authUserPassword(userInfo);
        }
        return user;
    }

    private User authUserPassword(UserInfo userInfo) {
        User user = this.getUser(userInfo.getName());
        User user2 = user instanceof DefaultUserImpl && ((DefaultUserImpl)user).hasMatchingInfo(userInfo) ? user : null;
        Audit.authenticateUser("Default Realm", userInfo, user2);
        return user2;
    }

    private User authCertificates(String string, Vector vector) {
        User user = CertAuthentication.authenticate(string, vector, false);
        if (user != null) {
            return this.getUser(user.getName());
        }
        return null;
    }

    private User authSSLCertificates(String string, Vector vector) {
        User user = CertAuthentication.authenticate(string, vector, true);
        if (user != null) {
            return this.getUser(user.getName());
        }
        return null;
    }

    public Principal getAclOwner(Object object) {
        return this.aclOwner.hasMatchingInfo(new DefaultUserInfoImpl(ACL_OWNER_NAME, object, this.name)) ? this.aclOwner : null;
    }

    public Group getGroup(String string) {
        return (Group)this.groups.get(string);
    }

    public Acl getAcl(String string) {
        return (Acl)this.acls.get(string);
    }

    public Acl getAcl(String string, char c) {
        Acl acl = this.getAcl(string);
        int n = string.lastIndexOf(c);
        while (acl == null && n >= 0) {
            string = string.substring(0, n);
            acl = this.getAcl(string);
            n = string.lastIndexOf(c, n - 1);
        }
        return acl;
    }

    public Permission getPermission(String string) {
        if (string == null) {
            return null;
        }
        Permission permission = (Permission)this.permissions.get(string);
        return permission != null ? permission : this.newPermission(string);
    }

    public void load(String string, Object object) throws ClassNotFoundException, IOException, NotOwnerException {
        if (this.aclOwner != null && this.aclOwner != this.getAclOwner(object)) {
            throw new NotOwnerException();
        }
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        String string2 = (String)objectInputStream.readObject();
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        Hashtable hashtable2 = (Hashtable)objectInputStream.readObject();
        Hashtable hashtable3 = (Hashtable)objectInputStream.readObject();
        Hashtable hashtable4 = (Hashtable)objectInputStream.readObject();
        string = string2;
        this.users = hashtable;
        this.groups = hashtable2;
        this.permissions = hashtable3;
        this.acls = hashtable4;
    }

    public void save(String string) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
        objectOutputStream.writeObject(string);
        objectOutputStream.writeObject(this.users);
        objectOutputStream.writeObject(this.groups);
        objectOutputStream.writeObject(this.permissions);
        objectOutputStream.writeObject(this.acls);
        this.closeOS(objectOutputStream);
    }

    private void closeOS(OutputStream outputStream) throws IOException {
        outputStream.close();
    }

    public Enumeration getUsers() {
        return this.users.elements();
    }

    public Enumeration getGroups() {
        return this.groups.elements();
    }

    public Enumeration getAcls() {
        return this.acls.elements();
    }

    public Enumeration getPermissions() {
        return this.permissions.elements();
    }

    public User newUser(String string, Object object, Object object2) throws SecurityException {
        if (this.getUser(string) != null || this.getGroup(string) != null) {
            throw new SecurityException("Principal " + string + " already defined in realm " + this.getName());
        }
        DefaultUserImpl defaultUserImpl = new DefaultUserImpl(string, object, this);
        this.users.put(string, defaultUserImpl);
        return defaultUserImpl;
    }

    public Group newGroup(String string) throws SecurityException {
        if (this.getGroup(string) != null) {
            throw new SecurityException("Group " + string + " already defined in realm " + this.getName());
        }
        GroupImpl groupImpl = new GroupImpl(string);
        this.groups.put(string, groupImpl);
        return groupImpl;
    }

    public Acl newAcl(Principal principal, String string) throws SecurityException {
        if (this.aclOwner != principal) {
            throw new SecurityException(principal + " does not own the ACL");
        }
        AclImpl aclImpl = new AclImpl(principal, string);
        this.acls.put(string, aclImpl);
        return aclImpl;
    }

    public Permission newPermission(String string) throws SecurityException {
        PermissionImpl permissionImpl = new PermissionImpl(string);
        this.permissions.put(string, permissionImpl);
        return permissionImpl;
    }

    public void deleteUser(User user) throws SecurityException {
        this.users.remove(user.getName());
        this.deletePrincipal((Principal)user);
    }

    public void deleteGroup(Group group) throws SecurityException {
        this.groups.remove(group.getName());
        this.deletePrincipal((Principal)group);
    }

    public void deletePermission(Permission permission) throws SecurityException {
        this.permissions.remove(permission instanceof PermissionImpl ? ((PermissionImpl)permission).getName() : permission.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deletePrincipal(Principal principal) {
        Hashtable hashtable = this.acls;
        synchronized (hashtable) {
            Enumeration enumeration = ((Hashtable)this.acls.clone()).keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                Acl acl = this.getAcl(string);
                Acl acl2 = this.newAcl((Principal)((Object)this.aclOwner), acl.getName());
                Enumeration enumeration2 = acl.entries();
                while (enumeration2.hasMoreElements()) {
                    AclEntry aclEntry = (AclEntry)enumeration2.nextElement();
                    if (((Object)aclEntry.getPrincipal()).equals(principal)) continue;
                    try {
                        acl2.addEntry((Principal)((Object)this.aclOwner), aclEntry);
                    }
                    catch (NotOwnerException notOwnerException) {}
                }
            }
        }
    }

    public void deleteAcl(Principal principal, Acl acl) throws SecurityException {
        if (this.aclOwner != principal) {
            throw new SecurityException(principal + " does not own the ACL");
        }
        this.acls.remove(acl.getName());
    }

    public void setPermission(Acl acl, Principal principal, Permission permission, boolean bl) {
        try {
            AclEntryImpl aclEntryImpl = null;
            AclEntryImpl aclEntryImpl2 = null;
            Enumeration enumeration = acl.entries();
            while (enumeration.hasMoreElements()) {
                AclEntry aclEntry = (AclEntry)enumeration.nextElement();
                if (!((Object)aclEntry.getPrincipal()).equals(principal)) continue;
                acl.removeEntry((Principal)((Object)this.aclOwner), aclEntry);
                if (aclEntry.isNegative()) {
                    aclEntryImpl2 = aclEntry;
                    continue;
                }
                aclEntryImpl = aclEntry;
            }
            if (bl) {
                if (aclEntryImpl == null) {
                    aclEntryImpl = new AclEntryImpl(principal);
                }
                this.addRemove(acl, aclEntryImpl, aclEntryImpl2, permission);
            } else {
                if (aclEntryImpl2 == null) {
                    aclEntryImpl2 = new AclEntryImpl(principal);
                    aclEntryImpl2.setNegativePermissions();
                }
                this.addRemove(acl, aclEntryImpl2, aclEntryImpl, permission);
            }
        }
        catch (NotOwnerException notOwnerException) {
            SecurityLogger.logStackTrace((Throwable)notOwnerException);
            throw new InternalError("aclOwner not owner");
        }
    }

    private void addRemove(Acl acl, AclEntry aclEntry, AclEntry aclEntry2, Permission permission) throws NotOwnerException {
        aclEntry.addPermission(permission);
        acl.addEntry((Principal)((Object)this.aclOwner), aclEntry);
        if (aclEntry2 == null) {
            return;
        }
        aclEntry2.removePermission(permission);
        if (aclEntry2.permissions().hasMoreElements()) {
            acl.addEntry((Principal)((Object)this.aclOwner), aclEntry2);
        }
    }
}

