/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import weblogic.management.DomainDir;
import weblogic.management.configuration.FileRealmMBean;
import weblogic.management.configuration.SecurityMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.servlet.ConnectionSigner;
import weblogic.management.servlet.FileDistributionServlet;
import weblogic.security.MessageDigest;
import weblogic.security.MessageDigestUtils;
import weblogic.security.SecurityLogger;
import weblogic.security.WLMessageDigest;
import weblogic.security.acl.AclEntryImpl;
import weblogic.security.acl.AclImpl;
import weblogic.security.acl.BasicRealm;
import weblogic.security.acl.CachingRealm;
import weblogic.security.acl.CertAuthentication;
import weblogic.security.acl.CredentialChanger;
import weblogic.security.acl.DefaultUserImpl;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.DynamicUserAcl;
import weblogic.security.acl.Everyone;
import weblogic.security.acl.GroupImpl;
import weblogic.security.acl.ManageableRealm;
import weblogic.security.acl.PermissionImpl;
import weblogic.security.acl.Realm;
import weblogic.security.acl.RefreshableRealm;
import weblogic.security.acl.SSLUserInfo;
import weblogic.security.acl.Security;
import weblogic.security.acl.User;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.FileRealmException;
import weblogic.security.acl.internal.FileRealmFileWriter;
import weblogic.security.audit.Audit;
import weblogic.security.internal.FileUtils;
import weblogic.security.internal.FileUtilsException;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.shared.LoggerWrapper;
import weblogic.utils.Hex;
import weblogic.utils.StringUtils;

public final class FileRealm
implements ManageableRealm,
RefreshableRealm,
DynamicUserAcl {
    private static final long serialVersionUID = -1640246370085690200L;
    private static final String FILE = "fileRealm.properties";
    private static final char PRINCIPAL_SEPARATOR = ',';
    private static final char ACL_PERMISSION_SEPARATOR = '.';
    private static final String ACL_PREFIX = "acl.";
    private static final String GROUP_PREFIX = "group.";
    private static final String USER_PREFIX = "user.";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String name;
    private String password;
    private byte[] salt;
    private MessageDigest messageDigest;
    private DefaultUserImpl aclOwner;
    private static LoggerWrapper log = LoggerWrapper.getInstance("SecurityRealm");
    private Group everyone = new Everyone(this);
    private Hashtable users = new Hashtable();
    private Hashtable groups = new Hashtable();
    private Hashtable acls = new Hashtable();
    private Hashtable permissions = new Hashtable();
    private int maxUsers;
    private int maxGroups;
    private int maxACLs;
    private boolean addedSystemUser;
    private boolean addedGuest;

    public static void convertFromClearTextPasswords(String string, byte[] byArray, Properties properties, Properties properties2, Properties properties3) throws FileNotFoundException, IOException {
        String string2;
        String string3;
        String string4;
        MessageDigest messageDigest = WLMessageDigest.getInstance((String)"SHA");
        Properties properties4 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            FileRealm.checkPrincipalName(string4);
            string3 = (String)properties.get(string4);
            string3 = string3.trim();
            string2 = USER_PREFIX + string4;
            String string5 = FileRealm.hashPassword(messageDigest, byArray, string3);
            properties4.put(string2, string5);
        }
        enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            FileRealm.checkPrincipalName(string4);
            string3 = GROUP_PREFIX + string4;
            string2 = (String)properties2.get(string4);
            properties4.put(string3, string2);
        }
        enumeration = properties3.keys();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            string3 = ACL_PREFIX + string4;
            string2 = (String)properties3.get(string4);
            properties4.put(string3, string2);
        }
        FileRealm.writeFile(string, properties4);
    }

    private static String getRestOfKey(String string, String string2) {
        return string.startsWith(string2) ? string.substring(string2.length()) : null;
    }

    private static String getUserFromKey(String string) {
        return FileRealm.getRestOfKey(string, USER_PREFIX);
    }

    private static String getGroupFromKey(String string) {
        return FileRealm.getRestOfKey(string, GROUP_PREFIX);
    }

    private static String getPermDotAclFromKey(String string) {
        return FileRealm.getRestOfKey(string, ACL_PREFIX);
    }

    private static String[] splitCompletely(String string, char c) {
        String string2 = new Character(c).toString();
        return StringUtils.splitCompletely((String)string, (String)string2);
    }

    private static String getAclFromPermDotAcl(String string) {
        String[] stringArray = FileRealm.splitCompletely(string, '.');
        String string2 = stringArray[1];
        for (int i = 2; i < stringArray.length; ++i) {
            string2 = string2 + '.' + stringArray[i];
        }
        return string2;
    }

    private static String getPermFromPermDotAcl(String string) {
        String[] stringArray = FileRealm.splitCompletely(string, '.');
        return stringArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Syntax: FileRealm fileRealmPath saltPath");
            return;
        }
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            Properties properties = new Properties();
            Properties properties2 = new Properties();
            Properties properties3 = new Properties();
            String string3 = string + ".src";
            FileInputStream fileInputStream = new FileInputStream(string3);
            try {
                Properties properties4 = new Properties();
                properties4.load(fileInputStream);
                Enumeration<Object> enumeration = properties4.keys();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    String string5 = FileRealm.getUserFromKey(string4);
                    if (string5 != null) {
                        properties.put(string5, properties4.get(string4));
                        continue;
                    }
                    string5 = FileRealm.getGroupFromKey(string4);
                    if (string5 != null) {
                        properties2.put(string5, properties4.get(string4));
                        continue;
                    }
                    string5 = FileRealm.getPermDotAclFromKey(string4);
                    if (string5 == null) continue;
                    properties3.put(string5, properties4.get(string4));
                }
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            FileRealm.convertFromClearTextPasswords(string, SerializedSystemIni.getSalt(string2), properties, properties2, properties3);
        }
        catch (Exception exception) {
            System.out.println("Error : " + exception);
            exception.printStackTrace();
        }
    }

    public FileRealm() {
        this.messageDigest = WLMessageDigest.getInstance((String)"SHA");
    }

    public void init(String string, Object object) throws NotOwnerException {
        this.password = FileRealm.getPassword(object);
        if (this.aclOwner != null && this.aclOwner != this.getAclOwner(object)) {
            throw new NotOwnerException();
        }
        this.name = string;
        this.aclOwner = new FileRealmUserImpl("ACL Owner", this.password, this);
    }

    public String getName() {
        return this.name;
    }

    private void checkMaxUsers() {
        if (this.users.size() > this.maxUsers) {
            SecurityLogger.logMaxUserWarning((String)Integer.toString(this.maxUsers), (String)Integer.toString(this.users.size()));
        }
    }

    private void checkMaxGroups() {
        if (this.groups.size() > this.maxGroups) {
            SecurityLogger.logMaxGroupWarning((String)Integer.toString(this.maxGroups), (String)Integer.toString(this.groups.size()));
        }
    }

    private void checkMaxAcls() {
        if (this.acls.size() > this.maxACLs) {
            SecurityLogger.logMaxAclWarning((String)Integer.toString(this.maxACLs), (String)Integer.toString(this.acls.size()));
        }
    }

    public User getUser(String string) {
        return (User)this.users.get(string);
    }

    public User getUser(UserInfo userInfo) {
        return this.authInternal(userInfo);
    }

    private User authInternal(UserInfo userInfo) {
        User user = null;
        if (userInfo instanceof DefaultUserInfoImpl) {
            DefaultUserInfoImpl defaultUserInfoImpl = (DefaultUserInfoImpl)userInfo;
            String string = defaultUserInfoImpl.getName();
            if (defaultUserInfoImpl.hasCertificates()) {
                user = this.authCertificates(string, defaultUserInfoImpl.getCertificates());
            }
            if (user == null && defaultUserInfoImpl.hasPassword()) {
                user = this.authUserPassword(defaultUserInfoImpl);
            }
            if (user == null && defaultUserInfoImpl instanceof SSLUserInfo) {
                SSLUserInfo sSLUserInfo = (SSLUserInfo)defaultUserInfoImpl;
                user = this.authSSLCertificates(string, sSLUserInfo.getSSLCertificates());
            }
        } else {
            user = this.authUserPassword(userInfo);
        }
        return user;
    }

    private User authUserPassword(UserInfo userInfo) {
        User user = this.getUser(userInfo.getName());
        if (user != null) {
            if (!(user instanceof DefaultUserImpl) || !(userInfo instanceof DefaultUserInfoImpl)) {
                throw new FileRealmException("FileRealm only supports DefaultUserInfoImpls : " + userInfo.toString());
            }
            DefaultUserImpl defaultUserImpl = (DefaultUserImpl)user;
            DefaultUserInfoImpl defaultUserInfoImpl = (DefaultUserInfoImpl)userInfo;
            if (defaultUserInfoImpl.hasPassword()) {
                DefaultUserInfoImpl defaultUserInfoImpl2;
                defaultUserInfoImpl = defaultUserInfoImpl2 = new DefaultUserInfoImpl(defaultUserInfoImpl.getName(), this.hashPassword(defaultUserInfoImpl.getPassword()), defaultUserInfoImpl.getRealmName());
            }
            if (!defaultUserImpl.hasMatchingInfo(defaultUserInfoImpl)) {
                user = null;
            }
        }
        Audit.authenticateUser("Default Realm", userInfo, user);
        return user;
    }

    private User authCertificates(String string, Vector vector) {
        return CertAuthentication.authenticate(string, vector, false);
    }

    private User authSSLCertificates(String string, Vector vector) {
        return CertAuthentication.authenticate(string, vector, true);
    }

    public Principal getAclOwner(Object object) {
        return this.aclOwner.hasMatchingInfo(new DefaultUserInfoImpl("ACL Owner", object, this.name)) ? this.aclOwner : null;
    }

    public Group getGroup(String string) {
        return (Group)this.groups.get(string);
    }

    public Acl getAcl(String string) {
        return (Acl)this.acls.get(string);
    }

    public Acl getAcl(String string, char c) {
        Acl acl = this.getAcl(string);
        int n = string.lastIndexOf(c);
        while (acl == null && n >= 0) {
            string = string.substring(0, n);
            acl = this.getAcl(string);
            n = string.lastIndexOf(c, n - 1);
        }
        return acl;
    }

    public Permission getPermission(String string) {
        if (string == null) {
            return null;
        }
        Permission permission = (Permission)this.permissions.get(string);
        return permission != null ? permission : this.newPermission(string);
    }

    public Enumeration getUsers() {
        return this.users.elements();
    }

    public Enumeration getGroups() {
        return this.groups.elements();
    }

    public Enumeration getAcls() {
        return this.acls.elements();
    }

    public Enumeration getPermissions() {
        return this.permissions.elements();
    }

    public User newUser(String string, Object object, Object object2) throws SecurityException {
        User user = this._newUser(string, this.hashPassword(FileRealm.getPassword(object)), object2);
        this.checkMaxUsers();
        this.writeFile();
        return user;
    }

    private static void checkPrincipalName(String string) {
        if (string.indexOf(44) != -1) {
            throw new FileRealmException("Principal names in the FileRealm must not contain the , character: " + string);
        }
    }

    private static void checkPermissionName(String string) {
        if (string.indexOf(46) != -1) {
            throw new FileRealmException("Permission names in the FileRealm must not contain the . character: " + string);
        }
    }

    private User _newUser(String string, Object object, Object object2) throws SecurityException {
        FileRealm.checkPrincipalName(string);
        if (this.getUser(string) != null || this.getGroup(string) != null) {
            throw new SecurityException("Principal " + string + " already defined in realm " + this.getName());
        }
        FileRealmUserImpl fileRealmUserImpl = new FileRealmUserImpl(string, object, this);
        this.users.put(string, fileRealmUserImpl);
        return fileRealmUserImpl;
    }

    public Group newGroup(String string) throws SecurityException {
        Group group = this._newGroup(string);
        this.checkMaxGroups();
        this.writeFile();
        return group;
    }

    private Group _newGroup(String string) throws SecurityException {
        FileRealm.checkPrincipalName(string);
        if (this.getGroup(string) != null) {
            throw new SecurityException("Group " + string + " already defined in realm " + this.getName());
        }
        FileRealmGroupImpl fileRealmGroupImpl = new FileRealmGroupImpl(string);
        this.groups.put(string, fileRealmGroupImpl);
        return fileRealmGroupImpl;
    }

    public Acl newAcl(Principal principal, String string) throws SecurityException {
        Acl acl = this._newAcl(principal, string);
        this.checkMaxAcls();
        this.writeFile();
        return acl;
    }

    private Acl _newAcl(Principal principal, String string) throws SecurityException {
        if (this.getAcl(string) != null) {
            throw new SecurityException("Acl " + string + " already defined in realm " + this.getName());
        }
        if (this.aclOwner != principal) {
            throw new SecurityException(principal + " does not own the ACL");
        }
        FileRealmAclImpl fileRealmAclImpl = new FileRealmAclImpl(principal, string);
        this.acls.put(string, fileRealmAclImpl);
        return fileRealmAclImpl;
    }

    public Permission newPermission(String string) throws SecurityException {
        FileRealm.checkPermissionName(string);
        PermissionImpl permissionImpl = new PermissionImpl(string);
        this.permissions.put(string, permissionImpl);
        return permissionImpl;
    }

    public void deleteUser(User user) throws SecurityException {
        this._deleteUser(user);
        this.writeFile();
    }

    private void _deleteUser(User user) throws SecurityException {
        if (this.getUser(user.getName()) == null) {
            throw new SecurityException("User " + user.getName() + " doesn't exist in realm " + this.getName());
        }
        this.users.remove(user.getName());
        this.deletePrincipal((Principal)user);
    }

    public void deleteGroup(Group group) throws SecurityException {
        this._deleteGroup(group);
        this.writeFile();
    }

    public void _deleteGroup(Group group) throws SecurityException {
        if (this.getGroup(group.getName()) == null) {
            throw new SecurityException("Group " + group.getName() + " doesn't exist in realm " + this.getName());
        }
        this.groups.remove(group.getName());
        this.deletePrincipal((Principal)group);
    }

    public void deletePermission(Permission permission) throws SecurityException {
        this.permissions.remove(permission instanceof PermissionImpl ? ((PermissionImpl)permission).getName() : permission.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePrincipal(Principal principal) {
        Group group;
        Enumeration enumeration;
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            enumeration = this.getGroups();
            while (enumeration.hasMoreElements()) {
                group = (Group)enumeration.nextElement();
                if (group instanceof Everyone) continue;
                group.removeMember(principal);
            }
        }
        hashtable = this.acls;
        synchronized (hashtable) {
            enumeration = this.getAcls();
            block9: while (enumeration.hasMoreElements()) {
                group = (Acl)enumeration.nextElement();
                Enumeration enumeration2 = group.entries();
                while (enumeration2.hasMoreElements()) {
                    AclEntry aclEntry = (AclEntry)enumeration2.nextElement();
                    if (!((Object)aclEntry.getPrincipal()).equals(principal)) continue;
                    try {
                        group.removeEntry((Principal)((Object)this.aclOwner), aclEntry);
                    }
                    catch (NotOwnerException notOwnerException) {}
                    continue block9;
                }
            }
        }
    }

    public void deleteAcl(Principal principal, Acl acl) throws SecurityException {
        this._deleteAcl(principal, acl);
        this.writeFile();
    }

    public void _deleteAcl(Principal principal, Acl acl) throws SecurityException {
        if (this.aclOwner != principal) {
            throw new SecurityException(principal + " does not own the ACL");
        }
        this.acls.remove(acl.getName());
    }

    public void setPermission(Acl acl, Principal principal, Permission permission, boolean bl) {
        Security.checkPermission("FileRealm", "weblogic.admin.acl", this.getPermission("modify"), '.');
        try {
            AclEntryImpl aclEntryImpl = null;
            AclEntryImpl aclEntryImpl2 = null;
            Enumeration enumeration = acl.entries();
            while (enumeration.hasMoreElements()) {
                AclEntry aclEntry = (AclEntry)enumeration.nextElement();
                if (!((Object)aclEntry.getPrincipal()).equals(principal)) continue;
                acl.removeEntry((Principal)((Object)this.aclOwner), aclEntry);
                if (aclEntry.isNegative()) {
                    aclEntryImpl2 = aclEntry;
                    continue;
                }
                aclEntryImpl = aclEntry;
            }
            if (bl) {
                if (aclEntryImpl == null) {
                    aclEntryImpl = new AclEntryImpl(principal);
                }
                this.addRemove(acl, aclEntryImpl, aclEntryImpl2, permission);
            } else {
                if (aclEntryImpl2 == null) {
                    aclEntryImpl2 = new AclEntryImpl(principal);
                    aclEntryImpl2.setNegativePermissions();
                }
                this.addRemove(acl, aclEntryImpl2, aclEntryImpl, permission);
            }
        }
        catch (NotOwnerException notOwnerException) {
            SecurityLogger.logStackTrace((Throwable)notOwnerException);
            throw new InternalError("aclOwner not owner");
        }
    }

    private void addRemove(Acl acl, AclEntry aclEntry, AclEntry aclEntry2, Permission permission) throws NotOwnerException {
        aclEntry.addPermission(permission);
        acl.addEntry((Principal)((Object)this.aclOwner), aclEntry);
        if (aclEntry2 == null) {
            return;
        }
        aclEntry2.removePermission(permission);
        if (aclEntry2.permissions().hasMoreElements()) {
            acl.addEntry((Principal)((Object)this.aclOwner), aclEntry2);
        }
    }

    private void createObjectsFromProps(Properties properties) {
        Principal principal = this.getAclOwner(this.password);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Acl acl;
            String string;
            String string2 = (String)enumeration.nextElement();
            String string3 = FileRealm.getUserFromKey(string2);
            if (string3 != null) {
                string = (String)properties.get(string2);
                this._newUser(string3, string, null);
                continue;
            }
            string3 = FileRealm.getGroupFromKey(string2);
            if (string3 != null) {
                this._newGroup(string3);
                continue;
            }
            string3 = FileRealm.getPermDotAclFromKey(string2);
            if (string3 == null || (acl = this.getAcl(string = FileRealm.getAclFromPermDotAcl(string3))) != null) continue;
            this._newAcl((Principal)((Object)this.aclOwner), string);
        }
    }

    private void ensureRequiredObjectsExist() {
        CachingRealm cachingRealm = null;
        Object object = Security.getRealm();
        if (object instanceof CachingRealm) {
            cachingRealm = (CachingRealm)object;
        }
        if (this.getPrincipalFromAnyRealm("everyone") == null) {
            this.groups.put(this.everyone.getName(), this.everyone);
            if (cachingRealm != null) {
                cachingRealm.clearGroupCaches();
            }
        }
        if (this.getPrincipalFromAnyRealm((String)(object = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().getSystemUser())) == null) {
            SecurityLogger.logNonexistentSystemUserWarning((String)object);
            this._newUser((String)object, this.hashPassword((String)object), null);
            this.addedSystemUser = true;
        }
        if (this.getPrincipalFromAnyRealm("guest") == null) {
            String string = "guest";
            if (ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().isGuestDisabled()) {
                MessageDigestUtils.update((MessageDigest)this.messageDigest, (long)System.currentTimeMillis());
                string = new String(this.messageDigest.digest());
                this.messageDigest.reset();
                if (log.isDebugEnabled()) {
                    log.debug("disabling guest access");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Guest user does not exist, creating it.");
            }
            this._newUser("guest", this.hashPassword(string), null);
            this.addedGuest = true;
        }
        if ((this.addedSystemUser || this.addedGuest) && cachingRealm != null) {
            cachingRealm.clearUserCaches();
        }
    }

    private Principal getPrincipalFromAnyRealm(String string) {
        BasicRealm basicRealm = Realm.getRealm("weblogic");
        User user = basicRealm.getUser(string);
        if (user == null) {
            user = basicRealm.getGroup(string);
        }
        return user;
    }

    private Acl getAclFromAnyRealm(String string) {
        BasicRealm basicRealm = Realm.getRealm("weblogic");
        return basicRealm.getAcl(string);
    }

    private void loadGroupMembersFromProps(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = FileRealm.getGroupFromKey(string);
            if (string2 == null) continue;
            Group group = this.getGroup(string2);
            if (group == null) {
                SecurityLogger.logMissingGroupWarning((String)string2);
                continue;
            }
            String string3 = (String)properties.get(string);
            if (string3 == null) continue;
            String[] stringArray = FileRealm.splitCompletely(string3, ',');
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i].trim();
                Principal principal = this.getPrincipalFromAnyRealm(string4);
                if (principal == null) {
                    SecurityLogger.logNonexistentPrincipalGroupWarning((String)string4, (String)group.toString());
                    continue;
                }
                ((FileRealmGroupImpl)group)._addMember(principal, false);
            }
        }
    }

    private void loadAclGranteesFromProps(Properties properties) {
        Principal principal = this.getAclOwner(this.password);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = FileRealm.getPermDotAclFromKey(string);
            if (string2 == null) continue;
            String string3 = FileRealm.getPermFromPermDotAcl(string2);
            String string4 = FileRealm.getAclFromPermDotAcl(string2);
            Permission permission = this.getPermission(string3);
            if (permission == null) {
                SecurityLogger.logNonexistentPermissionWarning((String)string3);
                continue;
            }
            Acl acl = this.getAcl(string4);
            if (acl == null) {
                SecurityLogger.logNonexistentAclWarning((String)string4);
                continue;
            }
            String string5 = (String)properties.get(string);
            String[] stringArray = FileRealm.splitCompletely(string5, ',');
            for (int i = 0; i < stringArray.length; ++i) {
                this.addPermission(permission, acl, principal, stringArray[i], false);
            }
        }
    }

    public static String getPassword(Object object) {
        if (object == null) {
            return null;
        }
        return object instanceof DefaultUserInfoImpl ? ((DefaultUserInfoImpl)object).getPassword() : object.toString();
    }

    private void addPermission(Permission permission, Acl acl, Principal principal, String string, boolean bl) {
        Principal principal2 = this.getPrincipalFromAnyRealm(string);
        if (principal2 == null) {
            SecurityLogger.logNonexistentPrincipalAclWarning((String)string, (String)acl.getName());
            return;
        }
        FileRealmAclImpl fileRealmAclImpl = (FileRealmAclImpl)acl;
        try {
            Enumeration enumeration = acl.entries();
            while (enumeration.hasMoreElements()) {
                AclEntry aclEntry = (AclEntry)enumeration.nextElement();
                if (!((Object)aclEntry.getPrincipal()).equals(principal2)) continue;
                fileRealmAclImpl._removeEntry(principal, aclEntry, bl);
                aclEntry.addPermission(permission);
                fileRealmAclImpl._addEntry(principal, aclEntry, bl);
                return;
            }
            fileRealmAclImpl._addEntry(principal, new AclEntryImpl(principal2, permission), bl);
        }
        catch (NotOwnerException notOwnerException) {
            SecurityLogger.logStackTrace((Throwable)notOwnerException);
            throw new Error("Internal error!");
        }
    }

    private void addDefault(Acl acl, Principal principal, Permission permission) {
        try {
            acl.addEntry(principal, (AclEntry)new AclEntryImpl((Principal)this.everyone, permission));
        }
        catch (NotOwnerException notOwnerException) {
            SecurityLogger.logStackTrace((Throwable)notOwnerException);
            throw new Error("Internal error!");
        }
    }

    private Acl getNamedAcl(Principal principal, String string) {
        Acl acl = this.getAcl(string);
        if (acl != null) {
            return acl;
        }
        acl = this._newAcl(principal, string);
        this.checkMaxAcls();
        return acl;
    }

    private Principal getPrincipal(String string) {
        Group group = this.getGroup(string);
        if (group == null) {
            group = this.getUser(string);
        }
        return group;
    }

    public void load(String string, Object object) throws ClassNotFoundException, IOException, NotOwnerException {
        if (object == null || !FileRealm.getPassword(object).equals(this.password)) {
            throw new NotOwnerException();
        }
        SecurityMBean securityMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity();
        FileRealmMBean fileRealmMBean = securityMBean.getRealm().getFileRealm();
        this.maxUsers = fileRealmMBean.getMaxUsers();
        this.maxGroups = fileRealmMBean.getMaxGroups();
        this.maxACLs = fileRealmMBean.getMaxACLs();
        this.salt = securityMBean.getSalt();
        Properties properties = this.loadFromAdminServer();
        this.createObjectsFromProps(properties);
    }

    public void loadMembers() {
        this.ensureRequiredObjectsExist();
        Properties properties = this.loadFromAdminServer();
        this.loadGroupMembersFromProps(properties);
        this.loadAclGranteesFromProps(properties);
        this.checkMaxUsers();
        this.checkMaxGroups();
        this.checkMaxAcls();
    }

    public void addRuntimeACLs() {
        try {
            String[] stringArray = new String[]{"send", "receive", "browse"};
            this.addDefaultAcl("weblogic.jms", "everyone", stringArray);
            String[] stringArray2 = new String[]{"lookup", "list", "modify"};
            this.addDefaultAcl("weblogic.jndi", "everyone", stringArray2);
            String[] stringArray3 = new String[]{"admin", "modify", "shrink", "reset"};
            String[] stringArray4 = new String[]{"reserve"};
            String[] stringArray5 = new String[]{"Administrators", "Deployers"};
            this.addDefaultAcl("weblogic.jdbc", "everyone", stringArray4);
            this.addDefaultAcl("weblogic.jdbc", stringArray5, stringArray3);
        }
        catch (NotOwnerException notOwnerException) {
            throw new SecurityException("Default ACL - " + notOwnerException.toString());
        }
    }

    private void addDefaultAcl(String string, String string2, String[] stringArray) throws NotOwnerException {
        Acl acl = this.getAclFromAnyRealm(string);
        if (acl != null) {
            if (log.isDebugEnabled()) {
                log.debug("Default ACL - " + string + " already exists");
            }
            return;
        }
        Principal principal = this.getPrincipalFromAnyRealm(string2);
        if (principal == null) {
            throw new SecurityException("Default ACL - Principal " + string2 + " not found");
        }
        AclEntryImpl aclEntryImpl = new AclEntryImpl(principal);
        for (int i = 0; i < stringArray.length; ++i) {
            aclEntryImpl.addPermission(this.getPermission(stringArray[i]));
        }
        FileRealmAclImpl fileRealmAclImpl = new FileRealmAclImpl((Principal)((Object)this.aclOwner), string);
        fileRealmAclImpl._addEntry((Principal)((Object)this.aclOwner), aclEntryImpl, false);
        if (log.isDebugEnabled()) {
            log.debug("Default " + fileRealmAclImpl.toString());
        }
        this.acls.put(string, fileRealmAclImpl);
    }

    private void addDefaultAcl(String string, String[] stringArray, String[] stringArray2) throws NotOwnerException {
        if (stringArray != null && stringArray.length > 0) {
            String string2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                Principal principal = this.getPrincipalFromAnyRealm(string2);
                if (principal == null) continue;
                this.addDefaultAcl(string, string2, stringArray2);
                continue;
            }
        }
    }

    public void save(String string) throws IOException {
    }

    public synchronized void newUserAcl(String string, char c, Permission[] permissionArray) throws SecurityException {
        try {
            if (this.getAcl(string) != null) {
                return;
            }
            Acl acl = this.getAcl(string, c);
            Principal principal = this.getAclOwner(this.password);
            Acl acl2 = this.newAcl(principal, string);
            User user = Security.getCurrentUser();
            boolean bl = false;
            if (acl != null) {
                Enumeration enumeration = acl.entries();
                while (enumeration.hasMoreElements()) {
                    AclEntry aclEntry = (AclEntry)enumeration.nextElement();
                    if (((Object)aclEntry.getPrincipal()).equals(user) && !aclEntry.isNegative()) {
                        bl = true;
                        for (int i = 0; i < permissionArray.length; ++i) {
                            aclEntry.addPermission(permissionArray[i]);
                        }
                    }
                    acl2.addEntry(principal, aclEntry);
                }
            }
            if (!bl) {
                acl2.addEntry(principal, (AclEntry)new AclEntryImpl((Principal)user, permissionArray));
            }
        }
        catch (NotOwnerException notOwnerException) {
        }
        catch (Throwable throwable) {
            SecurityLogger.logStackTrace((Throwable)throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadFromAdminServer() {
        String string;
        Properties properties = new Properties();
        InputStream inputStream = this.getInputStream();
        try {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                throw new FileRealmException("Unable to load properties", iOException);
            }
            string = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new FileRealmException("Unable to close stream", iOException);
            }
        }
        try {}
        catch (IOException iOException) {
            throw new FileRealmException("Unable to close stream", iOException);
        }
        inputStream.close();
        Enumeration<Object> enumeration = properties.keys();
        while (true) {
            if (!enumeration.hasMoreElements()) {
                if (!log.isDebugEnabled()) return properties;
                log.debug("Completed load of properties");
                return properties;
            }
            String string2 = (String)enumeration.nextElement();
            string = (String)properties.get(string2);
            string = string.trim();
            properties.put(string2, string);
        }
    }

    private InputStream getInputStream() throws FileRealmException {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer() || !ManagementService.getRuntimeAccess(kernelId).isAdminServerAvailable()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("reading from " + FileRealm.getPath());
                }
                return new FileInputStream(new File(FileRealm.getPath()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileRealmException("Source file not found: " + FileRealm.getPath(), fileNotFoundException);
            }
        }
        URL uRL = null;
        Object var2_3 = null;
        try {
            uRL = FileDistributionServlet.getURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileRealmException("Unable to build properties url", malformedURLException);
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            ConnectionSigner.signConnection(uRLConnection, kernelId);
            httpURLConnection.setRequestProperty("wl_request_type", "wl_file_realm_request");
            httpURLConnection.setRequestProperty("Connection", "Close");
            return httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            throw new FileRealmException("Unable to open url: " + uRL.toString(), iOException);
        }
    }

    public static String getPath() {
        return DomainDir.getPathRelativeRootDir((String)FILE);
    }

    private static String saltPassword(byte[] byArray, String string) {
        int n;
        byte[] byArray2 = string.getBytes();
        int n2 = Math.max(byArray.length, byArray2.length);
        byte[] byArray3 = new byte[n2];
        for (n = 0; n < byArray2.length; ++n) {
            int n3 = n;
            byArray3[n3] = (byte)(byArray3[n3] + byArray2[n]);
        }
        for (n = 0; n < byArray.length; ++n) {
            int n4 = n;
            byArray3[n4] = (byte)(byArray3[n4] + byArray[n]);
        }
        return Hex.asHex((byte[])byArray3);
    }

    private static String hashPassword(MessageDigest messageDigest, byte[] byArray, String string) {
        MessageDigestUtils.updateASCII((MessageDigest)messageDigest, (String)FileRealm.saltPassword(byArray, string));
        byte[] byArray2 = messageDigest.digest();
        messageDigest.reset();
        return Hex.asHex((byte[])byArray2);
    }

    private synchronized String hashPassword(String string) {
        return FileRealm.hashPassword(this.messageDigest, this.salt, string);
    }

    private String getMemberName(Object object) {
        if (object instanceof User) {
            return ((User)object).getName();
        }
        if (object instanceof Group) {
            return ((Group)object).getName();
        }
        throw new FileRealmException("member not a User or Group : " + object.toString());
    }

    private void writeUsersToProps(Properties properties) {
        String string = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().getSystemUser();
        String string2 = "guest";
        Enumeration enumeration = this.getUsers();
        while (enumeration.hasMoreElements()) {
            User user = (User)enumeration.nextElement();
            if (this.addedSystemUser && user.getName().equals(string) || this.addedGuest && user.getName().equals(string2)) continue;
            DefaultUserImpl defaultUserImpl = (DefaultUserImpl)user;
            Object object = defaultUserImpl.getCredential(this.password);
            String string3 = (String)object;
            String string4 = USER_PREFIX + user.getName();
            String string5 = string3;
            properties.put(string4, string5);
        }
    }

    private void writeGroupsToProps(Properties properties) {
        Enumeration enumeration = this.getGroups();
        while (enumeration.hasMoreElements()) {
            Object object;
            Group group = (Group)enumeration.nextElement();
            if (group instanceof Everyone) continue;
            String string = "";
            Enumeration enumeration2 = group.members();
            boolean bl = true;
            while (enumeration2.hasMoreElements()) {
                if (!bl) {
                    string = string + ',';
                } else {
                    bl = false;
                }
                object = enumeration2.nextElement();
                string = string + this.getMemberName(object);
            }
            object = GROUP_PREFIX + group.getName();
            String string2 = string;
            properties.put(object, string2);
        }
    }

    private void writeAclsToProps(Properties properties) {
        Enumeration enumeration = this.getAcls();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            Object object3;
            String string;
            Object object4;
            AclEntry aclEntry;
            Acl acl = (Acl)enumeration.nextElement();
            Hashtable hashtable = new Hashtable();
            Enumeration enumeration2 = acl.entries();
            while (enumeration2.hasMoreElements()) {
                aclEntry = (AclEntry)enumeration2.nextElement();
                object4 = aclEntry.getPrincipal();
                string = this.getMemberName(aclEntry.getPrincipal());
                object3 = aclEntry.permissions();
                while (object3.hasMoreElements()) {
                    object2 = (PermissionImpl)object3.nextElement();
                    String string2 = ((PermissionImpl)object2).getName();
                    object = (Vector)hashtable.get(string2);
                    if (object == null) {
                        object = new Vector();
                        hashtable.put(string2, object);
                    }
                    ((Vector)object).add(string);
                }
            }
            aclEntry = hashtable.keys();
            while (aclEntry.hasMoreElements()) {
                object4 = (String)aclEntry.nextElement();
                string = "";
                object3 = (Vector)hashtable.get(object4);
                object2 = ((Vector)object3).elements();
                boolean bl = true;
                while (object2.hasMoreElements()) {
                    if (!bl) {
                        string = string + ',';
                    } else {
                        bl = false;
                    }
                    object = (String)object2.nextElement();
                    string = string + object;
                }
                object = ACL_PREFIX + (String)object4 + '.' + acl.getName();
                String string3 = string;
                properties.put(object, string3);
            }
        }
    }

    private static void writeFile(String string, Properties properties) {
        FileRealmFileWriter fileRealmFileWriter = new FileRealmFileWriter(properties);
        try {
            FileUtils.replace(string, fileRealmFileWriter);
        }
        catch (FileUtilsException fileUtilsException) {
            throw new FileRealmException("Error rewriting " + string, (Throwable)((Object)fileUtilsException));
        }
    }

    private synchronized void writeFile() {
        if (!ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            SecurityLogger.logInMemoryFileRealmChangeWarning();
            return;
        }
        Properties properties = new Properties();
        this.writeUsersToProps(properties);
        this.writeGroupsToProps(properties);
        this.writeAclsToProps(properties);
        FileRealm.writeFile(FileRealm.getPath(), properties);
    }

    public void refresh() {
        Hashtable hashtable = this.users;
        Hashtable hashtable2 = this.groups;
        Hashtable hashtable3 = this.acls;
        this.users = new Hashtable();
        this.groups = new Hashtable();
        this.acls = new Hashtable();
        try {
            Properties properties = this.loadFromAdminServer();
            this.createObjectsFromProps(properties);
            this.ensureRequiredObjectsExist();
            this.loadGroupMembersFromProps(properties);
            this.loadAclGranteesFromProps(properties);
            this.checkMaxUsers();
            this.checkMaxGroups();
            this.checkMaxAcls();
        }
        catch (Throwable throwable) {
            this.users = hashtable;
            this.groups = hashtable2;
            this.acls = hashtable3;
            throw new FileRealmException("FileRealm couldn't synchronize - using old values", throwable);
        }
    }

    private class FileRealmUserImpl
    extends DefaultUserImpl
    implements CredentialChanger {
        private static final long serialVersionUID = -5265009210019953032L;

        public FileRealmUserImpl(String string, Object object, BasicRealm basicRealm) {
            super(string, object, basicRealm);
        }

        public void changeCredential(Object object, Object object2) throws SecurityException {
            DefaultUserInfoImpl defaultUserInfoImpl = new DefaultUserInfoImpl(this.getName(), object, this.getRealm().getName());
            Realm.authenticate(defaultUserInfoImpl);
            this.setCredential(FileRealm.this.hashPassword(FileRealm.getPassword(object2)));
            FileRealm.this.writeFile();
        }
    }

    private class FileRealmGroupImpl
    extends GroupImpl {
        private static final long serialVersionUID = -3323170289877387624L;

        public FileRealmGroupImpl(String string) {
            super(string);
        }

        public boolean addMember(Principal principal) {
            return this._addMember(principal, true);
        }

        public boolean _addMember(Principal principal, boolean bl) {
            boolean bl2 = super.addMember(principal);
            if (bl2 && bl) {
                FileRealm.this.writeFile();
            }
            return bl2;
        }

        public boolean removeMember(Principal principal) {
            return this._removeMember(principal, true);
        }

        public boolean _removeMember(Principal principal, boolean bl) {
            boolean bl2 = super.removeMember(principal);
            if (bl2 && bl) {
                FileRealm.this.writeFile();
            }
            return bl2;
        }
    }

    private class FileRealmAclImpl
    extends AclImpl {
        private static final long serialVersionUID = -6543322023693167749L;

        public FileRealmAclImpl(Principal principal, String string) {
            super(principal, string);
        }

        public boolean addEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
            return this._addEntry(principal, aclEntry, true);
        }

        public boolean _addEntry(Principal principal, AclEntry aclEntry, boolean bl) throws NotOwnerException {
            boolean bl2 = super.addEntry(principal, aclEntry);
            if (bl2 && bl) {
                FileRealm.this.writeFile();
            }
            return bl2;
        }

        public boolean removeEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
            return this._removeEntry(principal, aclEntry, true);
        }

        public boolean _removeEntry(Principal principal, AclEntry aclEntry, boolean bl) throws NotOwnerException {
            boolean bl2 = super.removeEntry(principal, aclEntry);
            if (bl2 && bl) {
                FileRealm.this.writeFile();
            }
            return bl2;
        }
    }
}

