/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import weblogic.common.internal.BootServicesStub;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.common.internal.RMIBootServiceStub;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Protocol;
import weblogic.rjvm.LocalRJVM;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.SecurityService;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.security.service.SecurityServiceManager;

public final class RemoteAuthenticate {
    private static AuthenticatedSubject kernelID;
    private static boolean enableDefaultUserProperty;

    public static AuthenticatedUser authenticate(UserInfo userInfo, RJVM rJVM, Protocol protocol, String string, long l, boolean bl) throws RemoteException, SecurityException {
        Remote remote;
        rJVM = RJVMManager.getRJVMManager().findOrCreate(rJVM.getID());
        AuthenticatedUser authenticatedUser = null;
        if (RemoteAuthenticate.isRMIBootstrapPossible(rJVM)) {
            remote = RMIBootServiceStub.getStub(rJVM, string, l);
            try {
                AuthenticatedSubject authenticatedSubject = SubjectUtils.getAnonymousSubject();
                authenticatedUser = (AuthenticatedUser)SecurityManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction((SecurityService)remote, userInfo){
                    final /* synthetic */ SecurityService val$stub;
                    final /* synthetic */ UserInfo val$ui;
                    {
                        this.val$stub = securityService;
                        this.val$ui = userInfo;
                    }

                    public Object run() throws RemoteException {
                        return this.val$stub.authenticate(this.val$ui);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                RemoteException remoteException = (RemoteException)privilegedActionException.getException();
                if (remoteException.getCause() instanceof SecurityException) {
                    throw (SecurityException)remoteException.getCause();
                }
                throw remoteException;
            }
        } else {
            remote = new BootServicesStub(rJVM, protocol);
            authenticatedUser = ((BootServicesStub)remote).authenticate(userInfo);
        }
        if (!KernelStatus.isServer()) {
            Object object = remote = authenticatedUser == null ? null : SecurityServiceManager.getASFromAU((AuthenticatedUser)authenticatedUser);
            if (bl || enableDefaultUserProperty) {
                SecurityManager.setDefaultUser((AuthenticatedSubject)remote);
            }
        }
        return authenticatedUser;
    }

    private static boolean isRMIBootstrapPossible(RJVM rJVM) {
        if (rJVM instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)rJVM).getPeerInfo();
            if (LocalRJVM.getLocalRJVM().getPeerInfo().equals((Object)peerInfo)) {
                return true;
            }
            if (peerInfo == null) {
                return false;
            }
            int n = peerInfo.getMajor();
            int n2 = peerInfo.getMinor();
            int n3 = peerInfo.getServicePack();
            return n > 8 || n == 6 && n2 == 1 && n3 >= 5 || n == 7 && n2 == 0 && n3 >= 3 || n == 8 && n2 == 1 && n3 >= 1;
        }
        return false;
    }

    static {
        String string;
        kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        enableDefaultUserProperty = false;
        if (!KernelStatus.isServer() && !KernelStatus.isApplet() && (string = System.getProperty("weblogic.jndi.enableDefaultUser")) != null) {
            enableDefaultUserProperty = true;
        }
    }
}

