/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl.internal;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import weblogic.common.internal.BootServicesStub;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.common.internal.RMIBootServiceStub;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.kernel.Kernel;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.protocol.Protocol;
import weblogic.rjvm.LocalRJVM;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.Realm;
import weblogic.security.acl.SecurityService;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.acl.internal.ClusterRealm;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.security.service.SecurityServiceManager;

public final class Security {
    private static final AuditableThreadLocal threadSSLClientInfo;
    private static AuthenticatedSubject kernelID;
    private static boolean enableDefaultUserProperty;

    public static void init() {
    }

    public static AuthenticatedUser verify(AuthenticatedUser authenticatedUser) throws SecurityException {
        if (ClusterRealm.THE_ONE != null && ClusterRealm.THE_ONE.verify(authenticatedUser)) {
            return authenticatedUser;
        }
        return Security.authenticate((UserInfo)authenticatedUser);
    }

    private static AuthenticatedUser authenticateLocally(UserInfo userInfo) throws SecurityException {
        AuthenticatedSubject authenticatedSubject = null;
        PrincipalAuthenticator principalAuthenticator = SecurityServiceManager.getPrincipalAuthenticator((AuthenticatedSubject)kernelID, (String)"weblogicDEFAULT");
        try {
            if (userInfo instanceof DefaultUserInfoImpl) {
                DefaultUserInfoImpl defaultUserInfoImpl = (DefaultUserInfoImpl)userInfo;
                authenticatedSubject = principalAuthenticator.authenticate((CallbackHandler)new SimpleCallbackHandler(defaultUserInfoImpl.getName(), defaultUserInfoImpl.getPassword()), null);
            }
        }
        catch (LoginException loginException) {
            throw new SecurityException(loginException.getMessage());
        }
        return authenticatedSubject;
    }

    public static AuthenticatedUser authenticate(UserInfo userInfo, RJVM rJVM, Protocol protocol, String string) throws RemoteException, SecurityException {
        return Security.authenticate(userInfo, rJVM, protocol, string, 0L, false);
    }

    public static AuthenticatedUser authenticate(UserInfo userInfo, RJVM rJVM, Protocol protocol, String string, long l, boolean bl) throws RemoteException, SecurityException {
        Remote remote;
        if (rJVM.getID().isLocal()) {
            return Security.authenticateLocally(userInfo);
        }
        rJVM = RJVMManager.getRJVMManager().findOrCreate(rJVM.getID());
        AuthenticatedUser authenticatedUser = null;
        if (Security.isRMIBootstrapPossible(rJVM)) {
            remote = RMIBootServiceStub.getStub(rJVM, string, l);
            try {
                AuthenticatedSubject authenticatedSubject = SubjectUtils.getAnonymousSubject();
                authenticatedUser = (AuthenticatedUser)SecurityManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction((SecurityService)remote, userInfo){
                    final /* synthetic */ SecurityService val$stub;
                    final /* synthetic */ UserInfo val$ui;
                    {
                        this.val$stub = securityService;
                        this.val$ui = userInfo;
                    }

                    public Object run() throws RemoteException {
                        return this.val$stub.authenticate(this.val$ui);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                RemoteException remoteException = (RemoteException)privilegedActionException.getException();
                if (remoteException.getCause() instanceof SecurityException) {
                    throw (SecurityException)remoteException.getCause();
                }
                throw remoteException;
            }
        } else {
            remote = new BootServicesStub(rJVM, protocol);
            authenticatedUser = ((BootServicesStub)remote).authenticate(userInfo);
        }
        if (!Kernel.isServer()) {
            Object object = remote = authenticatedUser == null ? null : SecurityServiceManager.getASFromAU((AuthenticatedUser)authenticatedUser);
            if (bl || enableDefaultUserProperty) {
                SecurityManager.setDefaultUser((AuthenticatedSubject)remote);
            }
        }
        return authenticatedUser;
    }

    private static boolean isRMIBootstrapPossible(RJVM rJVM) {
        if (rJVM instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)rJVM).getPeerInfo();
            if (LocalRJVM.getLocalRJVM().getPeerInfo().equals((Object)peerInfo)) {
                return true;
            }
            if (peerInfo == null) {
                return false;
            }
            int n = peerInfo.getMajor();
            int n2 = peerInfo.getMinor();
            int n3 = peerInfo.getServicePack();
            return n > 8 || n == 6 && n2 == 1 && n3 >= 5 || n == 7 && n2 == 0 && n3 >= 3 || n == 8 && n2 == 1 && n3 >= 1;
        }
        return false;
    }

    public static AuthenticatedUser authenticate(UserInfo userInfo) throws SecurityException {
        String string = Realm.getAuthenticatedName(userInfo);
        return ClusterRealm.THE_ONE.certify(string);
    }

    public static SSLClientInfo getThreadSSLClientInfo() {
        Object object = threadSSLClientInfo.get();
        SSLClientInfo sSLClientInfo = null;
        if (object == null || !(object instanceof SSLClientInfo)) {
            sSLClientInfo = new SSLClientInfo();
            threadSSLClientInfo.set((Object)sSLClientInfo);
        } else {
            sSLClientInfo = (SSLClientInfo)object;
        }
        return sSLClientInfo;
    }

    public static void setThreadSSLClientInfo(SSLClientInfo sSLClientInfo) {
        threadSSLClientInfo.set((Object)sSLClientInfo);
    }

    public static final void setSSLRootCAFingerprints(String string) {
        Security.getThreadSSLClientInfo().setRootCAfingerprints(string);
    }

    public static final void setSSLRootCAFingerprints(byte[][] byArray) {
        Security.getThreadSSLClientInfo().setRootCAfingerprints(byArray);
    }

    public static final byte[][] getSSLRootCAFingerprints() {
        return Security.getThreadSSLClientInfo().getRootCAfingerprints();
    }

    public static final void setSSLServerName(String string) {
        Security.getThreadSSLClientInfo().setExpectedName(string);
    }

    public static final String getSSLServerName() {
        return Security.getThreadSSLClientInfo().getExpectedName();
    }

    public static final Object getSSLClientCertificate() throws IOException {
        return Security.getThreadSSLClientInfo().getSSLClientCertificate();
    }

    public static final void setSSLClientCertificate(InputStream[] inputStreamArray) {
        Security.getThreadSSLClientInfo().setSSLClientCertificate(inputStreamArray);
    }

    public static final void setSSLClientKeyPassword(String string) {
        Security.getThreadSSLClientInfo().setSSLClientKeyPassword(string);
    }

    public static final String getSSLClientKeyPassword() {
        return Security.getThreadSSLClientInfo().getSSLClientKeyPassword();
    }

    public static final void loadLocalIdentity(Certificate[] certificateArray, PrivateKey privateKey) {
        Security.getThreadSSLClientInfo().loadLocalIdentity(certificateArray, privateKey);
    }

    public static final boolean isClientCertAvailable() {
        return Security.getThreadSSLClientInfo().isClientCertAvailable();
    }

    static {
        String string;
        threadSSLClientInfo = AuditableThreadLocalFactory.createThreadLocal((ThreadLocalInitialValue)new ThreadLocalInitialValue(true));
        kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        enableDefaultUserProperty = false;
        if (!Kernel.isServer() && !Kernel.isApplet() && (string = System.getProperty("weblogic.jndi.enableDefaultUser")) != null) {
            enableDefaultUserProperty = true;
        }
    }
}

