/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl.internal;

import java.rmi.RemoteException;
import weblogic.iiop.Connection;
import weblogic.iiop.EndPoint;
import weblogic.iiop.IDLUtils;
import weblogic.iiop.IOR;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rmi.spi.InboundRequest;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.SecurityService;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;

public final class SecurityServiceImpl
implements SecurityService {
    public static IOR getIOR() {
        return SingletonMaker.ior;
    }

    public static SecurityServiceImpl getSingleton() {
        return SingletonMaker.SINGLETON;
    }

    private SecurityServiceImpl() {
    }

    public AuthenticatedUser authenticate(UserInfo userInfo) throws RemoteException {
        throw new AssertionError((Object)"authenticate()");
    }

    public AuthenticatedUser authenticate(UserInfo userInfo, InboundRequest inboundRequest) throws RemoteException {
        Connection connection = ((EndPoint)inboundRequest.getEndPoint()).getConnection();
        connection.authenticate(userInfo);
        AuthenticatedSubject authenticatedSubject = connection.getUser();
        if (ChannelHelper.isLocalAdminChannelEnabled() && SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject) && connection.getChannel().getProtocol().getQOS() != 103) {
            throw new SecurityException("All administrative tasks must go through an Administration Port.");
        }
        return authenticatedSubject;
    }

    private static final class SingletonMaker {
        private static final SecurityServiceImpl SINGLETON = new SecurityServiceImpl();
        private static final IOR ior = new IOR(IDLUtils.getTypeID(SecurityService.class), 14);

        private SingletonMaker() {
        }
    }
}

