/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.audit;

import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.Permission;
import weblogic.security.acl.Security;
import weblogic.security.acl.User;
import weblogic.security.acl.UserInfo;
import weblogic.security.audit.AuditProvider;
import weblogic.security.principal.RealmAdapterUser;

public final class Audit {
    private static Object sync = new Object();
    private static AuditProvider provider = null;

    private Audit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProvider(AuditProvider auditProvider) {
        if (auditProvider == null) {
            throw new NullPointerException("null provider");
        }
        Object object = sync;
        if (object == null) {
            throw new SecurityException("audit provider already set");
        }
        Object object2 = object;
        synchronized (object2) {
            if (sync == null) {
                throw new SecurityException("audit provider already set");
            }
            provider = auditProvider;
            sync = null;
        }
    }

    public static void authenticateUser(String string, UserInfo userInfo, User user) {
        if (provider != null) {
            provider.authenticateUser(string, userInfo, user);
        }
    }

    public static void checkPermission(String string, Acl acl, Principal principal, Permission permission, boolean bl) {
        if (provider != null) {
            User user = null;
            if (principal instanceof RealmAdapterUser) {
                user = Security.getRealm().getUser(principal.getName());
            }
            provider.checkPermission(string, acl, (Principal)(user != null ? user : principal), permission, bl);
        }
    }

    public static AuditProvider getProvider() {
        return provider;
    }
}

