/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.auth;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import weblogic.jndi.Environment;
import weblogic.jndi.internal.ThreadEnvironment;
import weblogic.kernel.Kernel;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.ServerURL;
import weblogic.rjvm.t3.ProtocolHandlerT3;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.acl.internal.Security;
import weblogic.security.auth.login.PasswordCredential;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.AssertionError;

public final class Authenticate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void authenticate(Environment environment, Subject subject) throws LoginException, IOException, RemoteException {
        Object object;
        String string = environment.getProviderUrl();
        RJVM rJVM = null;
        if (string == null || string.length() == 0 || string == "local://") {
            if (!Kernel.isServer()) return;
            rJVM = RJVMManager.getLocalRJVM();
            environment.setProperty("java.naming.provider.url", null);
        } else {
            ThreadEnvironment.push(environment);
            try {
                rJVM = new ServerURL(string).findOrCreateRJVM(environment.getProviderChannel());
            }
            finally {
                ThreadEnvironment.pop();
            }
        }
        UserInfo userInfo = environment.getSecurityUser();
        AuthenticatedUser authenticatedUser = null;
        boolean bl = rJVM.equals(RJVMManager.getLocalRJVM());
        if (userInfo == null && environment.isClientCertAvailable()) {
            userInfo = new DefaultUserInfoImpl(null, null);
        }
        if (userInfo == null) return;
        ThreadEnvironment.push(environment);
        try {
            authenticatedUser = Security.authenticate(userInfo, rJVM, Authenticate.getProtocol(environment), environment.getProviderChannel());
        }
        catch (SecurityException securityException) {
            String string2 = securityException.toString();
            int n = string2.indexOf("Start server side stack trace:");
            if (n <= 0) throw new LoginException(string2);
            string2 = string2.substring(0, n - 1);
            throw new LoginException(string2);
        }
        finally {
            ThreadEnvironment.pop();
        }
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getASFromAU((AuthenticatedUser)authenticatedUser);
        environment.setSecuritySubject(authenticatedSubject);
        try {
            if (Boolean.getBoolean("weblogic.security.authenticatePushSubject")) {
                object = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                SecurityServiceManager.pushSubject((AuthenticatedSubject)object, (AuthenticatedSubject)authenticatedSubject);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        subject.getPrincipals().addAll(authenticatedSubject.getPrincipals());
        if (!(userInfo instanceof DefaultUserInfoImpl)) return;
        object = (DefaultUserInfoImpl)userInfo;
        if (((DefaultUserInfoImpl)object).getName() != null && ((DefaultUserInfoImpl)object).getPassword() != null) {
            final PasswordCredential passwordCredential = new PasswordCredential(((DefaultUserInfoImpl)object).getName(), ((DefaultUserInfoImpl)object).getPassword());
            final Subject subject2 = subject;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    subject2.getPrivateCredentials().add(passwordCredential);
                    return null;
                }
            });
        }
        environment.setSecurityUser((UserInfo)authenticatedUser);
        if (Kernel.isServer() || authenticatedUser == null) return;
        rJVM.setUser(authenticatedUser);
    }

    private static Protocol getProtocol(Environment environment) {
        try {
            String string = environment.getProviderUrl();
            Protocol protocol = null;
            protocol = string == "local://" ? ProtocolHandlerT3.PROTOCOL_T3 : ProtocolManager.getProtocolByName((String)new ServerURL(string).getProtocol());
            return protocol;
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Throwable)malformedURLException);
        }
    }

    public static void logout(Subject subject) throws LoginException, IOException, RemoteException {
        Set<Object> set = subject.getPrincipals();
        set.clear();
        set = subject.getPrivateCredentials();
        set.clear();
        set = subject.getPublicCredentials();
        set.clear();
    }
}

