/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.auth.login;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import weblogic.jndi.Environment;
import weblogic.security.SecurityLogger;
import weblogic.security.auth.Authenticate;
import weblogic.security.auth.callback.URLCallback;
import weblogic.security.auth.login.PasswordCredential;
import weblogic.security.shared.LoggerWrapper;

public class UsernamePasswordLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler = null;
    private Map sharedState = null;
    private Map options = null;
    private static LoggerWrapper log = LoggerWrapper.getInstance("SecurityAtn");
    private String url = null;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username = null;
    private String password = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.subject = subject;
        if (map2 != null) {
            Object v = map2.get("debug");
            if (v != null && ((String)v).equalsIgnoreCase("true")) {
                this.log("UsernamePasswordLoginModule.initialize(), debug enabled");
            }
            if ((v = map2.get("URL")) != null) {
                this.url = (String)v;
                this.log("UsernamePasswordLoginModule.initialize(), URL " + this.url);
            }
        }
    }

    public boolean login() throws LoginException {
        Object object;
        if (this.callbackHandler == null) {
            this.log("UsernamePasswordLoginModule.login(), no callback handler specifed");
            throw new LoginException(SecurityLogger.getNoCallbackHandlerSpecified());
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("username: "), new PasswordCallback("password: ", false), new URLCallback("URL: ")};
        try {
            this.callbackHandler.handle(callbackArray);
            this.username = ((NameCallback)callbackArray[0]).getName();
            if (log.isDebugEnabled()) {
                if (this.username == null) {
                    this.log("UsernamePasswordLoginModule.login(), No username");
                } else {
                    this.log("UsernamePasswordLoginModule.login(), username " + this.username);
                }
            }
            if (this.username == null) {
                throw new LoginException(SecurityLogger.getNoUsernameSpecified());
            }
            object = ((PasswordCallback)callbackArray[1]).getPassword();
            if (object == null) {
                object = new char[]{};
            }
            this.password = new String((char[])object);
            String string = ((URLCallback)callbackArray[2]).getURL();
            if (string != null) {
                this.url = string;
            }
            if (log.isDebugEnabled()) {
                if (this.url == null) {
                    this.log("UsernamePasswordLoginModule.login(), No URL");
                } else {
                    this.log("UsernamePasswordLoginModule.login(), URL " + this.url);
                }
            }
            if (this.url == null) {
                this.url = "";
            }
        }
        catch (IOException iOException) {
            this.log("UsernamePasswordLoginModule CallbackHandler Error: " + iOException.getMessage());
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            this.log("UsernamePasswordLoginModule CallbackHandler Error: " + unsupportedCallbackException.getMessage());
            throw new LoginException(SecurityLogger.getErrorCallbackNotAvailable((String)unsupportedCallbackException.getCallback().toString()));
        }
        if (this.url != null) {
            object = new Environment();
            object.setProviderUrl(this.url);
            object.setSecurityPrincipal(this.username);
            object.setSecurityCredentials(this.password);
            try {
                Authenticate.authenticate((Environment)object, this.subject);
            }
            catch (RemoteException remoteException) {
                this.log("UsernamePasswordLoginModule Error: Remote Exception on authenticate, " + remoteException.getMessage());
                throw new LoginException(remoteException.toString());
            }
            catch (IOException iOException) {
                this.log("UsernamePasswordLoginModule Error: IO Exception on authenticate, " + iOException.getMessage());
                throw new LoginException(iOException.toString());
            }
            catch (LoginException loginException) {
                this.log("UsernamePasswordLoginModule Error: Login Exception on authenticate, " + loginException.getMessage());
                throw new LoginException(loginException.toString());
            }
        }
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.succeeded) {
            final PasswordCredential passwordCredential = new PasswordCredential(this.username, this.password);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    UsernamePasswordLoginModule.this.subject.getPrivateCredentials().add(passwordCredential);
                    return null;
                }
            });
            this.url = null;
            this.commitSucceeded = true;
            return true;
        }
        this.username = null;
        this.password = null;
        this.url = null;
        return false;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            this.password = null;
            this.url = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.succeeded = false;
        this.commitSucceeded = false;
        this.username = null;
        this.password = null;
        this.url = null;
        try {
            Authenticate.logout(this.subject);
        }
        catch (LoginException loginException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void log(String string) {
        if (log != null) {
            log.debug(string);
        } else {
            System.out.println(string);
        }
    }
}

