/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.Properties;
import weblogic.kernel.Kernel;
import weblogic.management.DomainDir;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.PropertyService;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.security.internal.encryption.EncryptionServiceException;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.FileUtils;

public final class BootProperties {
    private static final boolean DEBUG = false;
    private static final String USERNAME_PROP = "username";
    private static final String PASSWORD_PROP = "password";
    private static final String FILE = "boot.properties";
    private static String DEFAULT_FILE = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static BootProperties theInstance = null;
    private ClearOrEncryptedService encryptionService = null;
    private String filename = null;
    private boolean needServerSecDir = false;
    private boolean useClear = false;
    private String username = null;
    private String password = null;
    private String trustKeyStore = null;
    private String customTrustKeyStoreFileName = null;
    private String customTrustKeyStoreType = null;
    private String customTrustKeyStorePassPhrase = null;
    private String javaStandardTrustKeyStorePassPhrase = null;

    static void upgradeBP(String string) {
        String string2 = BootProperties.getServerName();
        File file = new File(DomainDir.getPathRelativeServersSecurityDir((String)string2, (String)FILE));
        if (file.exists()) {
            return;
        }
        File file2 = new File(DomainDir.getPathRelativeRootDir((String)FILE));
        if (!file2.exists()) {
            return;
        }
        try {
            File file3;
            if (null != string && (file3 = new File(string)).getCanonicalPath().equals(file2.getCanonicalPath())) {
                return;
            }
            if (theInstance != null) {
                theInstance.updateDomainLevelBP(new File(BootProperties.theInstance.filename));
                FileUtils.copy((File)file2, (File)file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateDomainLevelBP(File file) {
        File file2 = new File(DomainDir.getPathRelativeRootDir((String)FILE));
        if (!file2.exists() || !file.exists()) {
            return;
        }
        try {
            if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
                return;
            }
            FileUtils.copy((File)file, (File)file2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deleteDomainLevelBP() {
        File file = new File(DomainDir.getPathRelativeRootDir((String)FILE));
        if (file.exists()) {
            file.delete();
        }
    }

    public static String getServerName() {
        PropertyService propertyService = ManagementService.getPropertyService(kernelId);
        if (propertyService == null) {
            return null;
        }
        return ManagementService.getPropertyService(kernelId).getServerName();
    }

    public static boolean exists(String string) {
        String string2 = BootProperties.getFileName(string);
        File file = new File(string2);
        boolean bl = file.exists();
        return bl;
    }

    public static synchronized void load(String string, boolean bl) {
        if (theInstance != null) {
            return;
        }
        try {
            BootProperties bootProperties = new BootProperties(bl, string);
            if (bootProperties.read()) {
                theInstance = bootProperties;
            }
        }
        catch (Exception exception) {
            SecurityLogger.logBootPropertiesWarning((String)exception.toString());
        }
    }

    public static synchronized void save() {
        try {
            if (theInstance != null && theInstance.haveUnencryptedValues()) {
                theInstance.write();
            }
        }
        catch (Exception exception) {
            SecurityLogger.logBootPropertiesWarning((String)exception.toString());
        }
    }

    public static synchronized void output(SecurityConfigurationMBean securityConfigurationMBean, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        try {
            boolean bl = false;
            BootProperties bootProperties = theInstance;
            if (bootProperties == null) {
                bootProperties = new BootProperties(securityConfigurationMBean, string);
                if (!bootProperties.read()) {
                    bl = true;
                } else {
                    theInstance = bootProperties;
                }
            }
            if (BootProperties.valChanged(bootProperties.getOne(kernelId), string2)) {
                bootProperties.username = string2;
                bl = true;
            }
            if (BootProperties.valChanged(bootProperties.getTwo(kernelId), string3)) {
                bootProperties.password = string3;
                bl = true;
            }
            if (BootProperties.valChanged(bootProperties.getTrustKeyStore(), string4)) {
                bootProperties.trustKeyStore = string4;
                bl = true;
            }
            if (BootProperties.valChanged(bootProperties.getCustomTrustKeyStoreFileName(), string5)) {
                bootProperties.customTrustKeyStoreFileName = string5;
                bl = true;
            }
            if (BootProperties.valChanged(bootProperties.getCustomTrustKeyStoreType(), string6)) {
                bootProperties.customTrustKeyStoreType = string6;
                bl = true;
            }
            if (BootProperties.valChanged(bootProperties.getCustomTrustKeyStorePassPhrase(), string7)) {
                bootProperties.customTrustKeyStorePassPhrase = string7;
                bl = true;
            }
            if (BootProperties.valChanged(bootProperties.getJavaStandardTrustKeyStorePassPhrase(), string8)) {
                bootProperties.javaStandardTrustKeyStorePassPhrase = string8;
                bl = true;
            }
            if (bl || bootProperties.haveUnencryptedValues()) {
                bootProperties.write();
            }
        }
        catch (Exception exception) {
            SecurityLogger.logBootPropertiesWarning((String)exception.toString());
        }
    }

    public static synchronized BootProperties getBootProperties() {
        return theInstance;
    }

    public static synchronized void unload(boolean bl) {
        if (theInstance == null) {
            return;
        }
        try {
            if (bl) {
                theInstance.delete();
            }
        }
        catch (Exception exception) {
            SecurityLogger.logBootPropertiesWarning((String)exception.toString());
        }
        theInstance = null;
    }

    String getOne(AuthenticatedSubject authenticatedSubject) {
        SecurityServiceManager.checkKernelIdentity((AuthenticatedSubject)authenticatedSubject);
        return this.getEncryptedValue(USERNAME_PROP, this.username);
    }

    String getTwo(AuthenticatedSubject authenticatedSubject) {
        SecurityServiceManager.checkKernelIdentity((AuthenticatedSubject)authenticatedSubject);
        return this.getEncryptedValue(PASSWORD_PROP, this.password);
    }

    public String getOneClient() {
        if (!Kernel.isServer()) {
            return this.getOne(kernelId);
        }
        return null;
    }

    public String getTwoClient() {
        if (!Kernel.isServer()) {
            return this.getTwo(kernelId);
        }
        return null;
    }

    public String getTrustKeyStore() {
        return this.trustKeyStore;
    }

    public String getCustomTrustKeyStoreFileName() {
        return this.customTrustKeyStoreFileName;
    }

    public String getCustomTrustKeyStoreType() {
        return this.customTrustKeyStoreType;
    }

    public String getCustomTrustKeyStorePassPhrase() {
        return this.encryptValue(this.customTrustKeyStorePassPhrase);
    }

    public String getJavaStandardTrustKeyStorePassPhrase() {
        return this.encryptValue(this.javaStandardTrustKeyStorePassPhrase);
    }

    private BootProperties(boolean bl, String string) {
        this.useClear = bl;
        this.initialize(null, string);
    }

    private BootProperties(SecurityConfigurationMBean securityConfigurationMBean, String string) {
        this.initialize(securityConfigurationMBean, string);
    }

    private static boolean valChanged(String string, String string2) {
        if (!BootProperties.isSet(string) && !BootProperties.isSet(string2)) {
            return false;
        }
        if (!BootProperties.isSet(string) || !BootProperties.isSet(string2)) {
            return true;
        }
        return !string2.equals(string);
    }

    private static boolean isSet(String string) {
        return string != null && string.length() > 0;
    }

    private String getEncryptedValue(String string, String string2) {
        if (this.useClear && this.encryptionService == null) {
            return string2;
        }
        if (string2 == null) {
            return string2;
        }
        try {
            return this.encryptionService.decrypt(string2);
        }
        catch (EncryptionServiceException encryptionServiceException) {
            SecurityLogger.logBootPropertiesDecryptionFailure((String)this.filename, (String)string, (String)string2, (String)encryptionServiceException.toString());
            return "";
        }
        catch (Exception exception) {
            SecurityLogger.logBootPropertiesWarning((String)exception.toString());
            return "";
        }
    }

    private String encryptValue(String string) {
        return this.encryptionService == null || string == null ? string : this.encryptionService.encrypt(string);
    }

    private void initialize(SecurityConfigurationMBean securityConfigurationMBean, String string) {
        this.filename = BootProperties.getFileName(string);
        boolean bl = this.needServerSecDir = string == null && BootProperties.getServerName() != null;
        if (this.useClear) {
            return;
        }
        EncryptionService encryptionService = null;
        encryptionService = securityConfigurationMBean == null ? SerializedSystemIni.getEncryptionService(DomainDir.getRootDir()) : SerializedSystemIni.getEncryptionService(securityConfigurationMBean.getSalt(), securityConfigurationMBean.getEncryptedSecretKey(), securityConfigurationMBean.getEncryptedAESSecretKey());
        this.encryptionService = new ClearOrEncryptedService(encryptionService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read() throws IOException {
        File file = new File(this.filename);
        if (!file.exists()) {
            return false;
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            properties.load(fileInputStream);
            this.username = properties.getProperty(USERNAME_PROP);
            this.password = properties.getProperty(PASSWORD_PROP);
            this.trustKeyStore = properties.getProperty("TrustKeyStore");
            this.customTrustKeyStoreFileName = properties.getProperty("CustomTrustKeyStoreFileName");
            this.customTrustKeyStoreType = properties.getProperty("CustomTrustKeyStoreType");
            this.customTrustKeyStorePassPhrase = properties.getProperty("CustomTrustKeyStorePassPhrase");
            this.javaStandardTrustKeyStorePassPhrase = properties.getProperty("JavaStandardTrustKeyStorePassPhrase");
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        if (this.username == null || this.password == null) {
            return false;
        }
        if (this.useClear || !this.encryptionService.isEncrypted(this.username)) {
            this.username = this.username.trim();
            if (this.username.length() == 0) {
                return false;
            }
        }
        return !this.useClear && this.encryptionService.isEncrypted(this.password) || this.password.length() != 0;
    }

    private boolean haveUnencryptedValues() {
        if (!this.encryptionService.isEncrypted(this.username)) {
            return true;
        }
        if (!this.encryptionService.isEncrypted(this.password)) {
            return true;
        }
        if (BootProperties.isSet(this.customTrustKeyStorePassPhrase) && !this.encryptionService.isEncrypted(this.customTrustKeyStorePassPhrase)) {
            return true;
        }
        return BootProperties.isSet(this.javaStandardTrustKeyStorePassPhrase) && !this.encryptionService.isEncrypted(this.javaStandardTrustKeyStorePassPhrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() throws IOException {
        if (this.useClear) {
            return;
        }
        File file = new File(this.filename);
        try {
            SecurityLogger.logStoringBootIdentity((String)file.getCanonicalPath());
        }
        catch (IOException iOException) {
            SecurityLogger.logStoringBootIdentity((String)file.getAbsolutePath());
        }
        this.ensureServerSecDirExists();
        Properties properties = new Properties();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            properties.setProperty(USERNAME_PROP, this.encryptionService.encrypt(this.username));
            properties.setProperty(PASSWORD_PROP, this.encryptionService.encrypt(this.password));
            if (BootProperties.isSet(this.trustKeyStore)) {
                properties.setProperty("TrustKeyStore", this.trustKeyStore);
            }
            if (BootProperties.isSet(this.customTrustKeyStoreFileName)) {
                properties.setProperty("CustomTrustKeyStoreFileName", this.customTrustKeyStoreFileName);
            }
            if (BootProperties.isSet(this.customTrustKeyStoreType)) {
                properties.setProperty("CustomTrustKeyStoreType", this.customTrustKeyStoreType);
            }
            if (BootProperties.isSet(this.customTrustKeyStorePassPhrase)) {
                properties.setProperty("CustomTrustKeyStorePassPhrase", this.encryptionService.encrypt(this.customTrustKeyStorePassPhrase));
            }
            if (BootProperties.isSet(this.javaStandardTrustKeyStorePassPhrase)) {
                properties.setProperty("JavaStandardTrustKeyStorePassPhrase", this.encryptionService.encrypt(this.javaStandardTrustKeyStorePassPhrase));
            }
            properties.store(fileOutputStream, null);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
        this.updateDomainLevelBP(file);
    }

    private void delete() throws IOException {
        this.deleteDomainLevelBP();
        File file = new File(this.filename);
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            throw new IOException(SecurityLogger.getUnableToDelete((String)this.filename));
        }
    }

    private static String getFileName(String string) {
        if (string != null) {
            return string;
        }
        if (DEFAULT_FILE == null) {
            String string2 = BootProperties.getServerName();
            DEFAULT_FILE = string2 != null ? DomainDir.getPathRelativeServersSecurityDir((String)string2, (String)FILE) : FILE;
        }
        return DEFAULT_FILE;
    }

    private void ensureServerSecDirExists() {
        File file;
        if (!this.needServerSecDir || BootProperties.getServerName() == null || (file = new File(DomainDir.getSecurityDirForServer((String)BootProperties.getServerName()))).exists() || file.mkdir()) {
            // empty if block
        }
    }

    private static void debug(String string) {
    }
}

