/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.io.File;
import java.security.AccessController;
import weblogic.management.DomainDir;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.ProviderUtils;

public class BootStrap {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    private static String getAbsolutePath(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static boolean isMigrationMode() {
        return ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().isCompatibilityMode();
    }

    public static String getLocalFileAbsolutePath(String string) {
        return BootStrap.getAbsolutePath(DomainDir.getPathRelativeRootDir((String)string));
    }

    public static String getGlobalFileAbsolutePath(String string) {
        return BootStrap.getAbsolutePath(weblogic.management.bootstrap.BootStrap.getPathRelativeWebLogicHome((String)"lib") + File.separator + string);
    }

    public static String getBootStrapFileAbsolutePath(String string, String string2) {
        String string3 = string + "BootStrap" + string2;
        String string4 = BootStrap.getLocalFileAbsolutePath(string3);
        if (string4 != null) {
            return string4;
        }
        String string5 = string + ProviderUtils.getModeString((boolean)BootStrap.isMigrationMode()) + string2;
        return BootStrap.getGlobalFileAbsolutePath(string5);
    }
}

