/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import weblogic.security.SecurityLogger;
import weblogic.utils.enumerations.SequencingEnumerator;

public class CombiningPermissionCollection
extends PermissionCollection {
    private PermissionCollection pc1;
    private PermissionCollection pc2;
    private boolean treatFirstReadOnly;
    private boolean treatSecondReadOnly;
    private static final boolean DEBUG = false;

    public CombiningPermissionCollection(PermissionCollection permissionCollection, boolean bl, PermissionCollection permissionCollection2, boolean bl2) {
        this.pc1 = permissionCollection;
        this.pc2 = permissionCollection2;
        this.treatFirstReadOnly = bl;
        this.treatSecondReadOnly = bl2;
    }

    public Enumeration elements() {
        SequencingEnumerator sequencingEnumerator = new SequencingEnumerator();
        sequencingEnumerator.addEnumeration(this.pc1.elements());
        sequencingEnumerator.addEnumeration(this.pc2.elements());
        return sequencingEnumerator;
    }

    public boolean isReadOnly() {
        return !(!this.pc1.isReadOnly() && !this.treatFirstReadOnly || !this.pc2.isReadOnly() && !this.treatSecondReadOnly);
    }

    public void setReadOnly() {
        this.pc1.setReadOnly();
        this.pc2.setReadOnly();
    }

    public String toString() {
        return this.pc1.toString() + " PLUS " + this.pc2.toString();
    }

    public boolean implies(Permission permission) {
        return this.pc1.implies(permission) || this.pc2.implies(permission);
    }

    public void add(Permission permission) {
        if (!this.pc1.isReadOnly() && !this.treatFirstReadOnly) {
            this.pc1.add(permission);
        } else if (!this.pc2.isReadOnly() && !this.treatSecondReadOnly) {
            this.pc2.add(permission);
        } else {
            throw new SecurityException(SecurityLogger.getCantUpdateReadonlyPermColl());
        }
    }
}

