/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import weblogic.security.SecurityLogger;
import weblogic.security.internal.FileUtilsException;
import weblogic.security.internal.FileWriter;

public final class FileUtils {
    private static final boolean DEBUG = false;

    private static void debug(String string) {
    }

    private static void error(String string, Throwable throwable) throws FileUtilsException {
        throw new FileUtilsException(string, throwable);
    }

    private static void error(String string) throws FileUtilsException {
        throw new FileUtilsException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File file, FileWriter fileWriter) throws FileUtilsException {
        String string = null;
        try {
            boolean bl = false;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                fileWriter.write(fileOutputStream);
                bl = true;
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!bl) {
                    file.delete();
                }
                throw throwable;
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl) {
                file.delete();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileUtils.error(SecurityLogger.getErrorCreatingFile((String)file.getAbsolutePath()), fileNotFoundException);
        }
        catch (IOException iOException) {
            FileUtils.error(SecurityLogger.getErrorWritingRealmContents((String)file.getAbsolutePath()), iOException);
        }
    }

    public static void replace(String string, FileWriter fileWriter) throws FileUtilsException {
        String string2 = null;
        File file = new File(string);
        String string3 = file.getName();
        File file2 = file.getAbsoluteFile().getParentFile();
        File file3 = null;
        try {
            file3 = File.createTempFile(string3, ".new", file2);
        }
        catch (IOException iOException) {
            FileUtils.error(SecurityLogger.getCouldNotCreateTempFileNew((String)string3, (String)file2.getAbsolutePath()), iOException);
        }
        FileUtils.writeFile(file3, fileWriter);
        File file4 = null;
        if (file.exists()) {
            try {
                file4 = File.createTempFile(string3, ".old", file2);
            }
            catch (IOException iOException) {
                FileUtils.error(SecurityLogger.getCouldNotCreateTempFileOld((String)string3, (String)file2.getAbsolutePath()), iOException);
            }
            if (!file4.delete()) {
                FileUtils.error(SecurityLogger.getCouldNotClearTempFile((String)file4.getAbsolutePath()));
            }
        }
        if (file4 != null && !file.renameTo(file4)) {
            FileUtils.error(SecurityLogger.getCouldNotRenameTempFile((String)file.getAbsolutePath(), (String)file4.getAbsolutePath()));
        }
        if (!file3.renameTo(file)) {
            FileUtils.error(SecurityLogger.getCouldNotRenameTempFile((String)file3.getAbsolutePath(), (String)file.getAbsolutePath()));
        }
        if (file4 != null && !file4.delete()) {
            FileUtils.error(SecurityLogger.getCouldNotDeleteTempFile((String)("Couldn't delete " + file4.getAbsolutePath())));
        }
    }
}

