/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import weblogic.security.SecurityLogger;
import weblogic.security.service.SecurityServiceException;

public class MakePermission {
    public static Permission makePermission(String string, String string2, String string3) throws SecurityServiceException {
        try {
            Object[] objectArray;
            Class[] classArray;
            Class<?> clazz = Class.forName(string, false, Thread.currentThread().getContextClassLoader());
            if (string3 != null) {
                classArray = new Class[]{String.class, String.class};
                objectArray = new Object[]{string2, string3};
            } else if (string2 != null) {
                classArray = new Class[]{String.class};
                objectArray = new Object[]{string2};
            } else {
                classArray = new Class[]{};
                objectArray = new Object[]{};
            }
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return (Permission)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SecurityServiceException(SecurityLogger.getCantFindPermission((String)string), (Throwable)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SecurityServiceException(SecurityLogger.getNoAppropriateConstructor((String)string), (Throwable)noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new SecurityServiceException(SecurityLogger.getCantInstantiateClass((String)string), (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SecurityServiceException(SecurityLogger.getNoPermissionToInstantiate((String)string), (Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SecurityServiceException(SecurityLogger.getIncorrectArgForConstructor((String)string), (Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SecurityServiceException(SecurityLogger.getExcInConstructor((String)string), (Throwable)invocationTargetException);
        }
    }
}

