/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import weblogic.security.SecurityLogger;
import weblogic.security.internal.MakePermission;
import weblogic.security.service.InvalidParameterException;
import weblogic.security.service.SecurityServiceException;

public class ParsePolicies {
    private static final String PERMISSION_SYNTAX = "(permission[\\s|\\S]+?)\\s*;";
    private static final String OR = "|\\s*";
    private static final String LINE_END = "\\s*;";
    private static final String GRANT_BEGIN = "^\\s*grant\\s*\\{\\s*(\\s*";
    private static final String PERMISSION_ONLY = "permission\\s+(\\S+)";
    private static final String PERMISSION_AND_TARGET = "permission\\s+(\\S+)\\s+\"([\\S&&[^,\"]]+)\"";
    private static final String PERMISSION_AND_TARGET_AND_ACTIONS = "permission\\s+(\\S+)\\s+\"([\\S||[ ]]+)\"\\s*,\\s*\"([\\S|\\s]+)\"";
    private static final String GRANT_END = "\\s*)*\\s*}\\s*;\\s*$";
    private static final String GRANT_SYNTAX = "^\\s*grant\\s*\\{\\s*(\\s*permission\\s+(\\S+)\\s*;|\\s*permission\\s+(\\S+)\\s+\"([\\S&&[^,\"]]+)\"\\s*;|\\s*permission\\s+(\\S+)\\s+\"([\\S||[ ]]+)\"\\s*,\\s*\"([\\S|\\s]+)\"\\s*;\\s*)*\\s*}\\s*;\\s*$";

    public static PermissionCollection parseGrantStatement(String string) {
        Permissions permissions = new Permissions();
        if (!Pattern.matches(GRANT_SYNTAX, string)) {
            throw new InvalidParameterException(SecurityLogger.getInvalidGrantSyntax((String)string));
        }
        Matcher matcher = Pattern.compile(PERMISSION_SYNTAX).matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            Permission permission = null;
            try {
                permission = ParsePolicies.parsePermission(string2);
            }
            catch (SecurityServiceException securityServiceException) {
                throw new InvalidParameterException((Throwable)securityServiceException);
            }
            if (permission == null) continue;
            ((PermissionCollection)permissions).add(permission);
        }
        return permissions;
    }

    private static Permission parsePermission(String string) throws SecurityServiceException {
        Matcher matcher = null;
        String string2 = null;
        Permission permission = null;
        if (Pattern.matches(PERMISSION_ONLY, string)) {
            string2 = PERMISSION_ONLY;
        } else if (Pattern.matches(PERMISSION_AND_TARGET, string)) {
            string2 = PERMISSION_AND_TARGET;
        } else if (Pattern.matches(PERMISSION_AND_TARGET_AND_ACTIONS, string)) {
            string2 = PERMISSION_AND_TARGET_AND_ACTIONS;
        }
        if (string2 == null) {
            throw new InvalidParameterException(SecurityLogger.getInvalidPermissionSyntax((String)string));
        }
        matcher = Pattern.compile(string2).matcher(string);
        if (matcher.find()) {
            int n = matcher.groupCount();
            String string3 = null;
            String string4 = null;
            String string5 = null;
            switch (n) {
                case 3: {
                    string3 = matcher.group(3);
                }
                case 2: {
                    string4 = matcher.group(2);
                }
                case 1: {
                    string5 = matcher.group(1);
                    break;
                }
            }
            permission = MakePermission.makePermission(string5, string4, string3);
        }
        return permission;
    }
}

