/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.util.HashSet;
import weblogic.management.security.ProviderMBean;
import weblogic.management.security.RealmMBean;
import weblogic.management.security.authentication.AuthenticationProviderMBean;
import weblogic.management.security.authentication.AuthenticatorMBean;
import weblogic.management.security.authentication.IdentityAsserterMBean;
import weblogic.management.security.authorization.AuthorizerMBean;
import weblogic.management.security.authorization.DeployableAuthorizerMBean;
import weblogic.management.security.authorization.DeployableRoleMapperMBean;
import weblogic.management.security.authorization.PolicyConsumerMBean;
import weblogic.management.security.authorization.RoleMapperMBean;
import weblogic.management.security.credentials.CredentialMapperMBean;
import weblogic.management.security.pk.CertPathBuilderMBean;
import weblogic.management.security.pk.CertPathProviderMBean;
import weblogic.management.security.pk.CertPathValidatorMBean;
import weblogic.management.utils.ErrorCollectionException;
import weblogic.security.SecurityLogger;
import weblogic.t3.srvr.T3Srvr;

public class RealmValidatorImpl {
    static final String REALM_ADAPTER_ADJUDICATOR = "weblogic.security.providers.realmadapter.AdjudicationProviderImpl";
    static final String REALM_ADAPTER_AUTHORIZER = "weblogic.security.providers.realmadapter.AuthorizationProviderImpl";
    static final String REALM_ADAPTER_AUTHENTICATOR = "weblogic.security.providers.realmadapter.AuthenticationProviderImpl";
    static final String DEFAULT_AUTHORIZER = "weblogic.security.providers.authorization.DefaultAuthorizationProviderImpl";
    static final String DEFAULT_KEYSTORE = "weblogic.security.providers.pk.DefaultKeyStoreProviderImpl";
    static final String SAML_V1_IA = "weblogic.security.providers.saml.SAMLIdentityAsserterProviderImpl";
    static final String SAML_V2_IA = "weblogic.security.providers.saml.SAMLIdentityAsserterV2ProviderImpl";
    static final String SAML_V1_CREDMAP = "weblogic.security.providers.saml.SAMLCredentialMapperProviderImpl";
    static final String SAML_V2_CREDMAP = "weblogic.security.providers.saml.SAMLCredentialMapperV2ProviderImpl";
    private static boolean isBooting = true;

    public void validate(RealmMBean realmMBean) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException(SecurityLogger.getInvalidRealmWarning((String)realmMBean.getName()));
        this.checkAuthenticationProviders(realmMBean, errorCollectionException);
        this.checkRoleMappers(realmMBean, errorCollectionException);
        int n = this.checkAuthorizers(realmMBean, errorCollectionException);
        this.checkAdjudicator(realmMBean, errorCollectionException, n);
        this.checkCredentialMappers(realmMBean, errorCollectionException);
        this.checkCompatibilityMode(realmMBean, errorCollectionException);
        this.checkKeyStoreProviders(realmMBean, errorCollectionException);
        this.checkCertPathProviders(realmMBean, errorCollectionException);
        this.checkSAMLProviders(realmMBean, errorCollectionException);
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkAuthenticationProviders(RealmMBean realmMBean, ErrorCollectionException errorCollectionException) {
        AuthenticationProviderMBean[] authenticationProviderMBeanArray = realmMBean.getAuthenticationProviders();
        this.checkHaveAuthenticator(realmMBean, authenticationProviderMBeanArray, errorCollectionException);
        this.checkActiveTypesUnique(realmMBean, authenticationProviderMBeanArray, errorCollectionException);
    }

    private void checkHaveAuthenticator(RealmMBean realmMBean, AuthenticationProviderMBean[] authenticationProviderMBeanArray, ErrorCollectionException errorCollectionException) {
        boolean bl = false;
        for (int i = 0; !bl && authenticationProviderMBeanArray != null && i < authenticationProviderMBeanArray.length; ++i) {
            if (!(authenticationProviderMBeanArray[i] instanceof AuthenticatorMBean)) continue;
            bl = true;
        }
        if (!bl) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoAuthenticatorWarning((String)realmMBean.getName()));
        }
    }

    private void checkActiveTypesUnique(RealmMBean realmMBean, AuthenticationProviderMBean[] authenticationProviderMBeanArray, ErrorCollectionException errorCollectionException) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; authenticationProviderMBeanArray != null && i < authenticationProviderMBeanArray.length; ++i) {
            if (!(authenticationProviderMBeanArray[i] instanceof IdentityAsserterMBean)) continue;
            IdentityAsserterMBean identityAsserterMBean = (IdentityAsserterMBean)authenticationProviderMBeanArray[i];
            String[] stringArray = identityAsserterMBean.getActiveTypes();
            for (int j = 0; stringArray != null && j < stringArray.length; ++j) {
                String string = stringArray[j];
                if (string == null || string.length() <= 0) continue;
                if (hashSet.contains(string)) {
                    this.addError(errorCollectionException, SecurityLogger.getInvalidRealmMultipleIdentityAssertersForActiveTokenTypeWarning((String)realmMBean.getName(), (String)string));
                    continue;
                }
                hashSet.add(string);
            }
        }
    }

    private void checkRoleMappers(RealmMBean realmMBean, ErrorCollectionException errorCollectionException) {
        RoleMapperMBean[] roleMapperMBeanArray = realmMBean.getRoleMappers();
        if (roleMapperMBeanArray == null || roleMapperMBeanArray.length == 0) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoRoleMapperWarning((String)realmMBean.getName()));
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; !bl2 && i < roleMapperMBeanArray.length; ++i) {
            if (!(roleMapperMBeanArray[i] instanceof DeployableRoleMapperMBean)) continue;
            bl = true;
            DeployableRoleMapperMBean deployableRoleMapperMBean = (DeployableRoleMapperMBean)roleMapperMBeanArray[i];
            if (!deployableRoleMapperMBean.isRoleDeploymentEnabled()) continue;
            bl2 = true;
        }
        if (!bl) {
            if (!RealmValidatorImpl.isBooting()) {
                this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoDeployableRoleMapperWarning((String)realmMBean.getName()));
            } else {
                SecurityLogger.logNoDeployableProviderProperlyConfigured((String)realmMBean.getName(), (String)"DeployableRoleMapper");
            }
        } else if (!bl2) {
            if (!RealmValidatorImpl.isBooting()) {
                this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoDeployableRoleMapperEnabledWarning((String)realmMBean.getName()));
            } else {
                SecurityLogger.logNoDeployableProviderProperlyConfigured((String)realmMBean.getName(), (String)"DeployableRoleMapper");
            }
        }
    }

    private int checkAuthorizers(RealmMBean realmMBean, ErrorCollectionException errorCollectionException) {
        int n;
        AuthorizerMBean[] authorizerMBeanArray = realmMBean.getAuthorizers();
        if (authorizerMBeanArray == null || authorizerMBeanArray.length == 0) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoAuthorizerWarning((String)realmMBean.getName()));
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; !bl2 && n < authorizerMBeanArray.length; ++n) {
            if (!(authorizerMBeanArray[n] instanceof DeployableAuthorizerMBean)) continue;
            bl = true;
            DeployableAuthorizerMBean deployableAuthorizerMBean = (DeployableAuthorizerMBean)authorizerMBeanArray[n];
            if (!deployableAuthorizerMBean.isPolicyDeploymentEnabled()) continue;
            bl2 = true;
        }
        if (!bl) {
            if (!RealmValidatorImpl.isBooting()) {
                this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoDeployableAuthorizerWarning((String)realmMBean.getName()));
            } else {
                SecurityLogger.logNoDeployableProviderProperlyConfigured((String)realmMBean.getName(), (String)"DeployableAuthorizer");
            }
        } else if (!bl2) {
            if (!RealmValidatorImpl.isBooting()) {
                this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoDeployableAuthorizerEnabledWarning((String)realmMBean.getName()));
            } else {
                SecurityLogger.logNoDeployableProviderProperlyConfigured((String)realmMBean.getName(), (String)"DeployableAuthorizer");
            }
        }
        if (realmMBean.isDelegateMBeanAuthorization()) {
            n = 0;
            for (int i = 0; n == 0 && i < authorizerMBeanArray.length; ++i) {
                if (!(authorizerMBeanArray[i] instanceof PolicyConsumerMBean)) continue;
                n = 1;
            }
            if (n == 0) {
                this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoMBeanDelegationWarning((String)realmMBean.getName()));
            }
        }
        return authorizerMBeanArray.length;
    }

    private void checkCredentialMappers(RealmMBean realmMBean, ErrorCollectionException errorCollectionException) {
        CredentialMapperMBean[] credentialMapperMBeanArray = realmMBean.getCredentialMappers();
        if (credentialMapperMBeanArray == null || credentialMapperMBeanArray.length == 0) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoCredentialMapperWarning((String)realmMBean.getName()));
            return;
        }
    }

    private void checkAdjudicator(RealmMBean realmMBean, ErrorCollectionException errorCollectionException, int n) {
        if (realmMBean.getAdjudicator() == null && n > 1) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoAdjudicatorWarning((String)realmMBean.getName()));
        }
    }

    private boolean providerIsA(ProviderMBean providerMBean, String string) {
        if (providerMBean == null) {
            return false;
        }
        return string.equals(providerMBean.getProviderClassName());
    }

    private int providerCount(ProviderMBean[] providerMBeanArray, String string) {
        int n = 0;
        for (int i = 0; providerMBeanArray != null && i < providerMBeanArray.length; ++i) {
            if (!this.providerIsA(providerMBeanArray[i], string)) continue;
            ++n;
        }
        return n;
    }

    private void checkCompatibilityMode(RealmMBean realmMBean, ErrorCollectionException errorCollectionException) {
        ProviderMBean[] providerMBeanArray = realmMBean.getAuthorizers();
        int n = this.providerCount(providerMBeanArray, REALM_ADAPTER_AUTHORIZER);
        int n2 = this.providerCount(providerMBeanArray, DEFAULT_AUTHORIZER);
        int n3 = this.providerCount(realmMBean.getAuthenticationProviders(), REALM_ADAPTER_AUTHENTICATOR);
        if (this.providerIsA(realmMBean.getAdjudicator(), REALM_ADAPTER_ADJUDICATOR)) {
            if (n == 0) {
                this.addError(errorCollectionException, SecurityLogger.getInvalidRealmRealmAdapterNoRealmAdapterAuthorizerWarning((String)realmMBean.getName()));
            }
            if (n2 == 0) {
                this.addError(errorCollectionException, SecurityLogger.getInvalidRealmRealmAdapterNoDefaultAuthorizerWarning((String)realmMBean.getName()));
            }
            if (n2 > 1) {
                this.addError(errorCollectionException, SecurityLogger.getInvalidRealmRealmAdapterMultipleDefaultAuthorizersWarning((String)realmMBean.getName()));
            }
            if (providerMBeanArray.length > n + n2) {
                this.addError(errorCollectionException, SecurityLogger.getInvalidRealmRealmAdapterUnsupportedAuthorizerWarning((String)realmMBean.getName()));
            }
        }
        if (n > 1) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmRealmAdapterMultipleRealmAdapterAuthorizersWarning((String)realmMBean.getName()));
        }
        if (n3 > 1) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmRealmAdapterMultipleRealmAdapterAuthenticatorsWarning((String)realmMBean.getName()));
        }
        if (n > 0 && n3 == 0) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmRealmAdapterNoRealmAdapterAuthenticatorWarning((String)realmMBean.getName()));
        }
    }

    private void checkKeyStoreProviders(RealmMBean realmMBean, ErrorCollectionException errorCollectionException) {
        if (System.getProperty("weblogic.security.AllowAllKeyStoreProviders") != null) {
            return;
        }
        ProviderMBean[] providerMBeanArray = realmMBean.getKeyStores();
        if (providerMBeanArray != null && providerMBeanArray.length != this.providerCount(providerMBeanArray, DEFAULT_KEYSTORE)) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmInvalidKeyStoreProviderWarning((String)realmMBean.getName()));
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; providerMBeanArray != null && i < providerMBeanArray.length; ++i) {
            ProviderMBean providerMBean = providerMBeanArray[i];
            String string = providerMBean.getRootCAKeyStoreLocation();
            if (string != null && string.length() > 0) {
                ++n;
            }
            if ((string = providerMBean.getPrivateKeyStoreLocation()) == null || string.length() <= 0) continue;
            ++n2;
        }
        if (n > 1) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmMultipleTrustedCAKeyStoresWarning((String)realmMBean.getName()));
        }
        if (n2 > 1) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmMultiplePrivateKeyStoresWarning((String)realmMBean.getName()));
        }
    }

    private void checkCertPathProviders(RealmMBean realmMBean, ErrorCollectionException errorCollectionException) {
        CertPathBuilderMBean certPathBuilderMBean;
        CertPathProviderMBean[] certPathProviderMBeanArray = realmMBean.getCertPathProviders();
        if (certPathProviderMBeanArray == null || certPathProviderMBeanArray.length < 1) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoCertPathProvidersWarning((String)realmMBean.getName()));
        }
        if ((certPathBuilderMBean = realmMBean.getCertPathBuilder()) == null) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoCertPathBuilderWarning((String)realmMBean.getName()));
            return;
        }
        if (certPathBuilderMBean.getRealm() == null || !certPathBuilderMBean.getRealm().getName().equals(realmMBean.getName())) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmIllegalCertPathBuilderWarning((String)realmMBean.getName()));
        }
        boolean bl = false;
        for (int i = 0; !bl && certPathProviderMBeanArray != null && i < certPathProviderMBeanArray.length; ++i) {
            if (!(certPathProviderMBeanArray[i] instanceof CertPathValidatorMBean)) continue;
            bl = true;
        }
        if (!bl) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmNoCertPathValidatorWarning((String)realmMBean.getName()));
        }
    }

    private void checkSAMLProviders(RealmMBean realmMBean, ErrorCollectionException errorCollectionException) {
        ProviderMBean[] providerMBeanArray = realmMBean.getAuthenticationProviders();
        int n = this.providerCount(providerMBeanArray, SAML_V1_IA);
        int n2 = this.providerCount(providerMBeanArray, SAML_V2_IA);
        ProviderMBean[] providerMBeanArray2 = realmMBean.getCredentialMappers();
        int n3 = this.providerCount(providerMBeanArray2, SAML_V1_CREDMAP);
        int n4 = this.providerCount(providerMBeanArray2, SAML_V2_CREDMAP);
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            return;
        }
        if (n > 1 || n2 > 1 || n3 > 1 || n4 > 1) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmSAMLConfigWarning((String)realmMBean.getName()));
            return;
        }
        if (n > 0 && n2 > 0 || n3 > 0 && n4 > 0 || n > 0 && n4 > 0 || n2 > 0 && n3 > 0) {
            this.addError(errorCollectionException, SecurityLogger.getInvalidRealmSAMLConfigWarning((String)realmMBean.getName()));
            return;
        }
    }

    private void addError(ErrorCollectionException errorCollectionException, String string) {
        errorCollectionException.add(new Exception(string));
    }

    private static synchronized boolean isBooting() {
        if (isBooting) {
            if (T3Srvr.getT3Srvr().getRunState() == 2) {
                isBooting = false;
                return false;
            }
            return true;
        }
        return false;
    }
}

