/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.security.AccessController;
import java.util.Arrays;
import weblogic.descriptor.DescriptorUpdateEvent;
import weblogic.descriptor.DescriptorUpdateListener;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.security.RealmMBean;
import weblogic.management.utils.ErrorCollectionException;
import weblogic.nodemanager.server.NMEncryptionHelper;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;

public final class SecurityConfigurationValidator
extends AbstractServerService
implements DescriptorUpdateListener {
    private static SecurityConfigurationValidator singleton = null;
    private static final boolean DEBUG = false;
    private String currentNMUser;
    private byte[] currentNMPass;
    private String proposedNMUser;
    private byte[] proposedNMPass;

    private SecurityConfigurationValidator() {
    }

    public static synchronized SecurityConfigurationValidator getInstance() {
        if (singleton == null) {
            singleton = new SecurityConfigurationValidator();
        }
        return singleton;
    }

    private static void p(String string) {
    }

    public synchronized void start() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        ManagementService.getRuntimeAccess(authenticatedSubject).getDomain().getDescriptor().addUpdateListener((DescriptorUpdateListener)this);
    }

    public void prepareUpdate(DescriptorUpdateEvent descriptorUpdateEvent) throws DescriptorUpdateRejectedException {
        DomainMBean domainMBean = (DomainMBean)descriptorUpdateEvent.getProposedDescriptor().getRootBean();
        RealmMBean realmMBean = domainMBean.getSecurityConfiguration().getDefaultRealm();
        if (realmMBean == null) {
            throw new DescriptorUpdateRejectedException(SecurityLogger.getCannotActivateChangesNoDefaultRealmError());
        }
        try {
            realmMBean.validate();
        }
        catch (ErrorCollectionException errorCollectionException) {
            throw new DescriptorUpdateRejectedException(SecurityLogger.getCannotActivateChangesImproperlyConfiguredDefaultRealmError(), (Throwable)errorCollectionException);
        }
        DomainMBean domainMBean2 = (DomainMBean)descriptorUpdateEvent.getProposedDescriptor().getRootBean();
        this.proposedNMUser = domainMBean2.getSecurityConfiguration().getNodeManagerUsername();
        this.proposedNMPass = domainMBean2.getSecurityConfiguration().getNodeManagerPassword().getBytes();
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        DomainMBean domainMBean3 = ManagementService.getRuntimeAccess(authenticatedSubject).getDomain();
        this.currentNMUser = domainMBean3.getSecurityConfiguration().getNodeManagerUsername();
        this.currentNMPass = domainMBean3.getSecurityConfiguration().getNodeManagerPassword().getBytes();
        if (this.currentNMUser == null) {
            this.currentNMUser = "";
        }
        if (this.currentNMPass == null) {
            this.currentNMPass = "".getBytes();
        }
    }

    public void activateUpdate(DescriptorUpdateEvent descriptorUpdateEvent) {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        if (this.proposedNMUser != null || this.proposedNMPass != null) {
            if (this.proposedNMUser == null) {
                this.proposedNMUser = this.currentNMUser;
            }
            if (this.proposedNMPass == null) {
                this.proposedNMPass = this.currentNMPass;
            }
            if (this.proposedNMUser.equals(this.currentNMUser) && Arrays.equals(this.proposedNMPass, this.currentNMPass)) {
                return;
            }
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServer();
            String string = new String(this.proposedNMPass);
            NMEncryptionHelper.updateNMHash(serverMBean.getRootDirectory(), this.proposedNMUser, this.proposedNMPass);
        }
        this.currentNMUser = null;
        this.proposedNMUser = null;
        this.currentNMPass = null;
        this.proposedNMPass = null;
    }

    public void rollbackUpdate(DescriptorUpdateEvent descriptorUpdateEvent) {
        this.currentNMUser = null;
        this.proposedNMUser = null;
        this.currentNMPass = null;
        this.proposedNMPass = null;
    }
}

