/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import javax.management.InvalidAttributeValueException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.FileRealmMBean;
import weblogic.management.configuration.PasswordPolicyMBean;
import weblogic.management.configuration.RealmMBean;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.configuration.SecurityMBean;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.UpdateException;
import weblogic.security.Salt;
import weblogic.utils.Hex;

public class SecurityPersistentCompletionProcessor
implements ConfigurationProcessor {
    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        this.completeDomainCredential(domainMBean);
        this.complete6xRealms(domainMBean);
    }

    private void completeDomainCredential(DomainMBean domainMBean) throws UpdateException {
        SecurityConfigurationMBean securityConfigurationMBean = domainMBean.getSecurityConfiguration();
        if (securityConfigurationMBean.getCredential() == null) {
            int n = 32;
            String string = Hex.asHex((byte[])Salt.getRandomBytes(n));
            try {
                securityConfigurationMBean.setCredential(string);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new UpdateException(invalidAttributeValueException);
            }
        }
    }

    private void complete6xRealms(DomainMBean domainMBean) throws UpdateException {
        ConfigurationMBean configurationMBean;
        Object object;
        Object object2;
        SecurityMBean securityMBean = domainMBean.getSecurity();
        if (securityMBean.getRealm() == null) {
            object2 = "wl_default_realm";
            object = domainMBean.lookupRealm((String)object2);
            if (object == null) {
                object = domainMBean.createRealm((String)object2);
            }
            try {
                securityMBean.setRealm((RealmMBean)object);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new UpdateException(invalidAttributeValueException);
            }
        }
        if ((object2 = securityMBean.getRealm()).getFileRealm() == null) {
            object = "wl_default_file_realm";
            configurationMBean = domainMBean.lookupFileRealm((String)object);
            if (configurationMBean == null) {
                configurationMBean = domainMBean.createFileRealm((String)object);
            }
            try {
                object2.setFileRealm((FileRealmMBean)configurationMBean);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new UpdateException(invalidAttributeValueException);
            }
        }
        if (securityMBean.getPasswordPolicy() == null) {
            object = "wl_default_password_policy";
            configurationMBean = domainMBean.lookupPasswordPolicy((String)object);
            if (configurationMBean == null) {
                configurationMBean = domainMBean.createPasswordPolicy((String)object);
            }
            try {
                securityMBean.setPasswordPolicy((PasswordPolicyMBean)configurationMBean);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new UpdateException(invalidAttributeValueException);
            }
        }
    }
}

