/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.StringTokenizer;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.security.SecurityMessagesTextFormatter;

public class SecurityPre90UpgradeXSLTUtils {
    private static SecurityPre90UpgradeXSLTUtils This;
    private static final String SEPARATOR = "|";
    ArrayList realmInfo = new ArrayList();
    ArrayList childInfo = new ArrayList();
    private SecurityMessagesTextFormatter formatter = SecurityMessagesTextFormatter.getInstance();

    private static String trim(String string) {
        return string != null ? string.trim() : null;
    }

    private void validateObjectName(HashSet hashSet, String string) {
        if (string.length() < 1) {
            throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeMissingObjectNameProblem(), this.formatter.getSecurityPre90UpgradeNameSolution()));
        }
        if (!hashSet.add(string)) {
            throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeDuplicateObjectNameProblem(string), this.formatter.getSecurityPre90UpgradeNameSolution()));
        }
    }

    private void validateObjectNames() {
        HashSet hashSet = new HashSet();
        ListIterator listIterator = this.realmInfo.listIterator();
        while (listIterator.hasNext()) {
            this.validateObjectName(hashSet, ((RealmInfo)listIterator.next()).objectName);
        }
        listIterator = this.childInfo.listIterator();
        while (listIterator.hasNext()) {
            this.validateObjectName(hashSet, ((ChildInfo)listIterator.next()).objectName);
        }
    }

    private ChildInfo lookupChildInfo(String string, String string2) {
        ListIterator listIterator = this.childInfo.listIterator();
        while (listIterator.hasNext()) {
            ChildInfo childInfo = (ChildInfo)listIterator.next();
            if (!childInfo.objectName.equals(string2)) continue;
            return childInfo;
        }
        throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeMissingRealmChildProblem(string, string2), this.formatter.getSecurityPre90UpgradeNameSolution()));
    }

    private void validateChildRefersToRealm(String string, ChildInfo childInfo) {
        if (!string.equals(childInfo.realmObjectName)) {
            if (childInfo.realmObjectName.length() >= 1) {
                throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeRealmChildRefersToAnotherRealmProblem(string, childInfo.objectName, childInfo.realmObjectName), this.formatter.getSecurityPre90UpgradeNameSolution()));
            }
            throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeRealmChildRefersToNoRealmProblem(string, childInfo.objectName), this.formatter.getSecurityPre90UpgradeNameSolution()));
        }
    }

    private void validateRealmChildObjectName(String string, ChildInfo childInfo) {
        String string2 = string + childInfo.displayName;
        if (!string2.equals(childInfo.objectName)) {
            throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeNonStandardRealmChildObjectNameProblem(childInfo.objectName, string2, childInfo.displayName, childInfo.realmObjectName), this.formatter.getSecurityPre90UpgradeNameSolution()));
        }
    }

    private void validateRealmChild(String string, String string2, String string3) {
        if (string3.length() < 1) {
            return;
        }
        ChildInfo childInfo = this.lookupChildInfo(string, string3);
        this.validateChildRefersToRealm(string, childInfo);
        this.validateRealmChildObjectName(string, childInfo);
    }

    private void validateRealmChildren(String string, String string2, String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            ChildInfo childInfo = this.lookupChildInfo(string, string3);
            if (!hashSet.add(childInfo.objectName)) {
                throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeDuplicateRealmChildReferencesProblem(string, string2, childInfo.objectName), this.formatter.getSecurityPre90UpgradeNameSolution()));
            }
            if (!hashSet2.add(childInfo.displayName)) {
                throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeDuplicateRealmChildDisplayNameProblem(string, string2, childInfo.displayName), this.formatter.getSecurityPre90UpgradeNameSolution()));
            }
            this.validateChildRefersToRealm(string, childInfo);
            this.validateRealmChildObjectName(string, childInfo);
        }
    }

    private void validateCertPathBuilderAmongCertPathProviders(RealmInfo realmInfo) {
        if (realmInfo.certPathBuilder.length() < 1) {
            return;
        }
        String[] stringArray = realmInfo.certPathProviders;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals(realmInfo.certPathBuilder)) continue;
            return;
        }
        throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeRealmCertPathBuilderNotChildProblem(realmInfo.certPathBuilder, realmInfo.objectName), this.formatter.getSecurityPre90UpgradeRealmCertPathBuilderNotChildSolution()));
    }

    private void validateRealms() {
        String string = null;
        HashSet<String> hashSet = new HashSet<String>();
        ListIterator listIterator = this.realmInfo.listIterator();
        while (listIterator.hasNext()) {
            RealmInfo realmInfo = (RealmInfo)listIterator.next();
            if (realmInfo.isDefault) {
                if (string == null) {
                    string = realmInfo.objectName;
                } else {
                    throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeMultipleDefaultRealmsProblem(string, realmInfo.objectName), this.formatter.getSecurityPre90UpgradeMultipleDefaultRealmsSolution()));
                }
            }
            if (!hashSet.add(realmInfo.displayName)) {
                throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeDuplicateRealmDisplayNameProblem(realmInfo.objectName), this.formatter.getSecurityPre90UpgradeNameSolution()));
            }
            String string2 = "Security:Name=" + realmInfo.displayName;
            if (!string2.equals(realmInfo.objectName)) {
                throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeNonStandardRealmObjectNameProblem(realmInfo.objectName, string2, realmInfo.displayName), this.formatter.getSecurityPre90UpgradeNameSolution()));
            }
            this.validateRealmChildren(realmInfo.objectName, "Auditor", realmInfo.auditors);
            this.validateRealmChildren(realmInfo.objectName, "AuthenticationProvider", realmInfo.authenticationProviders);
            this.validateRealmChildren(realmInfo.objectName, "RoleMapper", realmInfo.roleMappers);
            this.validateRealmChildren(realmInfo.objectName, "Authorizer", realmInfo.authorizers);
            this.validateRealmChildren(realmInfo.objectName, "CredentialMapper", realmInfo.credentialMappers);
            this.validateRealmChildren(realmInfo.objectName, "CertPathProvider", realmInfo.certPathProviders);
            this.validateRealmChildren(realmInfo.objectName, "KeyStore", realmInfo.keyStores);
            this.validateRealmChild(realmInfo.objectName, "Adjudicator", realmInfo.adjudicator);
            this.validateRealmChild(realmInfo.objectName, "UserLockoutManager", realmInfo.userLockoutManager);
            this.validateCertPathBuilderAmongCertPathProviders(realmInfo);
            if (realmInfo.userLockoutManager.length() < 1) {
                throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeMissingUserLockoutManagerProblem(realmInfo.objectName), this.formatter.getSecurityPre90UpgradeMissingUserLockoutManagerSolution()));
            }
            if (!realmInfo.isUseDeprecatedWebResource) continue;
            throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeUseDeprecatedWebResourceProblem(realmInfo.objectName), this.formatter.getSecurityPre90UpgradeUseDeprecatedWebResourceSolution()));
        }
    }

    private void addRealmChildren(HashSet hashSet, String[] stringArray) {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
    }

    private void addRealmChild(HashSet hashSet, String string) {
        if (string.length() >= 1) {
            hashSet.add(string);
        }
    }

    private void addRealm(HashSet hashSet, RealmInfo realmInfo) {
        this.addRealmChildren(hashSet, realmInfo.auditors);
        this.addRealmChildren(hashSet, realmInfo.authenticationProviders);
        this.addRealmChildren(hashSet, realmInfo.roleMappers);
        this.addRealmChildren(hashSet, realmInfo.authorizers);
        this.addRealmChildren(hashSet, realmInfo.credentialMappers);
        this.addRealmChildren(hashSet, realmInfo.certPathProviders);
        this.addRealmChildren(hashSet, realmInfo.keyStores);
        this.addRealmChild(hashSet, realmInfo.adjudicator);
        this.addRealmChild(hashSet, realmInfo.certPathBuilder);
        this.addRealmChild(hashSet, realmInfo.userLockoutManager);
    }

    private HashSet getReferencedChildren() {
        HashSet hashSet = new HashSet();
        ListIterator listIterator = this.realmInfo.listIterator();
        while (listIterator.hasNext()) {
            RealmInfo realmInfo = (RealmInfo)listIterator.next();
            this.addRealm(hashSet, realmInfo);
        }
        return hashSet;
    }

    private void validateOrphans() {
        HashSet hashSet = this.getReferencedChildren();
        HashSet hashSet2 = new HashSet();
        ListIterator listIterator = this.childInfo.listIterator();
        while (listIterator.hasNext()) {
            ChildInfo childInfo = (ChildInfo)listIterator.next();
            if (hashSet.contains(childInfo.objectName)) continue;
            throw new ValidationException(this.formatter.getSecurityPre90UpgradeNotPossible(this.formatter.getSecurityPre90UpgradeUnreferencedRealmChildProblemProblem(childInfo.displayName), this.formatter.getSecurityPre90UpgradeNameSolution()));
        }
    }

    void validate() {
        this.validateObjectNames();
        this.validateRealms();
        this.validateOrphans();
    }

    public static void startValidation() {
        This = new SecurityPre90UpgradeXSLTUtils();
    }

    public static void validateRealm(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15) {
        RealmInfo realmInfo = new RealmInfo();
        realmInfo.objectName = SecurityPre90UpgradeXSLTUtils.getObjectName(string);
        realmInfo.displayName = SecurityPre90UpgradeXSLTUtils.getDisplayName(string2, string3);
        realmInfo.isDefault = SecurityPre90UpgradeXSLTUtils.getBooleanAttribute(string4);
        realmInfo.auditors = SecurityPre90UpgradeXSLTUtils.getObjectNames(string5);
        realmInfo.authenticationProviders = SecurityPre90UpgradeXSLTUtils.getObjectNames(string6);
        realmInfo.roleMappers = SecurityPre90UpgradeXSLTUtils.getObjectNames(string7);
        realmInfo.authorizers = SecurityPre90UpgradeXSLTUtils.getObjectNames(string8);
        realmInfo.credentialMappers = SecurityPre90UpgradeXSLTUtils.getObjectNames(string10);
        realmInfo.certPathProviders = SecurityPre90UpgradeXSLTUtils.getObjectNames(string11);
        realmInfo.keyStores = SecurityPre90UpgradeXSLTUtils.getObjectNames(string13);
        realmInfo.adjudicator = SecurityPre90UpgradeXSLTUtils.getObjectName(string9);
        realmInfo.certPathBuilder = SecurityPre90UpgradeXSLTUtils.getObjectName(string12);
        realmInfo.userLockoutManager = SecurityPre90UpgradeXSLTUtils.getObjectName(string14);
        realmInfo.isUseDeprecatedWebResource = SecurityPre90UpgradeXSLTUtils.getBooleanAttribute(string15);
        SecurityPre90UpgradeXSLTUtils.This.realmInfo.add(realmInfo);
    }

    public static void validateProviderOrULock(String string, String string2, String string3, String string4) {
        ChildInfo childInfo = new ChildInfo();
        childInfo.objectName = SecurityPre90UpgradeXSLTUtils.getObjectName(string);
        childInfo.displayName = SecurityPre90UpgradeXSLTUtils.getDisplayName(string2, string3);
        childInfo.realmObjectName = SecurityPre90UpgradeXSLTUtils.getObjectName(string4);
        SecurityPre90UpgradeXSLTUtils.This.childInfo.add(childInfo);
    }

    public static void endValidation() {
        This.validate();
    }

    static boolean getBooleanAttribute(String string) {
        return Boolean.valueOf(string);
    }

    static String getBooleanAttributeAsString(String string) {
        return SecurityPre90UpgradeXSLTUtils.getBooleanAttribute(string) ? "true" : "false";
    }

    public static String getIsDefaultRealm(String string) {
        return SecurityPre90UpgradeXSLTUtils.getBooleanAttributeAsString(string);
    }

    public static String getObjectName(String string) {
        return string != null ? string.trim() : "";
    }

    private static String[] getObjectNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = SecurityPre90UpgradeXSLTUtils.getObjectName(string2);
            if (string3.length() < 1) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getFirstObjectName(String string) {
        String[] stringArray = SecurityPre90UpgradeXSLTUtils.getObjectNames(string);
        return stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
    }

    public static String getRestOfObjectNames(String string) {
        String string2 = null;
        String[] stringArray = SecurityPre90UpgradeXSLTUtils.getObjectNames(string);
        for (int i = 1; stringArray != null && i < stringArray.length; ++i) {
            string2 = string2 == null ? stringArray[i] : string2 + SEPARATOR + stringArray[i];
        }
        return string2;
    }

    public static String getDisplayName(String string, String string2) {
        if (string != null && string.length() > 0) {
            return string;
        }
        if (string2 == null || string2.length() < 1) {
            throw new AssertionError((Object)"type is null or empty");
        }
        int n = string2.lastIndexOf(".");
        if (n == -1) {
            return string2;
        }
        return string2.substring(n + 1, string2.length());
    }

    public static String beforeVersion(String string, int n) {
        if (string == null || string.length() < 1) {
            throw new AssertionError((Object)"SecurityPre90UpgradeXSLTUtils.beforeVersion was passed an empty or null domain version.");
        }
        VersionInfo versionInfo = VersionInfoFactory.getVersionInfo();
        VersionInfo versionInfo2 = new VersionInfo(string);
        VersionInfo versionInfo3 = new VersionInfo(n - 1, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        return versionInfo2.laterThan((PackageInfo)versionInfo3) ? "false" : "true";
    }

    public static String getCompatibilityMode(String string, String string2, String string3, String string4, int n) {
        boolean bl;
        boolean bl2 = Boolean.valueOf(string2);
        boolean bl3 = Boolean.valueOf(string3);
        boolean bl4 = bl = string4 != null && string4.length() > 0;
        if (n > 0 || bl2) {
            return bl3 ? "true" : "false";
        }
        return bl || "true".equals(SecurityPre90UpgradeXSLTUtils.beforeVersion(string, 7)) ? "true" : "false";
    }

    public static int getDefaultSecurityConfigVersion(String string, String string2, String string3, String string4) {
        if ("true".equals(SecurityPre90UpgradeXSLTUtils.getCompatibilityMode(string, string2, string3, string4, 0))) {
            return 6;
        }
        return "true".equals(SecurityPre90UpgradeXSLTUtils.beforeVersion(string, 8)) ? 7 : 8;
    }

    private class ValidationException
    extends RuntimeException {
        private static final long serialVersionUID = 8365130643577135804L;

        ValidationException(String string) {
            super(string);
        }
    }

    private static class ChildInfo {
        String objectName;
        String displayName;
        String realmObjectName;

        private ChildInfo() {
        }
    }

    private static class RealmInfo {
        String objectName;
        String displayName;
        boolean isDefault;
        String[] auditors;
        String[] authenticationProviders;
        String[] roleMappers;
        String[] authorizers;
        String[] credentialMappers;
        String[] certPathProviders;
        String[] keyStores;
        String adjudicator;
        String certPathBuilder;
        String userLockoutManager;
        boolean isUseDeprecatedWebResource;

        private RealmInfo() {
        }
    }
}

