/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import weblogic.management.DomainDir;
import weblogic.security.Salt;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.FileUtils;
import weblogic.security.internal.FileWriter;
import weblogic.security.internal.SerializedSystemIniException;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.security.internal.encryption.JSafeEncryptionServiceImpl;
import weblogic.security.service.PrivilegedActions;

public final class SerializedSystemIni {
    private static final String PW = "0xccb97558940b82637c8bec3c770f86fa3a391a56";
    private static final int VERSION = 2;
    private static final String FILE = "SerializedSystemIni.dat";
    private static final int SALT_LENGTH = 4;
    private static final boolean DEBUG = false;
    private static final int UPDATE_VERSION = 1;
    private static SerializedSystemIni theInstance = null;
    private byte[] salt = null;
    private byte[] encryptedSecretKey = null;
    private byte[] encryptedAESSecretKey = null;
    private static AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static EncryptionService encryptionService = null;

    private static void debug(String string) {
    }

    private void generateSalt() {
        this.salt = Salt.getRandomBytes(4);
    }

    private void generateEncryptedSecretKey() {
        this.encryptedSecretKey = JSafeEncryptionServiceImpl.getFactory().createEncryptedSecretKey(this.salt, PW);
    }

    private void generateAESEncryptedSecretKey() {
        this.encryptedAESSecretKey = JSafeEncryptionServiceImpl.getFactory().createAESEncryptedSecretKey(this.salt, PW);
    }

    private byte[] readBytes(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new IOException("SerializedSystemIni is empty");
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n && (n2 = inputStream.read(byArray, i, n - i)) != -1; i += n2) {
        }
        return byArray;
    }

    private void write(String string, boolean bl) {
        if (bl) {
            SerializedSystemIni.ensureDomainSecurityDirExists();
        }
        FileWriter fileWriter = new FileWriter(){

            public void write(OutputStream outputStream) throws IOException {
                outputStream.write(SerializedSystemIni.this.salt.length);
                outputStream.write(SerializedSystemIni.this.salt);
                outputStream.write(2);
                outputStream.write(SerializedSystemIni.this.encryptedSecretKey.length);
                outputStream.write(SerializedSystemIni.this.encryptedSecretKey);
                outputStream.write(SerializedSystemIni.this.encryptedAESSecretKey.length);
                outputStream.write(SerializedSystemIni.this.encryptedAESSecretKey);
            }
        };
        FileUtils.replace(string, fileWriter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SerializedSystemIni(String string) {
        File file = new File(string);
        if (!file.exists()) {
            this.generateSalt();
            this.generateEncryptedSecretKey();
            this.generateAESEncryptedSecretKey();
            this.write(string, true);
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                block11: {
                    try {
                        this.salt = this.readBytes(fileInputStream);
                        int n = fileInputStream.read();
                        if (n == -1) break block11;
                        this.encryptedSecretKey = this.readBytes(fileInputStream);
                        if (n >= 2) {
                            this.encryptedAESSecretKey = this.readBytes(fileInputStream);
                        }
                    }
                    catch (IOException iOException) {
                        throw new SerializedSystemIniException(SecurityLogger.getIniCorruptFile((String)string), iOException);
                    }
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new SerializedSystemIniException(SecurityLogger.getIniCouldNotClose((String)string), iOException);
                }
            }
            try {}
            catch (IOException iOException) {
                throw new SerializedSystemIniException(SecurityLogger.getIniCouldNotClose((String)string), iOException);
            }
            fileInputStream.close();
            if (this.encryptedSecretKey != null) return;
            this.generateEncryptedSecretKey();
            this.generateAESEncryptedSecretKey();
            this.write(string, true);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SerializedSystemIniException(SecurityLogger.getIniErrorOpeningFile((String)string), fileNotFoundException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SerializedSystemIni(String string, int n) {
        File file = new File(string);
        if (!file.exists()) {
            throw new SerializedSystemIniException(SecurityLogger.getIniErrorOpeningFile((String)string));
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                try {
                    this.salt = this.readBytes(fileInputStream);
                    int n2 = fileInputStream.read();
                    if (n2 != n) {
                        throw new SerializedSystemIniException(SecurityLogger.getIniVersionMismatch((String)("" + n2), (String)("" + n)));
                    }
                    this.encryptedSecretKey = this.readBytes(fileInputStream);
                }
                catch (IOException iOException) {
                    throw new SerializedSystemIniException(SecurityLogger.getIniCorruptFile((String)string), iOException);
                }
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new SerializedSystemIniException(SecurityLogger.getIniCouldNotClose((String)string), iOException);
                }
            }
            try {}
            catch (IOException iOException) {
                throw new SerializedSystemIniException(SecurityLogger.getIniCouldNotClose((String)string), iOException);
            }
            fileInputStream.close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SerializedSystemIniException(SecurityLogger.getIniErrorOpeningFile((String)string), fileNotFoundException);
        }
    }

    private byte[] getTheSalt() {
        return this.salt;
    }

    private byte[] getTheEncryptedSecretKey() {
        return this.encryptedSecretKey;
    }

    private byte[] getTheAESEncryptedSecretKey() {
        return this.encryptedAESSecretKey;
    }

    private static synchronized void init() {
        if (theInstance == null) {
            theInstance = new SerializedSystemIni(DomainDir.getPathRelativeSecurityDir((String)FILE));
        }
    }

    public static boolean exists() {
        File file = new File(DomainDir.getPathRelativeSecurityDir((String)FILE));
        return file.exists();
    }

    public static String getPath() {
        return DomainDir.getPathRelativeSecurityDir((String)FILE);
    }

    public static byte[] getSalt(String string) {
        return new SerializedSystemIni(string).getTheSalt();
    }

    public static byte[] getSalt() {
        SerializedSystemIni.init();
        return theInstance.getTheSalt();
    }

    public static byte[] getEncryptedSecretKey() {
        SerializedSystemIni.init();
        return theInstance.getTheEncryptedSecretKey();
    }

    public static byte[] getEncryptedAESSecretKey() {
        SerializedSystemIni.init();
        return theInstance.getTheAESEncryptedSecretKey();
    }

    static EncryptionService getEncryptionService(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return JSafeEncryptionServiceImpl.getFactory().getEncryptionService(byArray, PW, byArray2, byArray3);
    }

    public static EncryptionService getExistingEncryptionService() {
        Object object;
        String string = DomainDir.getRootDir();
        Object object2 = string + File.separator + "security" + File.separator + FILE;
        File file = new File((String)object2);
        if (!file.exists()) {
            object = string + File.separator + FILE;
            File file2 = new File((String)object);
            if (file2.exists()) {
                object2 = object;
            } else {
                return null;
            }
        }
        object = new SerializedSystemIni((String)object2);
        return SerializedSystemIni.getEncryptionService(((SerializedSystemIni)object).getTheSalt(), ((SerializedSystemIni)object).getTheEncryptedSecretKey(), ((SerializedSystemIni)object).getTheAESEncryptedSecretKey());
    }

    public static EncryptionService getEncryptionService(String string) {
        Object object;
        File file;
        Object object2 = string + File.separator + "security" + File.separator + FILE;
        File file2 = new File((String)object2);
        if (!file2.exists() && (file = new File((String)(object = string + File.separator + FILE))).exists()) {
            object2 = object;
        }
        object = new SerializedSystemIni((String)object2);
        return SerializedSystemIni.getEncryptionService(((SerializedSystemIni)object).getTheSalt(), ((SerializedSystemIni)object).getTheEncryptedSecretKey(), ((SerializedSystemIni)object).getTheAESEncryptedSecretKey());
    }

    private static void ensureDomainSecurityDirExists() {
        File file = new File(DomainDir.getSecurityDir());
        if (!file.exists()) {
            try {
                file.mkdir();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    static void upgradeSSI() {
        File file = new File(DomainDir.getPathRelativeSecurityDir((String)FILE));
        if (file.exists()) {
            return;
        }
        File file2 = new File(DomainDir.getPathRelativeRootDir((String)FILE));
        if (!file2.exists()) {
            return;
        }
        SerializedSystemIni.ensureDomainSecurityDirExists();
        try {
            weblogic.utils.FileUtils.copy((File)file2, (File)file);
            if (file2.canWrite()) {
                file2.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static EncryptionService getEncryptionService() {
        if (encryptionService == null) {
            encryptionService = SerializedSystemIni.getEncryptionService(DomainDir.getRootDir());
        }
        return encryptionService;
    }

    public static void addAESKey() {
        SerializedSystemIni.updateDatFileWithAESKey(DomainDir.getPathRelativeSecurityDir((String)FILE));
    }

    public static void updateDatFileWithAESKey(String string) {
        SerializedSystemIni serializedSystemIni = new SerializedSystemIni(string, 1);
        serializedSystemIni.generateAESEncryptedSecretKey();
        serializedSystemIni.write(string, false);
    }

    public static void rollbackAESKey() {
        SerializedSystemIni.updateDatFileRollbackAESKey(DomainDir.getPathRelativeSecurityDir((String)FILE));
    }

    public static void updateDatFileRollbackAESKey(String string) {
        SerializedSystemIni serializedSystemIni = new SerializedSystemIni(string, 2);
        final byte[] byArray = serializedSystemIni.getTheSalt();
        final byte[] byArray2 = serializedSystemIni.getTheEncryptedSecretKey();
        FileWriter fileWriter = new FileWriter(){

            public void write(OutputStream outputStream) throws IOException {
                outputStream.write(byArray.length);
                outputStream.write(byArray);
                outputStream.write(1);
                outputStream.write(byArray2.length);
                outputStream.write(byArray2);
            }
        };
        FileUtils.replace(string, fileWriter);
    }
}

