/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.Properties;
import weblogic.management.Admin;
import weblogic.security.SecurityLogger;
import weblogic.security.SecurityMessagesTextFormatter;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.BootProperties;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.io.TerminalIO;

public final class ServerAuthenticate {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    private static boolean creatingDomain(String[] stringArray) {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!"domainCreation".equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        String string = ServerAuthenticate.getCommandLineProperty("weblogic.management.username");
        String string2 = ServerAuthenticate.getCommandLineProperty("weblogic.management.password");
        boolean bl = string != null && string2 != null;
        boolean bl2 = false;
        if (ServerAuthenticate.getCommandLineProperty("weblogic.security.TrustKeyStore") != null || ServerAuthenticate.getCommandLineProperty("weblogic.security.CustomTrustKeyStoreFileName") != null || ServerAuthenticate.getCommandLineProperty("weblogic.security.CustomTrustKeyStoreType") != null || ServerAuthenticate.getCommandLineProperty("weblogic.security.CustomTrustKeyStorePassPhrase") != null || ServerAuthenticate.getCommandLineProperty("weblogic.security.JavaStandardTrustKeyStorePassPhrase") != null) {
            bl2 = true;
        }
        if (bl && bl2) {
            return;
        }
        boolean bl3 = "true".equalsIgnoreCase(System.getProperty("weblogic.system.NodeManagerBoot"));
        String string3 = System.getProperty("weblogic.system.BootIdentityFile");
        SerializedSystemIni.upgradeSSI();
        if (BootProperties.exists(string3) && (bl3 || SerializedSystemIni.exists())) {
            BootProperties.load(string3, bl3);
        }
        BootProperties.upgradeBP(string3);
        BootProperties bootProperties = BootProperties.getBootProperties();
        if (!bl2 && bootProperties != null) {
            ServerAuthenticate.setCommandLineProperty("weblogic.security.TrustKeyStore", bootProperties.getTrustKeyStore());
            ServerAuthenticate.setCommandLineProperty("weblogic.security.CustomTrustKeyStoreFileName", bootProperties.getCustomTrustKeyStoreFileName());
            ServerAuthenticate.setCommandLineProperty("weblogic.security.CustomTrustKeyStoreType", bootProperties.getCustomTrustKeyStoreType());
            ServerAuthenticate.setCommandLineProperty("weblogic.security.CustomTrustKeyStorePassPhrase", bootProperties.getCustomTrustKeyStorePassPhrase());
            ServerAuthenticate.setCommandLineProperty("weblogic.security.JavaStandardTrustKeyStorePassPhrase", bootProperties.getJavaStandardTrustKeyStorePassPhrase());
        }
        if (bl) {
            return;
        }
        if (bl3 && bootProperties != null) {
            String string4;
            String string5 = bootProperties.getOne(kernelId);
            if (string5 == null) {
                string5 = "";
            }
            if ((string4 = bootProperties.getTwo(kernelId)) == null) {
                string4 = "";
            }
            BootProperties.unload(true);
            Properties properties = System.getProperties();
            properties.setProperty("weblogic.management.username", string5);
            properties.setProperty("weblogic.management.password", string4);
            return;
        }
        ServerAuthenticate.initUserNameAndPassword(ServerAuthenticate.creatingDomain(stringArray), BootProperties.getBootProperties());
    }

    private static void initUserNameAndPassword(boolean bl, BootProperties bootProperties) {
        SecurityMessagesTextFormatter securityMessagesTextFormatter = SecurityMessagesTextFormatter.getInstance();
        String string = null;
        String string2 = null;
        if (bootProperties != null) {
            string = bootProperties.getOne(kernelId);
            string2 = bootProperties.getTwo(kernelId);
        } else {
            SecurityLogger.logGettingBootIdentityFromUser();
        }
        if (string == null || "".equals(string.trim())) {
            string = System.getProperty("weblogic.management.username");
            if (string == null || "".equals(string.trim())) {
                string = ServerAuthenticate.promptValue(securityMessagesTextFormatter.getUsernamePromptMessage(), true);
            }
            if (string == null) {
                string = "";
            }
            string = string.trim();
        }
        if (string2 == null) {
            boolean bl2 = TerminalIO.isNoEchoAvailable();
            if (!bl2) {
                boolean bl3 = Admin.getInstance().isProductionModeEnabled();
                boolean bl4 = Admin.getInstance().isPasswordEchoAllowed();
                if (bl3 && !bl4) {
                    SecurityLogger.logErrorProductionModeNoEcho();
                    System.exit(-1);
                }
                if (!bl3 && !bl4) {
                    SecurityLogger.logErrorDevModeNoEcho();
                    System.exit(-1);
                }
            }
            string2 = ServerAuthenticate.promptForPassword(bl);
        }
        Properties properties = System.getProperties();
        properties.put("weblogic.management.username", string);
        properties.put("weblogic.management.password", string2);
    }

    private static String promptForPassword(boolean bl) {
        String string;
        SecurityMessagesTextFormatter securityMessagesTextFormatter = SecurityMessagesTextFormatter.getInstance();
        String string2 = ServerAuthenticate.promptValue(securityMessagesTextFormatter.getPasswordPromptMessage(), false);
        if (string2 == null) {
            string2 = "";
        }
        if (bl && !string2.equals(string = ServerAuthenticate.promptValue(securityMessagesTextFormatter.getPasswordPromptMessageRenter(), false))) {
            System.out.println(securityMessagesTextFormatter.getPasswordsNoMatch());
            String string3 = ServerAuthenticate.promptValue(securityMessagesTextFormatter.getPasswordPromptMessageRenter(), false);
            if (!string2.equals(string3)) {
                System.err.println("***************************************************************************");
                System.err.println(securityMessagesTextFormatter.getPasswordsNoMatchBoom());
                System.err.println("***************************************************************************");
                System.exit(-1);
            }
        }
        return string2;
    }

    public static String promptValue(String string, boolean bl) {
        String string2 = null;
        try {
            System.out.print(string);
            if (!bl && TerminalIO.isNoEchoAvailable()) {
                try {
                    string2 = TerminalIO.readTerminalNoEcho();
                    System.out.println("");
                }
                catch (Error error) {
                    System.err.println("Error: Failed to get value from Standard Input");
                }
            } else {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            System.err.println("Error: Failed to get value from Standard Input");
        }
        return string2;
    }

    private static String getCommandLineProperty(String string) {
        String string2 = System.getProperty(string);
        return string2 != null && string2.length() > 0 ? string2 : null;
    }

    private static void setCommandLineProperty(String string, String string2) {
        Properties properties = System.getProperties();
        if (string2 != null && string2.length() > 0) {
            properties.setProperty(string, string2);
        } else if (ServerAuthenticate.getCommandLineProperty(string) != null) {
            properties.remove(string);
        }
    }
}

