/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.security.AccessController;
import java.security.Principal;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.HMAC;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.principal.WLSServerIdentity;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.PrincipalValidator;

public class ServerPrincipalValidatorImpl
implements PrincipalValidator {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private byte[] secret;

    public boolean validate(Principal principal) throws SecurityException {
        if (!(principal instanceof WLSServerIdentity)) {
            return false;
        }
        WLSServerIdentity wLSServerIdentity = (WLSServerIdentity)principal;
        byte[] byArray = wLSServerIdentity.getSignature();
        if (byArray == null) {
            return false;
        }
        byte[] byArray2 = wLSServerIdentity.getSignedData();
        byte[] byArray3 = wLSServerIdentity.getSalt();
        return HMAC.verify((byte[])byArray, (byte[])byArray2, (byte[])this.getSecret(), (byte[])byArray3);
    }

    public boolean sign(Principal principal) {
        if (!(principal instanceof WLSServerIdentity)) {
            return false;
        }
        WLSServerIdentity wLSServerIdentity = (WLSServerIdentity)principal;
        SecurityServiceManager.checkKernelPermission();
        byte[] byArray = wLSServerIdentity.getSignedData();
        byte[] byArray2 = wLSServerIdentity.getSalt();
        wLSServerIdentity.setSignature(HMAC.digest((byte[])byArray, (byte[])this.getSecret(), (byte[])byArray2));
        return true;
    }

    public Class getPrincipalBaseClass() {
        return WLSServerIdentity.class;
    }

    private byte[] getSecret() {
        if (this.secret == null) {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            this.secret = runtimeAccess.getDomain().getSecurityConfiguration().getCredential().getBytes();
        }
        return this.secret;
    }
}

