/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal;

import java.security.AccessController;
import weblogic.management.security.authentication.UserLockoutManagerMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.InvalidParameterException;
import weblogic.security.service.NotYetInitializedException;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.shared.LoggerWrapper;

public final class UserLockoutManagerMBeanCustomizerImpl {
    private UserLockoutManagerMBean userLockoutManager;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static LoggerWrapper log = LoggerWrapper.getInstance("SecurityUserLockout");
    private PrincipalAuthenticator pa;

    public UserLockoutManagerMBeanCustomizerImpl(UserLockoutManagerMBean userLockoutManagerMBean) {
        this.userLockoutManager = userLockoutManagerMBean;
        if (log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl will use common security");
        }
    }

    private UserLockoutManagerMBean getUserLockoutManager() {
        return this.userLockoutManager;
    }

    private boolean initPA() {
        if (this.pa != null) {
            return true;
        }
        String string = this.getUserLockoutManager().getRealm().getName();
        if (string == null && log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl delaying initialization since its realm is not yet available.");
            return false;
        }
        try {
            this.pa = SecurityServiceManager.getPrincipalAuthenticator((AuthenticatedSubject)kernelId, (String)string);
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (NotYetInitializedException notYetInitializedException) {
            // empty catch block
        }
        if (this.pa == null) {
            if (log.isDebugEnabled()) {
                log.debug("UserLockoutManagerMBeanCustomizerImpl delaying initialization since it cannot get a PrincipalAuthenticator for realm " + string + ".");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl initialized for realm " + string);
        }
        return true;
    }

    public long getUserLockoutTotalCount() {
        if (this.initPA()) {
            return this.pa.getUserLockoutAdministrationService().getUserLockoutTotalCount();
        }
        if (log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl not yet initialized. getUserLockoutTotalCount returning 0.");
        }
        return 0L;
    }

    public long getInvalidLoginAttemptsTotalCount() {
        if (this.initPA()) {
            return this.pa.getUserLockoutAdministrationService().getInvalidLoginAttemptsTotalCount();
        }
        if (log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl not yet initialized. getInvalidLoginAttemptsTotalCount returning 0.");
        }
        return 0L;
    }

    public long getLoginAttemptsWhileLockedTotalCount() {
        if (this.initPA()) {
            return this.pa.getUserLockoutAdministrationService().getLoginAttemptsWhileLockedTotalCount();
        }
        if (log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl not yet initialized. getLoginAttemptsWhileLockedTotalCount returning 0.");
        }
        return 0L;
    }

    public long getInvalidLoginUsersHighCount() {
        if (this.initPA()) {
            return this.pa.getUserLockoutAdministrationService().getInvalidLoginUsersHighCount();
        }
        if (log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl not yet initialized. getInvalidLoginUsersHighCount returning 0.");
        }
        return 0L;
    }

    public long getUnlockedUsersTotalCount() {
        if (this.initPA()) {
            return this.pa.getUserLockoutAdministrationService().getUnlockedUsersTotalCount();
        }
        if (log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl not yet initialized. getUnlockedUserTotalCount returning 0.");
        }
        return 0L;
    }

    public long getLockedUsersCurrentCount() {
        if (this.initPA()) {
            return this.pa.getUserLockoutAdministrationService().getLockedUsersCurrentCount();
        }
        if (log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl not yet initialized. getLockedUsersCurrentCount returning 0.");
        }
        return 0L;
    }

    public boolean isLockedOut(String string) {
        if (this.initPA()) {
            return this.pa.getUserLockoutAdministrationService().isLockedOut(string);
        }
        if (log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl not yet initialized. isLockedOut returning false.");
        }
        return false;
    }

    public void clearLockout(String string) {
        if (this.initPA()) {
            this.pa.getUserLockoutAdministrationService().clearLockout(string);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl not yet initialized. clearLockout returning.");
        }
    }

    public long getLastLoginFailure(String string) {
        if (this.initPA()) {
            return this.pa.getUserLockoutAdministrationService().getLastLoginFailure(string);
        }
        if (log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl not yet initialized. getLastLoginFailure returning 0.");
        }
        return 0L;
    }

    public long getLoginFailureCount(String string) {
        if (this.initPA()) {
            return this.pa.getUserLockoutAdministrationService().getLoginFailureCount(string);
        }
        if (log.isDebugEnabled()) {
            log.debug("UserLockoutManagerMBeanCustomizerImpl not yet initialized. getLoginFailureCount returning 0.");
        }
        return 0L;
    }
}

