/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal.encryption;

import java.io.IOException;
import weblogic.security.SecurityLogger;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.security.internal.encryption.EncryptionServiceException;
import weblogic.security.internal.encryption.EncryptionServiceV2;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.encoders.BASE64Encoder;

public final class ClearOrEncryptedService {
    private String encryptedPrefix = null;
    private byte[] encryptedStartBytes = null;
    private EncryptionServiceV2 encryptionService = null;

    public ClearOrEncryptedService(EncryptionService encryptionService) {
        if (!(encryptionService instanceof EncryptionServiceV2)) {
            throw new EncryptionServiceException("IllegalStateException: Invalid Service");
        }
        this.encryptionService = (EncryptionServiceV2)encryptionService;
        this.encryptedPrefix = this.encryptionService.getDefaultKeyContext();
        this.encryptedStartBytes = "{".getBytes();
    }

    public boolean isEncrypted(String string) {
        String string2 = this.findPrefix(string);
        if (string2 == null) {
            return false;
        }
        return this.encryptionService.isKeyContextAvailable(string2);
    }

    public boolean isEncryptedBytes(byte[] byArray) {
        if (!this.startsWithBytes(this.encryptedStartBytes, byArray)) {
            return false;
        }
        return this.isEncrypted(new String(byArray));
    }

    public String encrypt(String string) {
        if (this.isEncrypted(string)) {
            return string;
        }
        byte[] byArray = this.encryptionService.encryptString(this.encryptedPrefix, string);
        String string2 = new BASE64Encoder().encodeBuffer(byArray);
        return this.encryptedPrefix + string2;
    }

    public byte[] encryptBytes(byte[] byArray) {
        if (this.isEncryptedBytes(byArray)) {
            return byArray;
        }
        byte[] byArray2 = this.encryptionService.encryptBytes(this.encryptedPrefix, byArray);
        String string = new BASE64Encoder().encodeBuffer(byArray2);
        return (this.encryptedPrefix + string).getBytes();
    }

    public String decrypt(String string) {
        String string2 = this.findPrefix(string);
        if (string2 == null) {
            return string;
        }
        if (!this.encryptionService.isKeyContextAvailable(string2)) {
            return string;
        }
        String string3 = string.substring(string2.length());
        try {
            byte[] byArray = new BASE64Decoder().decodeBuffer(string3);
            return this.encryptionService.decryptString(string2, byArray);
        }
        catch (IOException iOException) {
            throw new EncryptionServiceException(SecurityLogger.getDecodingError((String)("" + iOException)));
        }
    }

    public byte[] decryptBytes(byte[] byArray) {
        if (!this.startsWithBytes(this.encryptedStartBytes, byArray)) {
            return byArray;
        }
        String string = new String(byArray);
        String string2 = this.findPrefix(string);
        if (string2 == null) {
            return byArray;
        }
        if (!this.encryptionService.isKeyContextAvailable(string2)) {
            return byArray;
        }
        String string3 = string.substring(string2.length());
        try {
            byte[] byArray2 = new BASE64Decoder().decodeBuffer(string3);
            return this.encryptionService.decryptBytes(string2, byArray2);
        }
        catch (IOException iOException) {
            throw new EncryptionServiceException(SecurityLogger.getDecodingError((String)("" + iOException)));
        }
    }

    private boolean startsWithBytes(byte[] byArray, byte[] byArray2) {
        if (byArray2.length < byArray.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] bytesSubstring(byte[] byArray, int n) {
        int n2 = byArray.length - n;
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[i + n];
        }
        return byArray2;
    }

    private String findPrefix(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '{') {
            return null;
        }
        int n = string.indexOf(125);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n + 1);
    }
}

