/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal.encryption;

import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import weblogic.security.internal.encryption.EncryptionServiceException;
import weblogic.security.internal.encryption.EncryptionServiceFactory;
import weblogic.security.internal.encryption.EncryptionServiceV2;
import weblogic.security.internal.encryption.JSafeEncryptionServiceFactory;
import weblogic.security.internal.encryption.JSafeSecretKeyEncryptor;
import weblogic.security.shared.LoggerWrapper;

public final class JSafeEncryptionServiceImpl
implements EncryptionServiceV2 {
    static final String OVERALL_ALGORITHM = "3DES";
    static final String ALGORITHM_3DES = "3DES_EDE/CBC/PKCS5Padding";
    static final String ALGORITHM_AES = "AES/CBC/PKCS5Padding";
    static final String ALGORITHM_RANDOM = "FIPS186Random";
    private static final String PREFIX_3DES = "{3DES}";
    private static final int RANDOM_LEN_3DES = 0;
    private static final int KEY_LEN_3DES = 168;
    private static final String PREFIX_AES = "{AES}";
    private static final int RANDOM_LEN_AES = 16;
    private static final int KEY_LEN_AES = 128;
    static final String ENCODING = "UTF-8";
    private static LoggerWrapper logger = LoggerWrapper.getInstance("SecurityEncryptionService");
    private JSAFE_SecureRandom randomIV = null;
    private KeyContext keyContext3DES = null;
    private KeyContext keyContextAES = null;
    private HashMap keyContextMap = new HashMap(2);
    private static FIPS140Context NON_FIPS140_CONTEXT;
    private static final int INSTANCE_RANDOM_SEED_SIZE = 32;
    private static final Object seedingLock;
    private static JSAFE_SecureRandom seedingRandom;

    public byte[] encryptBytes(byte[] byArray) throws EncryptionServiceException {
        return this.encryptBytes(byArray, this.keyContext3DES);
    }

    private byte[] encryptBytes(byte[] byArray, KeyContext keyContext) throws EncryptionServiceException {
        byte[] byArray2;
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = this.getEncryptCipher(keyContext);
        byte[] byArray3 = null;
        try {
            if (logger.isDebugEnabled()) {
                JSafeEncryptionServiceImpl.log("starting encrypt operation " + keyContext.prefix);
            }
            int n = keyContext.randomLen;
            byArray3 = new byte[n + jSAFE_SymmetricCipher.getOutputBufferSize(byArray.length)];
            if (n > 0) {
                this.getRandomIV(byArray3, 0, n);
                jSAFE_SymmetricCipher.setIV(byArray3, 0, n);
                jSAFE_SymmetricCipher.encryptReInit();
            }
            int n2 = jSAFE_SymmetricCipher.encryptUpdate(byArray, 0, byArray.length, byArray3, n);
            int n3 = jSAFE_SymmetricCipher.encryptFinal(byArray3, n2 + n);
            if (logger.isDebugEnabled()) {
                JSafeEncryptionServiceImpl.log("done with encrypt operation " + keyContext.prefix);
            }
            byArray2 = byArray3;
            Object var10_10 = null;
        }
        catch (Exception exception) {
            try {
                throw new EncryptionServiceException(exception);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                jSAFE_SymmetricCipher.clearSensitiveData();
                throw throwable;
            }
        }
        jSAFE_SymmetricCipher.clearSensitiveData();
        return byArray2;
    }

    public byte[] decryptBytes(byte[] byArray) throws EncryptionServiceException {
        return this.decryptBytes(byArray, this.keyContext3DES);
    }

    private byte[] decryptBytes(byte[] byArray, KeyContext keyContext) throws EncryptionServiceException {
        byte[] byArray2;
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = this.getDecryptCipher(keyContext);
        byte[] byArray3 = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            if (logger.isDebugEnabled()) {
                JSafeEncryptionServiceImpl.log("starting decrypt operation " + keyContext.prefix);
            }
            if ((n5 = byArray.length - (n4 = keyContext.randomLen)) < 0) {
                throw new IllegalStateException("Invalid input length");
            }
            byArray3 = new byte[n5];
            if (n4 > 0) {
                jSAFE_SymmetricCipher.setIV(byArray, 0, n4);
                jSAFE_SymmetricCipher.decryptReInit();
            }
            if ((n3 = (n2 = jSAFE_SymmetricCipher.decryptUpdate(byArray, n4, n5, byArray3, 0)) + (n = jSAFE_SymmetricCipher.decryptFinal(byArray3, n2))) < byArray3.length) {
                byArray2 = new byte[n3];
                System.arraycopy(byArray3, 0, byArray2, 0, n3);
                byArray3 = byArray2;
            }
            if (logger.isDebugEnabled()) {
                JSafeEncryptionServiceImpl.log("done with decrypt operation " + keyContext.prefix);
            }
            byArray2 = byArray3;
            Object var12_12 = null;
        }
        catch (Exception exception) {
            try {
                if (logger.isDebugEnabled()) {
                    JSafeEncryptionServiceImpl.log("Esception during decrypt operation " + exception.getMessage());
                }
                throw new EncryptionServiceException();
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                jSAFE_SymmetricCipher.clearSensitiveData();
                throw throwable;
            }
        }
        jSAFE_SymmetricCipher.clearSensitiveData();
        return byArray2;
    }

    public byte[] encryptString(String string) throws EncryptionServiceException {
        try {
            return this.encryptBytes(string.getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncryptionServiceException(unsupportedEncodingException);
        }
    }

    public String decryptString(byte[] byArray) throws EncryptionServiceException {
        try {
            return new String(this.decryptBytes(byArray), ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncryptionServiceException(unsupportedEncodingException);
        }
    }

    public byte[] encryptBytes(String string, byte[] byArray) throws EncryptionServiceException {
        KeyContext keyContext = this.getKeyContextFromString(string);
        return this.encryptBytes(byArray, keyContext);
    }

    public byte[] decryptBytes(String string, byte[] byArray) throws EncryptionServiceException {
        KeyContext keyContext = this.getKeyContextFromString(string);
        return this.decryptBytes(byArray, keyContext);
    }

    public byte[] encryptString(String string, String string2) throws EncryptionServiceException {
        KeyContext keyContext = this.getKeyContextFromString(string);
        try {
            return this.encryptBytes(string2.getBytes(ENCODING), keyContext);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncryptionServiceException(unsupportedEncodingException);
        }
    }

    public String decryptString(String string, byte[] byArray) throws EncryptionServiceException {
        KeyContext keyContext = this.getKeyContextFromString(string);
        try {
            byte[] byArray2 = this.decryptBytes(byArray, keyContext);
            return new String(byArray2, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncryptionServiceException(unsupportedEncodingException);
        }
    }

    public boolean isKeyContextAvailable(String string) {
        return this.keyContextMap.containsKey(string);
    }

    public String getDefaultKeyContext() {
        if (this.keyContextAES != null) {
            return this.keyContextAES.prefix;
        }
        return this.keyContext3DES.prefix;
    }

    private KeyContext getKeyContextFromString(String string) {
        KeyContext keyContext = (KeyContext)this.keyContextMap.get(string);
        if (keyContext == null) {
            throw new IllegalStateException("KeyContext Unavailable!");
        }
        return keyContext;
    }

    static byte[] createEncryptedSecretKey(String string, byte[] byArray) throws EncryptionServiceException {
        return JSafeEncryptionServiceImpl.createEncryptedSecretKey(ALGORITHM_3DES, 168, string, byArray);
    }

    static byte[] createAESEncryptedSecretKey(String string, byte[] byArray) throws EncryptionServiceException {
        return JSafeEncryptionServiceImpl.createEncryptedSecretKey(ALGORITHM_AES, 128, string, byArray);
    }

    private static byte[] createEncryptedSecretKey(String string, int n, String string2, byte[] byArray) throws EncryptionServiceException {
        byte[] byArray2;
        char[] cArray = new char[string2.length()];
        string2.getChars(0, string2.length(), cArray, 0);
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = null;
        JSAFE_SecureRandom jSAFE_SecureRandom = null;
        JSAFE_SecretKey jSAFE_SecretKey = null;
        try {
            JSafeEncryptionServiceImpl.log("creating new key: " + string);
            int[] nArray = new int[]{n};
            jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance((String)string, (String)"Java");
            jSAFE_SecureRandom = JSafeEncryptionServiceImpl.getSeededSecureRandomInstance();
            jSAFE_SecretKey = jSAFE_SymmetricCipher.getBlankKey();
            jSAFE_SecretKey.generateInit(nArray, (SecureRandom)jSAFE_SecureRandom);
            jSAFE_SecretKey.generate();
            JSafeEncryptionServiceImpl.log("created new key: " + jSAFE_SecretKey.toString());
            byte[] byArray3 = JSafeSecretKeyEncryptor.encryptSecretKey(jSAFE_SecretKey, cArray, byArray);
            JSafeEncryptionServiceImpl.log("new key (encrypted) key byte array length: " + byArray3.length);
            byArray2 = byArray3;
            Object var12_12 = null;
        }
        catch (Exception exception) {
            try {
                throw new EncryptionServiceException(exception);
            }
            catch (Throwable throwable) {
                block11: {
                    Object var12_13 = null;
                    for (int i = 0; i < cArray.length; ++i) {
                        cArray[i] = '\u0000';
                    }
                    if (jSAFE_SymmetricCipher != null) {
                        jSAFE_SymmetricCipher.clearSensitiveData();
                    }
                    if (jSAFE_SecureRandom != null) {
                        jSAFE_SecureRandom.clearSensitiveData();
                    }
                    if (jSAFE_SecretKey == null) break block11;
                    jSAFE_SecretKey.clearSensitiveData();
                }
                throw throwable;
            }
        }
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = '\u0000';
        }
        if (jSAFE_SymmetricCipher != null) {
            jSAFE_SymmetricCipher.clearSensitiveData();
        }
        if (jSAFE_SecureRandom != null) {
            jSAFE_SecureRandom.clearSensitiveData();
        }
        if (jSAFE_SecretKey != null) {
            jSAFE_SecretKey.clearSensitiveData();
        }
        return byArray2;
    }

    static byte[] reEncryptSecretKey(String string, byte[] byArray, String string2, byte[] byArray2, String string3, byte[] byArray3) throws EncryptionServiceException {
        int n;
        byte[] byArray4;
        JSAFE_SecretKey jSAFE_SecretKey = null;
        char[] cArray = new char[string2.length()];
        string2.getChars(0, string2.length(), cArray, 0);
        char[] cArray2 = new char[string3.length()];
        string3.getChars(0, string3.length(), cArray2, 0);
        try {
            jSAFE_SecretKey = JSafeSecretKeyEncryptor.decryptSecretKey(string, byArray, cArray, byArray2);
            byArray4 = JSafeSecretKeyEncryptor.encryptSecretKey(jSAFE_SecretKey, cArray2, byArray3);
            Object var11_11 = null;
        }
        catch (Exception exception) {
            try {
                throw new EncryptionServiceException(exception);
            }
            catch (Throwable throwable) {
                block9: {
                    int n2;
                    Object var11_12 = null;
                    for (n2 = 0; n2 < cArray.length; ++n2) {
                        cArray[n2] = '\u0000';
                    }
                    for (n2 = 0; n2 < cArray2.length; ++n2) {
                        cArray2[n2] = '\u0000';
                    }
                    if (jSAFE_SecretKey == null) break block9;
                    jSAFE_SecretKey.clearSensitiveData();
                }
                throw throwable;
            }
        }
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = '\u0000';
        }
        for (n = 0; n < cArray2.length; ++n) {
            cArray2[n] = '\u0000';
        }
        if (jSAFE_SecretKey != null) {
            jSAFE_SecretKey.clearSensitiveData();
        }
        return byArray4;
    }

    public String getAlgorithm() {
        return OVERALL_ALGORITHM;
    }

    JSafeEncryptionServiceImpl(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) throws EncryptionServiceException {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        try {
            JSafeEncryptionServiceImpl.log("Encryption service constructor called");
            this.create3DESKeyContext(byArray, cArray, byArray2);
            if (byArray3 != null) {
                JSafeEncryptionServiceImpl.log("Encryption service AES key avilable");
                cArray = new char[string.length()];
                string.getChars(0, string.length(), cArray, 0);
                this.createAESKeyContext(byArray3, cArray, byArray2);
            }
        }
        catch (Exception exception) {
            throw new EncryptionServiceException(exception);
        }
    }

    private void create3DESKeyContext(byte[] byArray, char[] cArray, byte[] byArray2) throws EncryptionServiceException {
        KeyContext keyContext = new KeyContext();
        keyContext.prefix = PREFIX_3DES;
        keyContext.algorithm = ALGORITHM_3DES;
        keyContext.randomLen = 0;
        KeyContext.access$102(keyContext, JSafeSecretKeyEncryptor.doubleSalt(byArray2));
        this.createCiphers(keyContext, byArray, cArray, byArray2);
        this.keyContext3DES = keyContext;
    }

    private void createAESKeyContext(byte[] byArray, char[] cArray, byte[] byArray2) throws EncryptionServiceException {
        KeyContext keyContext = new KeyContext();
        keyContext.prefix = PREFIX_AES;
        keyContext.algorithm = ALGORITHM_AES;
        keyContext.randomLen = 16;
        KeyContext.access$102(keyContext, null);
        this.createCiphers(keyContext, byArray, cArray, byArray2);
        this.keyContextAES = keyContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createCiphers(KeyContext keyContext, byte[] byArray, char[] cArray, byte[] byArray2) throws EncryptionServiceException {
        JSAFE_SecretKey jSAFE_SecretKey = null;
        try {
            try {
                JSafeEncryptionServiceImpl.log("Initializing key: " + keyContext.prefix);
                jSAFE_SecretKey = JSafeSecretKeyEncryptor.decryptSecretKey(keyContext.algorithm, byArray, cArray, byArray2);
                JSafeEncryptionServiceImpl.log("key: " + jSAFE_SecretKey.toString());
                JSafeEncryptionServiceImpl.log("Initializing encrypt cipher");
                keyContext.encryptCipher = JSAFE_SymmetricCipher.getInstance((String)keyContext.algorithm, (String)"Java");
                if (keyContext.salt != null) {
                    keyContext.encryptCipher.setIV(keyContext.salt, 0, keyContext.salt.length);
                    JSafeEncryptionServiceImpl.log("encrypt IV Length: " + keyContext.salt.length);
                }
                keyContext.encryptCipher.encryptInit(jSAFE_SecretKey);
                JSafeEncryptionServiceImpl.log("Initializing decrypt cipher");
                keyContext.decryptCipher = JSAFE_SymmetricCipher.getInstance((String)keyContext.algorithm, (String)"Java");
                if (keyContext.salt != null) {
                    byte[] byArray3 = keyContext.encryptCipher.getIV();
                    keyContext.decryptCipher.setIV(byArray3, 0, byArray3.length);
                    JSafeEncryptionServiceImpl.log("decrypt IV Length: " + byArray3.length);
                }
                keyContext.decryptCipher.decryptInit(jSAFE_SecretKey);
                JSafeEncryptionServiceImpl.log("Placing KeyContext into Map: " + keyContext.prefix);
                this.keyContextMap.put(keyContext.prefix, keyContext);
            }
            catch (Exception exception) {
                throw new EncryptionServiceException(exception);
            }
            Object var8_8 = null;
            if (jSAFE_SecretKey == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (jSAFE_SecretKey == null) throw throwable;
            jSAFE_SecretKey.clearSensitiveData();
            throw throwable;
        }
        jSAFE_SecretKey.clearSensitiveData();
    }

    private synchronized void initRandomIV() throws NoSuchAlgorithmException {
        if (this.randomIV == null) {
            this.randomIV = JSafeEncryptionServiceImpl.getSeededSecureRandomInstance();
        }
    }

    private synchronized void getRandomIV(byte[] byArray, int n, int n2) throws Exception {
        this.initRandomIV();
        this.randomIV.generateRandomBytes(byArray, n, n2);
    }

    private synchronized JSAFE_SymmetricCipher getEncryptCipher(KeyContext keyContext) throws EncryptionServiceException {
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = null;
        try {
            jSAFE_SymmetricCipher = (JSAFE_SymmetricCipher)keyContext.encryptCipher.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new EncryptionServiceException(cloneNotSupportedException);
        }
        return jSAFE_SymmetricCipher;
    }

    private synchronized JSAFE_SymmetricCipher getDecryptCipher(KeyContext keyContext) throws EncryptionServiceException {
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = null;
        try {
            jSAFE_SymmetricCipher = (JSAFE_SymmetricCipher)keyContext.decryptCipher.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new EncryptionServiceException(cloneNotSupportedException);
        }
        return jSAFE_SymmetricCipher;
    }

    public static EncryptionServiceFactory getFactory() throws EncryptionServiceException {
        return new JSafeEncryptionServiceFactory();
    }

    public static void log(String string) {
        if (logger.isDebugEnabled()) {
            logger.debug(System.currentTimeMillis() + " : " + Thread.currentThread().getName() + " : " + string);
        }
    }

    public static JSAFE_SymmetricCipher getSymmetricCipher(String string, String string2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = null;
        jSAFE_SymmetricCipher = JSafeEncryptionServiceImpl.getNonFIPS140Ctx() == null ? JSAFE_SymmetricCipher.getInstance((String)string, (String)string2) : JSAFE_SymmetricCipher.getInstance((String)string, (String)string2, (FIPS140Context)JSafeEncryptionServiceImpl.getNonFIPS140Ctx());
        return jSAFE_SymmetricCipher;
    }

    public static FIPS140Context getNonFIPS140Ctx() {
        if (CryptoJ.isFIPS140Compliant() && NON_FIPS140_CONTEXT == null) {
            try {
                FIPS140Context fIPS140Context = CryptoJ.getFIPS140Context();
                NON_FIPS140_CONTEXT = fIPS140Context.setMode(1);
            }
            catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
                throw new EncryptionServiceException(jSAFE_InvalidUseException.getMessage());
            }
        }
        return NON_FIPS140_CONTEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSAFE_SecureRandom getSeededSecureRandomInstance() throws NoSuchAlgorithmException {
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance((String)ALGORITHM_RANDOM, (String)"Java");
        byte[] byArray = null;
        Object object = seedingLock;
        synchronized (object) {
            if (seedingRandom == null) {
                seedingRandom = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance((String)ALGORITHM_RANDOM, (String)"Java");
                seedingRandom.autoseed();
            }
            byArray = seedingRandom.generateRandomBytes(32);
        }
        jSAFE_SecureRandom.setSeed(byArray);
        return jSAFE_SecureRandom;
    }

    static {
        seedingLock = new Object();
        seedingRandom = null;
    }

    private class KeyContext {
        public String prefix;
        public String algorithm;
        public int randomLen;
        private byte[] salt;
        private JSAFE_SymmetricCipher encryptCipher;
        private JSAFE_SymmetricCipher decryptCipher;

        private KeyContext() {
        }

        static /* synthetic */ byte[] access$102(KeyContext keyContext, byte[] byArray) {
            keyContext.salt = byArray;
            return byArray;
        }
    }
}

