/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal.encryption;

import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import weblogic.security.SecurityLogger;
import weblogic.security.internal.encryption.EncryptionServiceException;
import weblogic.security.internal.encryption.JSafeEncryptionServiceImpl;
import weblogic.security.shared.LoggerWrapper;

final class JSafeSecretKeyEncryptor {
    private static final String KEY_ALGORITHM = "PBE/SHA1/RC2/CBC/PKCS12PBE-5-128";
    private static final int SALT_LENGTH = 8;
    private static LoggerWrapper logger = LoggerWrapper.getInstance("SecurityEncryptionService");

    JSafeSecretKeyEncryptor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] encryptSecretKey(JSAFE_SecretKey jSAFE_SecretKey, char[] cArray, byte[] byArray) throws EncryptionServiceException {
        byte[] byArray3 = JSafeSecretKeyEncryptor.doubleSalt(byArray);
        byte[] byArray4 = jSAFE_SecretKey.getSecretKeyData();
        JSafeEncryptionServiceImpl.log("Key material length: " + byArray4.length);
        byte[] byArray2 = null;
        JSAFE_SecretKey jSAFE_SecretKey2 = null;
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = null;
        try {
            try {
                jSAFE_SymmetricCipher = JSafeEncryptionServiceImpl.getSymmetricCipher(KEY_ALGORITHM, "Java");
                jSAFE_SymmetricCipher.setSalt(byArray, 0, byArray.length);
                jSAFE_SecretKey2 = jSAFE_SymmetricCipher.getBlankKey();
                jSAFE_SecretKey2.setPassword(cArray, 0, cArray.length);
                jSAFE_SymmetricCipher.encryptInit(jSAFE_SecretKey2);
                byArray2 = new byte[jSAFE_SymmetricCipher.getOutputBufferSize(byArray4.length)];
                int n = jSAFE_SymmetricCipher.encryptUpdate(byArray4, 0, byArray4.length, byArray2, 0);
                int n2 = jSAFE_SymmetricCipher.encryptFinal(byArray2, n);
            }
            catch (Exception exception) {
                throw new EncryptionServiceException(exception.toString());
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            jSAFE_SymmetricCipher.clearSensitiveData();
            jSAFE_SecretKey2.clearSensitiveData();
            int i = 0;
            while (true) {
                if (i >= cArray.length) {
                    throw throwable;
                }
                cArray[i] = '\u0000';
                ++i;
            }
        }
        jSAFE_SymmetricCipher.clearSensitiveData();
        jSAFE_SecretKey2.clearSensitiveData();
        int i = 0;
        while (i < cArray.length) {
            cArray[i] = '\u0000';
            ++i;
        }
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static JSAFE_SecretKey decryptSecretKey(String string, byte[] byArray, char[] cArray, byte[] byArray2) throws EncryptionServiceException {
        JSAFE_SecretKey jSAFE_SecretKey;
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher;
        block11: {
            byte[] byArray3 = JSafeSecretKeyEncryptor.doubleSalt(byArray2);
            byte[] byArray4 = new byte[byArray.length];
            JSafeSecretKeyEncryptor.log("key material length: " + byArray4.length);
            JSAFE_SecretKey jSAFE_SecretKey2 = null;
            jSAFE_SymmetricCipher = null;
            jSAFE_SecretKey = null;
            try {
                try {
                    jSAFE_SymmetricCipher = JSafeEncryptionServiceImpl.getSymmetricCipher(KEY_ALGORITHM, "Java");
                    jSAFE_SymmetricCipher.setSalt(byArray2, 0, byArray2.length);
                    jSAFE_SecretKey2 = jSAFE_SymmetricCipher.getBlankKey();
                    jSAFE_SecretKey2.setPassword(cArray, 0, cArray.length);
                    jSAFE_SymmetricCipher.decryptInit(jSAFE_SecretKey2);
                    int n = jSAFE_SymmetricCipher.decryptUpdate(byArray, 0, byArray.length, byArray4, 0);
                    int n2 = jSAFE_SymmetricCipher.decryptFinal(byArray4, n);
                    int n3 = n + n2;
                    JSafeSecretKeyEncryptor.log(n3 + " bytes of the array filled");
                    byte[] byArray5 = new byte[n3];
                    System.arraycopy(byArray4, 0, byArray5, 0, byArray5.length);
                    JSafeSecretKeyEncryptor.log("getting cipher to generate key");
                    jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance((String)string, (String)"Java");
                    JSafeSecretKeyEncryptor.log("blank key from cipher");
                    jSAFE_SecretKey = jSAFE_SymmetricCipher.getBlankKey();
                    JSafeSecretKeyEncryptor.log("setting key data: " + byArray5.length);
                    jSAFE_SecretKey.setSecretKeyData(byArray5, 0, byArray5.length);
                }
                catch (Exception exception) {
                    throw new EncryptionServiceException(SecurityLogger.getErrorDecryptingKey((String)exception.toString()));
                }
                Object var14_14 = null;
                if (jSAFE_SecretKey2 == null) break block11;
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (jSAFE_SecretKey2 != null) {
                    jSAFE_SecretKey2.clearSensitiveData();
                }
                if (jSAFE_SymmetricCipher != null) {
                    jSAFE_SymmetricCipher.clearSensitiveData();
                }
                int i = 0;
                while (true) {
                    if (i >= cArray.length) {
                        throw throwable;
                    }
                    cArray[i] = '\u0000';
                    ++i;
                }
            }
            jSAFE_SecretKey2.clearSensitiveData();
        }
        if (jSAFE_SymmetricCipher != null) {
            jSAFE_SymmetricCipher.clearSensitiveData();
        }
        int i = 0;
        while (i < cArray.length) {
            cArray[i] = '\u0000';
            ++i;
        }
        return jSAFE_SecretKey;
    }

    static byte[] doubleSalt(byte[] byArray) {
        if (byArray.length == 8) {
            return byArray;
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        System.arraycopy(byArray, 0, byArray2, 4, 4);
        return byArray2;
    }

    public static void log(String string) {
        if (logger.isDebugEnabled()) {
            logger.debug(System.currentTimeMillis() + " : " + Thread.currentThread().getName() + " : " + string);
        }
    }
}

