/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.internal.saml2;

import java.security.AccessController;
import weblogic.management.configuration.SingleSignOnServicesMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.shared.LoggerWrapper;

public class SAML2ServerConfig {
    public static final String SAML2_APP = "saml2";
    private static LoggerWrapper LOGGER = LoggerWrapper.getInstance("SecuritySAML2Service");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    protected static void logDebug(String string, String string2, String string3) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "." + string2 + "(): " + string3);
        }
    }

    private static void logDebug(String string, String string2) {
        SAML2ServerConfig.logDebug("SAML2ServerConfig", string, string2);
    }

    public static boolean isApplicationConfigured(String string) {
        if (!string.equals(SAML2_APP)) {
            SAML2ServerConfig.logDebug("isApplicationConfigured", "Unknown app '" + string + "', return false");
            return false;
        }
        SingleSignOnServicesMBean singleSignOnServicesMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getSingleSignOnServices();
        if (singleSignOnServicesMBean == null) {
            SAML2ServerConfig.logDebug("isApplicationConfigured", "SingleSignOnServicesMBean not found, return false");
            return false;
        }
        if (singleSignOnServicesMBean.isServiceProviderEnabled() || singleSignOnServicesMBean.isIdentityProviderEnabled()) {
            SAML2ServerConfig.logDebug("isApplicationConfigured", "SingleSignOnMBean IdP or SP is enabled, return true");
            return true;
        }
        SAML2ServerConfig.logDebug("isApplicationConfigured", "SingleSignOnMBean neither IdP nor SP is enabled, return false");
        return false;
    }
}

